/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemAdTransportadorAgregado;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ADIANTAMENTO_TRANSP_AGREGADO", uniqueConstraints={@UniqueConstraint(name="UNQ1_ADIANTAMENTO_TRANSP_AGREGA", columnNames={"ID_TITULO"})})
public class AdiantamentoTransportadorAgregado
implements InterfaceVO {
    private Long identificador;
    private TransportadorAgregado transportadorAgregado;
    private Double valor = 0.0;
    private Short numParcelas = 1;
    private Date data;
    private String observacao;
    private Titulo titulo;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<ItemAdTransportadorAgregado> itensAdTranspAgregado = new ArrayList<ItemAdTransportadorAgregado>();

    @Id
    @Column(name="ID_ADIANTAMENTO_TRANSP_AGREGADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ADIANT_TRANSP_AGREGADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_AGREGADO", foreignKey=@ForeignKey(name="FK_ADIANT_TRANSP_AGREG_TR_AGREG"))
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA")
    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_ADIANT_TRANSP_AGREG_TITULO"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ADIANT_TRANSP_AGREG_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="NUM_PARCELAS")
    public Short getNumParcelas() {
        return this.numParcelas;
    }

    public void setNumParcelas(Short numParcelas) {
        this.numParcelas = numParcelas;
    }

    @OneToMany(mappedBy="adiantamentoTranspAgregado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemAdTransportadorAgregado> getItensAdTranspAgregado() {
        return this.itensAdTranspAgregado;
    }

    public void setItensAdTranspAgregado(List<ItemAdTransportadorAgregado> itensAdTranspAgregado) {
        this.itensAdTranspAgregado = itensAdTranspAgregado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

