/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.analisecustoprod.EnumAnaCustoTipoProcDevolucoes;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProd;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelProdRateio;
import com.touchcomp.basementor.model.vo.AnaliseCustoCelRatOp;
import com.touchcomp.basementor.model.vo.AnaliseCustoCenCusto;
import com.touchcomp.basementor.model.vo.AnaliseCustoHoraColab;
import com.touchcomp.basementor.model.vo.AnaliseCustoMedConsAtivo;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoConta;
import com.touchcomp.basementor.model.vo.AnaliseCustoPlanoContaGer;
import com.touchcomp.basementor.model.vo.AnaliseCustoProdLog;
import com.touchcomp.basementor.model.vo.AnaliseCustoProdOrdemProc;
import com.touchcomp.basementor.model.vo.AnaliseCustoSubespecie;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ANALISE_CUSTO_PROD")
public class AnaliseCustoProd
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String descricao;
    private String observacao;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date periodo;
    private Date dataInicial;
    private Date dataFinal;
    private Short tipoRateio = 1;
    private List<AnaliseCustoCelProd> analiseCustoCelProd = new ArrayList<AnaliseCustoCelProd>();
    private List<AnaliseCustoProdOrdemProc> analiseCustoOrdemProcProdutos;
    private List<AnaliseCustoPlanoConta> analiseCustoPlanoConta = new ArrayList<AnaliseCustoPlanoConta>();
    private List<AnaliseCustoPlanoContaGer> analiseCustoPlanoContaGer;
    private List<AnaliseCustoMedConsAtivo> analiseCustoMedConsAtivo = new ArrayList<AnaliseCustoMedConsAtivo>();
    private List<AnaliseCustoCenCusto> analiseCentroCusto = new ArrayList<AnaliseCustoCenCusto>();
    private List<AnaliseCustoCelProdRateio> analiseCustoCelProdRateio = new ArrayList<AnaliseCustoCelProdRateio>();
    private List<AnaliseCustoHoraColab> analiseCustoHoraColab = new ArrayList<AnaliseCustoHoraColab>();
    private List<AnaliseCustoCelRatOp> analiseCustoProdRatOP;
    private List<AnaliseCustoSubespecie> analiseCustoSubespecies;
    private Short reprocessarHorasEvtAnalCustoLP = 0;
    private Short tipoAnaliseCustoMan = 2;
    private Short tipoAnalise = 1;
    private Short tipoRateioPeso = 2;
    private Short tipoProcDevolucoes;
    private AnaliseCustoProd analiseCustoProdBase;
    private AnaliseCustoProdLog analiseCustoProdLog;
    private Double valorTotalInicial = 0.0;
    private Double valorTotalFinal = 0.0;
    private Double valorTotalInicialConsiderado = 0.0;
    private Double valorTotalFinalConsiderado = 0.0;
    private Short respeitarCentroResEmpresa = 0;
    private Short tipoSaldoContGer = 0;
    private Short tipoLancContGer = 2;
    private Short tipoSaldoCont = 2;
    private Short considerarVlrHoraCel = 0;

    public AnaliseCustoProd() {
        this.analiseCustoPlanoContaGer = new ArrayList<AnaliseCustoPlanoContaGer>();
        this.analiseCustoProdRatOP = new ArrayList<AnaliseCustoCelRatOp>();
        this.analiseCustoSubespecies = new ArrayList<AnaliseCustoSubespecie>();
        this.analiseCustoOrdemProcProdutos = new ArrayList<AnaliseCustoProdOrdemProc>();
        this.tipoProcDevolucoes = EnumAnaCustoTipoProcDevolucoes.NAO_REPROCESSAR.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_ANALISE_CUSTO_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ANALISE_CUSTO_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ANALISE_CUSTO_PROD_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoCelProd> getAnaliseCustoCelProd() {
        return this.analiseCustoCelProd;
    }

    public void setAnaliseCustoCelProd(List<AnaliseCustoCelProd> analiseCustoCelProd) {
        this.analiseCustoCelProd = analiseCustoCelProd;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoPlanoConta> getAnaliseCustoPlanoConta() {
        return this.analiseCustoPlanoConta;
    }

    public void setAnaliseCustoPlanoConta(List<AnaliseCustoPlanoConta> analiseCustoPlanoConta) {
        this.analiseCustoPlanoConta = analiseCustoPlanoConta;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoMedConsAtivo> getAnaliseCustoMedConsAtivo() {
        return this.analiseCustoMedConsAtivo;
    }

    public void setAnaliseCustoMedConsAtivo(List<AnaliseCustoMedConsAtivo> analiseCustoMedConsAtivo) {
        this.analiseCustoMedConsAtivo = analiseCustoMedConsAtivo;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoCenCusto> getAnaliseCentroCusto() {
        return this.analiseCentroCusto;
    }

    public void setAnaliseCentroCusto(List<AnaliseCustoCenCusto> analiseCentroCusto) {
        this.analiseCentroCusto = analiseCentroCusto;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoCelProdRateio> getAnaliseCustoCelProdRateio() {
        return this.analiseCustoCelProdRateio;
    }

    public void setAnaliseCustoCelProdRateio(List<AnaliseCustoCelProdRateio> analiseCustoCelProdRateio) {
        this.analiseCustoCelProdRateio = analiseCustoCelProdRateio;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoHoraColab> getAnaliseCustoHoraColab() {
        return this.analiseCustoHoraColab;
    }

    public void setAnaliseCustoHoraColab(List<AnaliseCustoHoraColab> analiseCustoHoraColab) {
        this.analiseCustoHoraColab = analiseCustoHoraColab;
    }

    @Column(name="TIPO_RATEIO")
    public Short getTipoRateio() {
        return this.tipoRateio;
    }

    public void setTipoRateio(Short tipoRateio) {
        this.tipoRateio = tipoRateio;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="REPROC_HORAS_EVT_ANAL_CUSTO_LP")
    public Short getReprocessarHorasEvtAnalCustoLP() {
        return this.reprocessarHorasEvtAnalCustoLP;
    }

    public void setReprocessarHorasEvtAnalCustoLP(Short reprocessarHorasEvtAnalCustoLP) {
        this.reprocessarHorasEvtAnalCustoLP = reprocessarHorasEvtAnalCustoLP;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoPlanoContaGer> getAnaliseCustoPlanoContaGer() {
        return this.analiseCustoPlanoContaGer;
    }

    public void setAnaliseCustoPlanoContaGer(List<AnaliseCustoPlanoContaGer> analiseCustoPlanoContaGer) {
        this.analiseCustoPlanoContaGer = analiseCustoPlanoContaGer;
    }

    @OneToMany(mappedBy="analiseCustoProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AnaliseCustoCelRatOp> getAnaliseCustoProdRatOP() {
        return this.analiseCustoProdRatOP;
    }

    public void setAnaliseCustoProdRatOP(List<AnaliseCustoCelRatOp> analiseCustoProd) {
        this.analiseCustoProdRatOP = analiseCustoProd;
    }

    @Column(name="TIPO_ANALISE_CUSTO_MAN")
    public Short getTipoAnaliseCustoMan() {
        return this.tipoAnaliseCustoMan;
    }

    public void setTipoAnaliseCustoMan(Short tipoAnaliseCustoMan) {
        this.tipoAnaliseCustoMan = tipoAnaliseCustoMan;
    }

    @JoinColumn(name="ID_ANALISE_CUSTO_PR_BASE", foreignKey=@ForeignKey(name="FK_ANALISE_CUSTO_PROD_AN_BASE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public AnaliseCustoProd getAnaliseCustoProdBase() {
        return this.analiseCustoProdBase;
    }

    public void setAnaliseCustoProdBase(AnaliseCustoProd analiseCustoProdBase) {
        this.analiseCustoProdBase = analiseCustoProdBase;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao(), ToolDate.dateToStr((Date)this.getPeriodo())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_ANALISE")
    public Short getTipoAnalise() {
        return this.tipoAnalise;
    }

    public void setTipoAnalise(Short tipoAnalise) {
        this.tipoAnalise = tipoAnalise;
    }

    @OneToOne(mappedBy="analiseCustoProd")
    public AnaliseCustoProdLog getAnaliseCustoProdLog() {
        return this.analiseCustoProdLog;
    }

    public void setAnaliseCustoProdLog(AnaliseCustoProdLog analiseCustoProdLog) {
        this.analiseCustoProdLog = analiseCustoProdLog;
    }

    @Column(name="TIPO_RATEIO_PESO")
    public Short getTipoRateioPeso() {
        return this.tipoRateioPeso;
    }

    public void setTipoRateioPeso(Short tipoRateioPeso) {
        this.tipoRateioPeso = tipoRateioPeso;
    }

    @Column(name="VALOR_TOTAL_INICIAL", precision=15, scale=2)
    public Double getValorTotalInicial() {
        return this.valorTotalInicial;
    }

    public void setValorTotalInicial(Double valorTotalInicial) {
        this.valorTotalInicial = valorTotalInicial;
    }

    @Column(name="VALOR_TOTAL_FINAL", precision=15, scale=2)
    public Double getValorTotalFinal() {
        return this.valorTotalFinal;
    }

    public void setValorTotalFinal(Double valorTotalFinal) {
        this.valorTotalFinal = valorTotalFinal;
    }

    @Column(name="VALOR_TOTAL_INICIAL_CONSID", precision=15, scale=2)
    public Double getValorTotalInicialConsiderado() {
        return this.valorTotalInicialConsiderado;
    }

    public void setValorTotalInicialConsiderado(Double valorTotalInicialConsiderado) {
        this.valorTotalInicialConsiderado = valorTotalInicialConsiderado;
    }

    @Column(name="VALOR_TOTAL_FINAL_CONSID", precision=15, scale=2)
    public Double getValorTotalFinalConsiderado() {
        return this.valorTotalFinalConsiderado;
    }

    public void setValorTotalFinalConsiderado(Double valorTotalFinalConsiderado) {
        this.valorTotalFinalConsiderado = valorTotalFinalConsiderado;
    }

    @Column(name="RESPEITAR_CENTRO_RES_EMPRESA")
    public Short getRespeitarCentroResEmpresa() {
        return this.respeitarCentroResEmpresa;
    }

    public void setRespeitarCentroResEmpresa(Short respeitarCentroResEmpresa) {
        this.respeitarCentroResEmpresa = respeitarCentroResEmpresa;
    }

    @Column(name="TIPO_SALDO_CONT_GER")
    public Short getTipoSaldoContGer() {
        return this.tipoSaldoContGer;
    }

    public void setTipoSaldoContGer(Short tipoSaldoContGer) {
        this.tipoSaldoContGer = tipoSaldoContGer;
    }

    @Column(name="TIPO_LANC_CONT_GER")
    public Short getTipoLancContGer() {
        return this.tipoLancContGer;
    }

    public void setTipoLancContGer(Short tipoLancContGer) {
        this.tipoLancContGer = tipoLancContGer;
    }

    @Column(name="TIPO_SALDO_CONT")
    public Short getTipoSaldoCont() {
        return this.tipoSaldoCont;
    }

    public void setTipoSaldoCont(Short tipoSaldoCont) {
        this.tipoSaldoCont = tipoSaldoCont;
    }

    @OneToMany(mappedBy="analiseCustoProd", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<AnaliseCustoSubespecie> getAnaliseCustoSubespecies() {
        return this.analiseCustoSubespecies;
    }

    public void setAnaliseCustoSubespecies(List<AnaliseCustoSubespecie> analiseCustoSubespecies) {
        this.analiseCustoSubespecies = analiseCustoSubespecies;
    }

    @Column(name="CONSIDERAR_VLR_HORA_CEL")
    public Short getConsiderarVlrHoraCel() {
        return this.considerarVlrHoraCel;
    }

    public void setConsiderarVlrHoraCel(Short considerarVlrHoraCel) {
        this.considerarVlrHoraCel = considerarVlrHoraCel;
    }

    @OneToMany(mappedBy="analiseCustoProd", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<AnaliseCustoProdOrdemProc> getAnaliseCustoOrdemProcProdutos() {
        return this.analiseCustoOrdemProcProdutos;
    }

    public void setAnaliseCustoOrdemProcProdutos(List<AnaliseCustoProdOrdemProc> analiseCustoOrdemProcProdutos) {
        this.analiseCustoOrdemProcProdutos = analiseCustoOrdemProcProdutos;
    }

    @Column(name="TIPO_PROC_DEVOLUCOES")
    public Short getTipoProcDevolucoes() {
        return this.tipoProcDevolucoes;
    }

    public void setTipoProcDevolucoes(Short tipoProcDevolucoes) {
        this.tipoProcDevolucoes = tipoProcDevolucoes;
    }
}

