/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.ItemApuracaoValoresCooperados;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APURACAO_VALORES_COOPERADOS")
public class ApuracaoValoresCooperados
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<ItemApuracaoValoresCooperados> valoresCooperados = new ArrayList<ItemApuracaoValoresCooperados>();
    private TipoCooperado tipoCooperado;
    private GrupoDeBaixa grupoBaixaRecebimento;
    private GrupoDeBaixa grupoBaixaPagamento;
    private Date dataInicial;
    private Date dataFinal;
    private ContaValores contaBaixas;
    private Short tipoApuracao = 0;
    private Date dataEmissaoInicial;
    private Date dataEmissaoFinal;
    private Date dataEmissaoTitGerar;
    private List<MeioPagamento> meiosPagamentos = new ArrayList<MeioPagamento>();
    private Short gerarTituloDevedor = 0;
    private Date dataVencimentoTitulo;
    private TipoDoc tipoDocTitulo;
    private MeioPagamento meioPagamentoTitulo;
    private CarteiraCobranca carteiraCobrancaTitulo;
    private Date dataVencimentoDebitoConta;
    private TipoDoc tipoDocDebitoConta;
    private MeioPagamento meioPagamentoDebitoConta;
    private CarteiraCobranca carteiraCobrancaDebitoConta;
    private Short formaPagamento = 1;
    private String descricao;
    private Date dataVencimentoSomenteTitulo;
    private TipoDoc tipoDocSomenteTitulo;
    private MeioPagamento meioPagamentoSomenteTitulo;
    private CarteiraCobranca carteiraCobrancaSomenteTitulo;
    private ClassificacaoClientes classificacaoClientes;
    private Short gerarTituloCredor = 0;
    private Date dataVencimentoTituloCredor;
    private TipoDoc tipoDocTituloCredor;
    private MeioPagamento meioPagamentoTituloCredor;
    private CarteiraCobranca carteiraCobrancaTituloCredor;
    private PlanoContaGerencial planoGerencialTitulo;
    private PlanoContaGerencial planoGerencialDebitoConta;
    private PlanoContaGerencial planoGerencialSomenteTitulo;
    private PlanoContaGerencial planoGerencialTituloCredor;
    private Short naoApurarTitulosPeridoAnterior = 0;
    private Short tipoCliente = 0;
    private CategoriaPessoa categoriaPessoa;
    private Date dataBaixa;
    private LoteContabil loteContabil;

    @Id
    @Column(nullable=false, name="ID_APURACAO_VALORES_COOPERADOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACAO_VALORES_COOPERADOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APURACAO_VALORES_COOPERADOS_"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracaoValoresCooperado", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemApuracaoValoresCooperados> getValoresCooperados() {
        return this.valoresCooperados;
    }

    public void setValoresCooperados(List<ItemApuracaoValoresCooperados> valoresCooperados) {
        this.valoresCooperados = valoresCooperados;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.getIdentificador(), this.getDataInicial(), this.getDataFinal()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_GRUPO_BAIXA_RECEBIMENTO", foreignKey=@ForeignKey(name="FK_APURACAO_VALORES_GR_REC"))
    public GrupoDeBaixa getGrupoBaixaRecebimento() {
        return this.grupoBaixaRecebimento;
    }

    public void setGrupoBaixaRecebimento(GrupoDeBaixa grupoBaixaRecebimento) {
        this.grupoBaixaRecebimento = grupoBaixaRecebimento;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_GRUPO_BAIXA_PAGAMENTO", foreignKey=@ForeignKey(name="FK_APURACAO_VALORES_COOP_PAG"))
    public GrupoDeBaixa getGrupoBaixaPagamento() {
        return this.grupoBaixaPagamento;
    }

    public void setGrupoBaixaPagamento(GrupoDeBaixa grupoBaixaPagamento) {
        this.grupoBaixaPagamento = grupoBaixaPagamento;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_COOPERADO", foreignKey=@ForeignKey(name="FK_APURACAO_VALORES1"))
    public TipoCooperado getTipoCooperado() {
        return this.tipoCooperado;
    }

    public void setTipoCooperado(TipoCooperado tipoCooperado) {
        this.tipoCooperado = tipoCooperado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_BAIXAS", foreignKey=@ForeignKey(name="FK_APURACAO_VALORES_COOPER"))
    public ContaValores getContaBaixas() {
        return this.contaBaixas;
    }

    public void setContaBaixas(ContaValores contaBaixas) {
        this.contaBaixas = contaBaixas;
    }

    @Column(name="TIPO_APURACAO")
    public Short getTipoApuracao() {
        return this.tipoApuracao;
    }

    public void setTipoApuracao(Short tipoApuracao) {
        this.tipoApuracao = tipoApuracao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_INICIAL")
    public Date getDataEmissaoInicial() {
        return this.dataEmissaoInicial;
    }

    public void setDataEmissaoInicial(Date dataEmissaoInicial) {
        this.dataEmissaoInicial = dataEmissaoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_FINAL")
    public Date getDataEmissaoFinal() {
        return this.dataEmissaoFinal;
    }

    public void setDataEmissaoFinal(Date dataEmissaoFinal) {
        this.dataEmissaoFinal = dataEmissaoFinal;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="APUR_VAL_COOPERADO_MEIO_PAG", joinColumns={@JoinColumn(name="ID_APURACAO_VALORES_COOPERADOS")}, inverseJoinColumns={@JoinColumn(name="ID_MEIO_PAGAMENTO")})
    public List<MeioPagamento> getMeiosPagamentos() {
        return this.meiosPagamentos;
    }

    public void setMeiosPagamentos(List<MeioPagamento> meiosPagamentos) {
        this.meiosPagamentos = meiosPagamentos;
    }

    @Column(name="GERAR_TITULO_DEVEDOR")
    public Short getGerarTituloDevedor() {
        return this.gerarTituloDevedor;
    }

    public void setGerarTituloDevedor(Short gerarTituloDevedor) {
        this.gerarTituloDevedor = gerarTituloDevedor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_TITULO")
    public Date getDataVencimentoTitulo() {
        return this.dataVencimentoTitulo;
    }

    public void setDataVencimentoTitulo(Date dataVencimentoTitulo) {
        this.dataVencimentoTitulo = dataVencimentoTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_TITULO", foreignKey=@ForeignKey(name="FK_AP_VAL_COOPERADOS_TIPO_DOC"))
    public TipoDoc getTipoDocTitulo() {
        return this.tipoDocTitulo;
    }

    public void setTipoDocTitulo(TipoDoc tipoDocTitulo) {
        this.tipoDocTitulo = tipoDocTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_TITULO", foreignKey=@ForeignKey(name="FK_AP_VAL_COOPERADOS_MEIO_PAG"))
    public MeioPagamento getMeioPagamentoTitulo() {
        return this.meioPagamentoTitulo;
    }

    public void setMeioPagamentoTitulo(MeioPagamento meioPagamentoTitulo) {
        this.meioPagamentoTitulo = meioPagamentoTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_TITULO", foreignKey=@ForeignKey(name="FK_AP_VAL_COOPERADOS_CART_COBR"))
    public CarteiraCobranca getCarteiraCobrancaTitulo() {
        return this.carteiraCobrancaTitulo;
    }

    public void setCarteiraCobrancaTitulo(CarteiraCobranca carteiraCobrancaTitulo) {
        this.carteiraCobrancaTitulo = carteiraCobrancaTitulo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_DEBITO_CONTA")
    public Date getDataVencimentoDebitoConta() {
        return this.dataVencimentoDebitoConta;
    }

    public void setDataVencimentoDebitoConta(Date dataVencimentoDebitoConta) {
        this.dataVencimentoDebitoConta = dataVencimentoDebitoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_DEBITO_CONTA", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_TIPO_DOC_DEB"))
    public TipoDoc getTipoDocDebitoConta() {
        return this.tipoDocDebitoConta;
    }

    public void setTipoDocDebitoConta(TipoDoc tipoDocDebitoConta) {
        this.tipoDocDebitoConta = tipoDocDebitoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_DEBITO_CONTA", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_MEIO_PAG_DEB"))
    public MeioPagamento getMeioPagamentoDebitoConta() {
        return this.meioPagamentoDebitoConta;
    }

    public void setMeioPagamentoDebitoConta(MeioPagamento meioPagamentoDebitoConta) {
        this.meioPagamentoDebitoConta = meioPagamentoDebitoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_DEB_CONTA", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_CART_COBR_DEB"))
    public CarteiraCobranca getCarteiraCobrancaDebitoConta() {
        return this.carteiraCobrancaDebitoConta;
    }

    public void setCarteiraCobrancaDebitoConta(CarteiraCobranca carteiraCobrancaDebitoConta) {
        this.carteiraCobrancaDebitoConta = carteiraCobrancaDebitoConta;
    }

    @Column(name="FORMA_PAGAMENTO")
    public Short getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(Short formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_SOMENTE_TITULO")
    public Date getDataVencimentoSomenteTitulo() {
        return this.dataVencimentoSomenteTitulo;
    }

    public void setDataVencimentoSomenteTitulo(Date dataVencimentoSomenteTitulo) {
        this.dataVencimentoSomenteTitulo = dataVencimentoSomenteTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_SOMENTE_TITULO", foreignKey=@ForeignKey(name="FK_APUR_VAL_COOP_TIPO_DOC_TIT"))
    public TipoDoc getTipoDocSomenteTitulo() {
        return this.tipoDocSomenteTitulo;
    }

    public void setTipoDocSomenteTitulo(TipoDoc tipoDocSomenteTitulo) {
        this.tipoDocSomenteTitulo = tipoDocSomenteTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAG_SOMENTE_TITULO", foreignKey=@ForeignKey(name="FK_APUR_VAL_COOP_MEIIO_PAG_TIT"))
    public MeioPagamento getMeioPagamentoSomenteTitulo() {
        return this.meioPagamentoSomenteTitulo;
    }

    public void setMeioPagamentoSomenteTitulo(MeioPagamento meioPagamentoSomenteTitulo) {
        this.meioPagamentoSomenteTitulo = meioPagamentoSomenteTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CART_COBRANCA_SOMENTE_TITULO", foreignKey=@ForeignKey(name="FK_APUR_VAL_COOP_CART_COB_TIT"))
    public CarteiraCobranca getCarteiraCobrancaSomenteTitulo() {
        return this.carteiraCobrancaSomenteTitulo;
    }

    public void setCarteiraCobrancaSomenteTitulo(CarteiraCobranca carteiraCobrancaSomenteTitulo) {
        this.carteiraCobrancaSomenteTitulo = carteiraCobrancaSomenteTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_CLIENTES", foreignKey=@ForeignKey(name="FK_APUR_VAL_COOPERADOS_CLASSIF"))
    public ClassificacaoClientes getClassificacaoClientes() {
        return this.classificacaoClientes;
    }

    public void setClassificacaoClientes(ClassificacaoClientes classificacaoClientes) {
        this.classificacaoClientes = classificacaoClientes;
    }

    @Column(name="GERAR_TITULO_CREDOR")
    public Short getGerarTituloCredor() {
        return this.gerarTituloCredor;
    }

    public void setGerarTituloCredor(Short gerarTituloCredor) {
        this.gerarTituloCredor = gerarTituloCredor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_TIT_CREDOR")
    public Date getDataVencimentoTituloCredor() {
        return this.dataVencimentoTituloCredor;
    }

    public void setDataVencimentoTituloCredor(Date dataVencimentoTituloCredor) {
        this.dataVencimentoTituloCredor = dataVencimentoTituloCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_TIT_CREDOR", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_TIPO_DOC_CREDOR"))
    public TipoDoc getTipoDocTituloCredor() {
        return this.tipoDocTituloCredor;
    }

    public void setTipoDocTituloCredor(TipoDoc tipoDocTituloCredor) {
        this.tipoDocTituloCredor = tipoDocTituloCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAG_TIT_CREDOR", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_MEIO_PAG_CREDOR"))
    public MeioPagamento getMeioPagamentoTituloCredor() {
        return this.meioPagamentoTituloCredor;
    }

    public void setMeioPagamentoTituloCredor(MeioPagamento meioPagamentoTituloCredor) {
        this.meioPagamentoTituloCredor = meioPagamentoTituloCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CART_COBRANCA_TIT_CREDOR", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_CART_COB_CREDOR"))
    public CarteiraCobranca getCarteiraCobrancaTituloCredor() {
        return this.carteiraCobrancaTituloCredor;
    }

    public void setCarteiraCobrancaTituloCredor(CarteiraCobranca carteiraCobrancaTituloCredor) {
        this.carteiraCobrancaTituloCredor = carteiraCobrancaTituloCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GERENCIAL_TITULO", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_PL_GER_TIT_BOLET"))
    public PlanoContaGerencial getPlanoGerencialTitulo() {
        return this.planoGerencialTitulo;
    }

    public void setPlanoGerencialTitulo(PlanoContaGerencial planoGerencialTitulo) {
        this.planoGerencialTitulo = planoGerencialTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GERENCIAL_DEB_CONTA", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_PL_GER_DEB_CONTA"))
    public PlanoContaGerencial getPlanoGerencialDebitoConta() {
        return this.planoGerencialDebitoConta;
    }

    public void setPlanoGerencialDebitoConta(PlanoContaGerencial planoGerencialDebitoConta) {
        this.planoGerencialDebitoConta = planoGerencialDebitoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GERENCIAL_SOMENTE_TIT", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_PL_GER_SOM_TIT"))
    public PlanoContaGerencial getPlanoGerencialSomenteTitulo() {
        return this.planoGerencialSomenteTitulo;
    }

    public void setPlanoGerencialSomenteTitulo(PlanoContaGerencial planoGerencialSomenteTitulo) {
        this.planoGerencialSomenteTitulo = planoGerencialSomenteTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_GERENCIAL_TITULO_CRED", foreignKey=@ForeignKey(name="FK_AP_VAL_COOP_PL_GER_TIT_CRED"))
    public PlanoContaGerencial getPlanoGerencialTituloCredor() {
        return this.planoGerencialTituloCredor;
    }

    public void setPlanoGerencialTituloCredor(PlanoContaGerencial planoGerencialTituloCredor) {
        this.planoGerencialTituloCredor = planoGerencialTituloCredor;
    }

    @Column(name="NAO_APURAR_TIT_PERIODO_ANTERIOR")
    public Short getNaoApurarTitulosPeridoAnterior() {
        return this.naoApurarTitulosPeridoAnterior;
    }

    public void setNaoApurarTitulosPeridoAnterior(Short naoApurarTitulosPeridoAnterior) {
        this.naoApurarTitulosPeridoAnterior = naoApurarTitulosPeridoAnterior;
    }

    @Column(name="TIPO_CLIENTE")
    public Short getTipoCliente() {
        return this.tipoCliente;
    }

    public void setTipoCliente(Short tipoCliente) {
        this.tipoCliente = tipoCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_APUR_VAL_COOP_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @Column(name="DATA_BAIXA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataBaixa() {
        return this.dataBaixa;
    }

    public void setDataBaixa(Date dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_TIT_GERAR")
    public Date getDataEmissaoTitGerar() {
        return this.dataEmissaoTitGerar;
    }

    public void setDataEmissaoTitGerar(Date dataEmissaoTitGerar) {
        this.dataEmissaoTitGerar = dataEmissaoTitGerar;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_CONTABIL")
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }
}

