/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ARQUIVO_DIRF")
public class ArquivoDirf
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private EmpresaRh empresaRh;
    private Pessoa responsavelArquivo;
    private Short indicadorSocioOstensivo = 0;
    private Short indicadorPlanoSaude = 0;
    private Short indicadorDeclaracao = 0;
    private Date dataEvento;
    private Long anoBase = 0L;
    private Short tipoEscrituracao = 0;
    private String nrRecibo;
    private Short naturezaDeclarante = 0;
    private Pessoa responsavelEmpresa;
    private Double valorVincEmpregaticioSIM = 0.0;
    private Double valorVincEmpregaticioNAO = 0.0;
    private Short consolidarInformacoesMatrizFilial = 0;
    private Short tipoBeneficiario = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_ARQUIVO_DIRF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ARQUIVO_DIRF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA_RH", foreignKey=@ForeignKey(name="FK_ARQUIVO_DIRF_EMPRESA_RH"))
    public EmpresaRh getEmpresaRh() {
        return this.empresaRh;
    }

    public void setEmpresaRh(EmpresaRh empresaRh) {
        this.empresaRh = empresaRh;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESP_ARQUIVO", foreignKey=@ForeignKey(name="FK_ARQUIVO_DIRF_PESSOA_ARQUIVO"))
    public Pessoa getResponsavelArquivo() {
        return this.responsavelArquivo;
    }

    public void setResponsavelArquivo(Pessoa responsavelArquivo) {
        this.responsavelArquivo = responsavelArquivo;
    }

    @Column(name="IND_SOCIO_OSTENSIVO")
    public Short getIndicadorSocioOstensivo() {
        return this.indicadorSocioOstensivo;
    }

    public void setIndicadorSocioOstensivo(Short indicadorSocioOstensivo) {
        this.indicadorSocioOstensivo = indicadorSocioOstensivo;
    }

    @Column(name="IND_PLANO_SAUDE")
    public Short getIndicadorPlanoSaude() {
        return this.indicadorPlanoSaude;
    }

    public void setIndicadorPlanoSaude(Short indicadorPlanoSaude) {
        this.indicadorPlanoSaude = indicadorPlanoSaude;
    }

    @Column(name="IND_DECLARACAO_SIT_ESP")
    public Short getIndicadorDeclaracao() {
        return this.indicadorDeclaracao;
    }

    public void setIndicadorDeclaracao(Short indicadorDeclaracao) {
        this.indicadorDeclaracao = indicadorDeclaracao;
    }

    @Column(name="DATA_EVENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEvento() {
        return this.dataEvento;
    }

    public void setDataEvento(Date dataEvento) {
        this.dataEvento = dataEvento;
    }

    @Column(name="ANO_BASE")
    public Long getAnoBase() {
        return this.anoBase;
    }

    public void setAnoBase(Long anoBase) {
        this.anoBase = anoBase;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_ESCRITURACAO")
    public Short getTipoEscrituracao() {
        return this.tipoEscrituracao;
    }

    public void setTipoEscrituracao(Short tipoEscrituracao) {
        this.tipoEscrituracao = tipoEscrituracao;
    }

    @Column(name="NR_RECIBO_ANTERIOR", length=12)
    public String getNrRecibo() {
        return this.nrRecibo;
    }

    public void setNrRecibo(String nrRecibo) {
        this.nrRecibo = nrRecibo;
    }

    @Column(name="NATUREZA_DECLARANTE")
    public Short getNaturezaDeclarante() {
        return this.naturezaDeclarante;
    }

    public void setNaturezaDeclarante(Short naturezaDeclarante) {
        this.naturezaDeclarante = naturezaDeclarante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESP_EMPRESA", foreignKey=@ForeignKey(name="FK_ARQUIVO_DIRF_PESSOA_EMPRESA"))
    public Pessoa getResponsavelEmpresa() {
        return this.responsavelEmpresa;
    }

    public void setResponsavelEmpresa(Pessoa responsavelEmpresa) {
        this.responsavelEmpresa = responsavelEmpresa;
    }

    @Column(nullable=false, name="VR_VINC_EMPREGATICIO_SIM", precision=15, scale=2)
    public Double getValorVincEmpregaticioSIM() {
        return this.valorVincEmpregaticioSIM;
    }

    public void setValorVincEmpregaticioSIM(Double valorVincEmpregaticioSIM) {
        this.valorVincEmpregaticioSIM = valorVincEmpregaticioSIM;
    }

    @Column(nullable=false, name="VR_VINC_EMPREGATICIO_NAO", precision=15, scale=2)
    public Double getValorVincEmpregaticioNAO() {
        return this.valorVincEmpregaticioNAO;
    }

    public void setValorVincEmpregaticioNAO(Double valorVincEmpregaticioNAO) {
        this.valorVincEmpregaticioNAO = valorVincEmpregaticioNAO;
    }

    @Column(name="CONSOLIDAR_INFOR_MATRIZ_FILIAL")
    public Short getConsolidarInformacoesMatrizFilial() {
        return this.consolidarInformacoesMatrizFilial;
    }

    public void setConsolidarInformacoesMatrizFilial(Short consolidarInformacoesMatrizFilial) {
        this.consolidarInformacoesMatrizFilial = consolidarInformacoesMatrizFilial;
    }

    @Column(name="tipo_beneficiario")
    public Short getTipoBeneficiario() {
        return this.tipoBeneficiario;
    }

    public void setTipoBeneficiario(Short tipoBeneficiario) {
        this.tipoBeneficiario = tipoBeneficiario;
    }
}

