/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ARQUIVO_RAIS")
public class ArquivoRais
implements InterfaceVO {
    private Long identificador;
    private EmpresaRh empresaRH;
    private Short indicadorRetificacao = 0;
    private Date dataRetificacao;
    private Short tipoRais = 0;
    private Short indicadorEncerramentoAtividades = 0;
    private Date dataEncerramentoAtividades;
    private Short indicadorAtividadeAnoBase = 0;
    private Short indicadorContribuicaoSindical = 0;
    private Short empresaFiliadaSindicato = 0;
    private Long anoBase = 0L;
    private Pessoa responsavel;
    private String nrCreaRetificado;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short indicadorPAT = 0;
    private Double nrTrabalhadoresAbaixo5Sal = 0.0;
    private Double nrTrabalhadoresAcima5Sal = 0.0;
    private Double porcentagemServicoProprio = 0.0;
    private Double porcentagemAdminCozinhas = 0.0;
    private Double porcentagemRefeicaoConvenio = 0.0;
    private Double porcentagemRefeicaoTransp = 0.0;
    private Double porcentagemCestaAlimento = 0.0;
    private Double porcentagemAlimentacaoConvenio = 0.0;
    private Pessoa contribuicaoAssociativa;
    private Double valorContribuicaoAssociativa = 0.0;
    private Pessoa contribuicaoSindical;
    private Double valorContribuicaoSindical = 0.0;
    private Pessoa contribuicaoAssistencial;
    private Double valorContribuicaoAssistencial = 0.0;
    private Pessoa contribuicaoConfederativa;
    private Double valorContribuicaoConfederativa = 0.0;
    private Pessoa estabCentralizadorContribSindical;
    private Short tipoSistemaControlePonto = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_ARQUIVO_RAIS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ARQUIVO_RAIS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="INDICADOR_RETIFICACAO")
    public Short getIndicadorRetificacao() {
        return this.indicadorRetificacao;
    }

    public void setIndicadorRetificacao(Short indicadorRetificacao) {
        this.indicadorRetificacao = indicadorRetificacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_RETIFICACAO")
    public Date getDataRetificacao() {
        return this.dataRetificacao;
    }

    public void setDataRetificacao(Date dataRetificacao) {
        this.dataRetificacao = dataRetificacao;
    }

    @Column(name="TIPO_RAIS")
    public Short getTipoRais() {
        return this.tipoRais;
    }

    public void setTipoRais(Short tipoRais) {
        this.tipoRais = tipoRais;
    }

    @Column(name="INDICADOR_ENC_ATIVIDADE")
    public Short getIndicadorEncerramentoAtividades() {
        return this.indicadorEncerramentoAtividades;
    }

    public void setIndicadorEncerramentoAtividades(Short indicadorEncerramentoAtividades) {
        this.indicadorEncerramentoAtividades = indicadorEncerramentoAtividades;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENC_ATIVIDADE")
    public Date getDataEncerramentoAtividades() {
        return this.dataEncerramentoAtividades;
    }

    public void setDataEncerramentoAtividades(Date dataEncerramentoAtividades) {
        this.dataEncerramentoAtividades = dataEncerramentoAtividades;
    }

    @Column(name="INDICADOR_ATIVIDADE_ANO_BASE")
    public Short getIndicadorAtividadeAnoBase() {
        return this.indicadorAtividadeAnoBase;
    }

    public void setIndicadorAtividadeAnoBase(Short indicadorAtividadeAnoBase) {
        this.indicadorAtividadeAnoBase = indicadorAtividadeAnoBase;
    }

    @Column(name="INDICADOR_CONTRIB_SINDICAL")
    public Short getIndicadorContribuicaoSindical() {
        return this.indicadorContribuicaoSindical;
    }

    public void setIndicadorContribuicaoSindical(Short indicadorContribuicaoSindical) {
        this.indicadorContribuicaoSindical = indicadorContribuicaoSindical;
    }

    @Column(name="EMPRESA_FILIADA_SINDICATO")
    public Short getEmpresaFiliadaSindicato() {
        return this.empresaFiliadaSindicato;
    }

    public void setEmpresaFiliadaSindicato(Short empresaFiliadaSindicato) {
        this.empresaFiliadaSindicato = empresaFiliadaSindicato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA_RH", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_EMPRESA_RH"))
    public EmpresaRh getEmpresaRH() {
        return this.empresaRH;
    }

    public void setEmpresaRH(EmpresaRh empresaRH) {
        this.empresaRH = empresaRH;
    }

    @Column(name="ANO_BASE")
    public Long getAnoBase() {
        return this.anoBase;
    }

    public void setAnoBase(Long anoBase) {
        this.anoBase = anoBase;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_PESSOA_RESP"))
    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    @Column(name="NR_CREA_RETIFICACAO", length=25)
    public String getNrCreaRetificado() {
        return this.nrCreaRetificado;
    }

    public void setNrCreaRetificado(String nrCreaRetificado) {
        this.nrCreaRetificado = nrCreaRetificado;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INDICADOR_PAT")
    public Short getIndicadorPAT() {
        return this.indicadorPAT;
    }

    public void setIndicadorPAT(Short indicadorPAT) {
        this.indicadorPAT = indicadorPAT;
    }

    @Column(nullable=false, name="NR_TRAB_ABAIXO_5_SAL", precision=15, scale=2)
    public Double getNrTrabalhadoresAbaixo5Sal() {
        return this.nrTrabalhadoresAbaixo5Sal;
    }

    public void setNrTrabalhadoresAbaixo5Sal(Double nrTrabalhadoresAbaixo5Sal) {
        this.nrTrabalhadoresAbaixo5Sal = nrTrabalhadoresAbaixo5Sal;
    }

    @Column(nullable=false, name="NR_TRAB_ACIMA_5_SAL", precision=15, scale=2)
    public Double getNrTrabalhadoresAcima5Sal() {
        return this.nrTrabalhadoresAcima5Sal;
    }

    public void setNrTrabalhadoresAcima5Sal(Double nrTrabalhadoresAcima5Sal) {
        this.nrTrabalhadoresAcima5Sal = nrTrabalhadoresAcima5Sal;
    }

    @Column(nullable=false, name="PORC_SERVICO_PROPRIO", precision=15, scale=2)
    public Double getPorcentagemServicoProprio() {
        return this.porcentagemServicoProprio;
    }

    public void setPorcentagemServicoProprio(Double porcentagemServicoProprio) {
        this.porcentagemServicoProprio = porcentagemServicoProprio;
    }

    @Column(nullable=false, name="PORC_ADMIN_COZINHAS", precision=15, scale=2)
    public Double getPorcentagemAdminCozinhas() {
        return this.porcentagemAdminCozinhas;
    }

    public void setPorcentagemAdminCozinhas(Double porcentagemAdminCozinhas) {
        this.porcentagemAdminCozinhas = porcentagemAdminCozinhas;
    }

    @Column(nullable=false, name="PORC_REFEICAO_CONVENIO", precision=15, scale=2)
    public Double getPorcentagemRefeicaoConvenio() {
        return this.porcentagemRefeicaoConvenio;
    }

    public void setPorcentagemRefeicaoConvenio(Double porcentagemRefeicaoConvenio) {
        this.porcentagemRefeicaoConvenio = porcentagemRefeicaoConvenio;
    }

    @Column(nullable=false, name="PORC_REFEICAO_TRANSP", precision=15, scale=2)
    public Double getPorcentagemRefeicaoTransp() {
        return this.porcentagemRefeicaoTransp;
    }

    public void setPorcentagemRefeicaoTransp(Double porcentagemRefeicaoTransp) {
        this.porcentagemRefeicaoTransp = porcentagemRefeicaoTransp;
    }

    @Column(nullable=false, name="PORC_CESTA_ALIMENTO", precision=15, scale=2)
    public Double getPorcentagemCestaAlimento() {
        return this.porcentagemCestaAlimento;
    }

    public void setPorcentagemCestaAlimento(Double porcentagemCestaAlimento) {
        this.porcentagemCestaAlimento = porcentagemCestaAlimento;
    }

    @Column(nullable=false, name="PORC_ALIM_CONVENIO", precision=15, scale=2)
    public Double getPorcentagemAlimentacaoConvenio() {
        return this.porcentagemAlimentacaoConvenio;
    }

    public void setPorcentagemAlimentacaoConvenio(Double porcentagemAlimentacaoConvenio) {
        this.porcentagemAlimentacaoConvenio = porcentagemAlimentacaoConvenio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CONTRIB_ASSOCIATIVA", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_CONT_ASSOC"))
    public Pessoa getContribuicaoAssociativa() {
        return this.contribuicaoAssociativa;
    }

    public void setContribuicaoAssociativa(Pessoa contribuicaoAssociativa) {
        this.contribuicaoAssociativa = contribuicaoAssociativa;
    }

    @Column(nullable=false, name="VALOR_CONTRIB_ASSOCIATIVA", precision=15, scale=2)
    public Double getValorContribuicaoAssociativa() {
        return this.valorContribuicaoAssociativa;
    }

    public void setValorContribuicaoAssociativa(Double valorContribuicaoAssociativa) {
        this.valorContribuicaoAssociativa = valorContribuicaoAssociativa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CONTRIB_SINDICAL", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_CONTR_SIND"))
    public Pessoa getContribuicaoSindical() {
        return this.contribuicaoSindical;
    }

    public void setContribuicaoSindical(Pessoa contribuicaoSindical) {
        this.contribuicaoSindical = contribuicaoSindical;
    }

    @Column(nullable=false, name="VALOR_CONTRIB_SINDICAL", precision=15, scale=2)
    public Double getValorContribuicaoSindical() {
        return this.valorContribuicaoSindical;
    }

    public void setValorContribuicaoSindical(Double valorContribuicaoSindical) {
        this.valorContribuicaoSindical = valorContribuicaoSindical;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CONTRIB_ASSISTENCIAL", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_CONT_ASSIST"))
    public Pessoa getContribuicaoAssistencial() {
        return this.contribuicaoAssistencial;
    }

    public void setContribuicaoAssistencial(Pessoa contribuicaoAssistencial) {
        this.contribuicaoAssistencial = contribuicaoAssistencial;
    }

    @Column(nullable=false, name="VALOR_CONTRIB_ASSISTENCIAL", precision=15, scale=2)
    public Double getValorContribuicaoAssistencial() {
        return this.valorContribuicaoAssistencial;
    }

    public void setValorContribuicaoAssistencial(Double valorContribuicaoAssistencial) {
        this.valorContribuicaoAssistencial = valorContribuicaoAssistencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CONTRIB_CONFEDERATIVA", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_CONT_CONF"))
    public Pessoa getContribuicaoConfederativa() {
        return this.contribuicaoConfederativa;
    }

    public void setContribuicaoConfederativa(Pessoa contribuicaoConfederativa) {
        this.contribuicaoConfederativa = contribuicaoConfederativa;
    }

    @Column(nullable=false, name="VALOR_CONTRIB_CONFEDERATIVA", precision=15, scale=2)
    public Double getValorContribuicaoConfederativa() {
        return this.valorContribuicaoConfederativa;
    }

    public void setValorContribuicaoConfederativa(Double valorContribuicaoConfederativa) {
        this.valorContribuicaoConfederativa = valorContribuicaoConfederativa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_ESTAB_CENTR_CONTR_SIN", foreignKey=@ForeignKey(name="FK_ARQUIVO_RAIS_EST_CENTR"))
    public Pessoa getEstabCentralizadorContribSindical() {
        return this.estabCentralizadorContribSindical;
    }

    public void setEstabCentralizadorContribSindical(Pessoa estabCentralizadorContribSindical) {
        this.estabCentralizadorContribSindical = estabCentralizadorContribSindical;
    }

    @Column(name="TIPO_SISTEMA_CONTROLE_PONTO")
    public Short getTipoSistemaControlePonto() {
        return this.tipoSistemaControlePonto;
    }

    public void setTipoSistemaControlePonto(Short tipoSistemaControlePonto) {
        this.tipoSistemaControlePonto = tipoSistemaControlePonto;
    }
}

