/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BitsDados;
import com.touchcomp.basementor.model.vo.BitsParada;
import com.touchcomp.basementor.model.vo.BitsSegundo;
import com.touchcomp.basementor.model.vo.ControleFluxo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Paridade;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="BALANCA_RODOVIARIO")
public class BalancaRodoviario
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private String descricao;
    private BitsSegundo bitsSegundo;
    private BitsDados bitsDados;
    private BitsParada bitsParada;
    private Paridade paridade;
    private ControleFluxo controleFluxo;
    private String porta;
    private Integer posicaoPesoInicial = 0;
    private Integer posicaoPesoFinal = 0;
    private Double fatorConversao = 1.0;
    private String loginGridnet;
    private String senhaGridNet;
    private Short liberarInfPesoManual = EnumConstantsMentorSimNao.NAO.getValue();

    @Id
    @Column(nullable=false, name="ID_BALANCA_RODOVIARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BALANCA_RODOVIARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_BITS_SEGUNDO", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_BITS_SEGU"))
    public BitsSegundo getBitsSegundo() {
        return this.bitsSegundo;
    }

    public void setBitsSegundo(BitsSegundo bitsSegundo) {
        this.bitsSegundo = bitsSegundo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_BITS_DADOS", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_BITS_DADO"))
    public BitsDados getBitsDados() {
        return this.bitsDados;
    }

    public void setBitsDados(BitsDados bitsDados) {
        this.bitsDados = bitsDados;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_BITS_PARADA", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_BITS_PARA"))
    public BitsParada getBitsParada() {
        return this.bitsParada;
    }

    public void setBitsParada(BitsParada bitsParada) {
        this.bitsParada = bitsParada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PARIDADE", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_PARIDADE"))
    public Paridade getParidade() {
        return this.paridade;
    }

    public void setParidade(Paridade paridade) {
        this.paridade = paridade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTROLE_FLUXO", foreignKey=@ForeignKey(name="FK_BALANCA_RODOVIARIO_CON_FLUXO"))
    public ControleFluxo getControleFluxo() {
        return this.controleFluxo;
    }

    public void setControleFluxo(ControleFluxo controleFluxo) {
        this.controleFluxo = controleFluxo;
    }

    @Column(nullable=false, name="PORTA", length=10)
    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    @Column(nullable=false, name="POSICAO_PESO_INICIAL")
    public Integer getPosicaoPesoInicial() {
        return this.posicaoPesoInicial;
    }

    public void setPosicaoPesoInicial(Integer posicaoPesoInicial) {
        this.posicaoPesoInicial = posicaoPesoInicial;
    }

    @Column(nullable=false, name="POSICAO_PESO_FINAL")
    public Integer getPosicaoPesoFinal() {
        return this.posicaoPesoFinal;
    }

    public void setPosicaoPesoFinal(Integer posicaoPesoFinal) {
        this.posicaoPesoFinal = posicaoPesoFinal;
    }

    @Column(nullable=false, name="FATOR_CONVERSAO", precision=15, scale=2)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Column(name="LOGIN_GRID_NET", length=100)
    public String getLoginGridnet() {
        return this.loginGridnet;
    }

    public void setLoginGridnet(String loginGridnet) {
        this.loginGridnet = loginGridnet;
    }

    @Column(name="SENHA_GRID_NET", length=100)
    public String getSenhaGridNet() {
        return this.senhaGridNet;
    }

    public void setSenhaGridNet(String senhaGridNet) {
        this.senhaGridNet = senhaGridNet;
    }

    @Column(name="LIBERAR_INF_PESO_MANUAL")
    public Short getLiberarInfPesoManual() {
        return this.liberarInfPesoManual;
    }

    public void setLiberarInfPesoManual(Short liberarInfPesoManual) {
        this.liberarInfPesoManual = liberarInfPesoManual;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

