/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.BemComponenteCompra;
import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.BemTipoDepreciacao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.DocFiscalBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="BEM", uniqueConstraints={@UniqueConstraint(name="UNQ1_BEM", columnNames={"CODIGO"}), @UniqueConstraint(name="UNQ2_BEM", columnNames={"ID_ITEM_NOTA_TERCEIROS"})})
public class Bem
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String descricao;
    private String descricaoFuncional;
    private Short nrParcelasIcms = 0;
    private Short nrParcelaIcmsInicial = 0;
    private TipoBem tipoBem;
    private Short nrMesesVidaUtil = 0;
    private CentroCusto centroCusto;
    private Date dataCompra;
    private Double valorIcms = 0.0;
    private Double valorIcmsSt = 0.0;
    private Double valorIcmsFrete = 0.0;
    private Double valorIcmsDifAliquota = 0.0;
    private Double valorCompra = 0.0;
    private Double valorOutrasDepreciacoes = 0.0;
    private Double valorNaoDepreciavel = 0.0;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Bem bemPrincipal;
    private List<Bem> componentes = new ArrayList<Bem>();
    private List<BemTipoDepreciacao> bensTipoDepreciacao = new ArrayList<BemTipoDepreciacao>();
    private List<DocFiscalBem> docFiscaisBem = new ArrayList<DocFiscalBem>();
    private BemSpedPisCofins bemSpedPisCofins;
    private Short bemUsadoPisCofins = 0;
    private ItemNotaTerceiros itemNotaTerceiros;
    private List<BaixaBem> baixasBem = new ArrayList<BaixaBem>();
    private Equipamento equipamento;
    private List<BemComponenteCompra> componentesProduto = new ArrayList<BemComponenteCompra>();

    @Id
    @Column(nullable=false, name="ID_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="CODIGO", length=60)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Column(name="DESCRICAO", length=255)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DESCRICAO_FUNCIONAL", length=255)
    public String getDescricaoFuncional() {
        return this.descricaoFuncional;
    }

    public void setDescricaoFuncional(String descricaoFuncional) {
        this.descricaoFuncional = descricaoFuncional;
    }

    @Column(name="NR_PARCELAS_ICMS")
    public Short getNrParcelasIcms() {
        return this.nrParcelasIcms;
    }

    public void setNrParcelasIcms(Short nrParcelasIcms) {
        this.nrParcelasIcms = nrParcelasIcms;
    }

    @Column(name="NR_MESES_VIDA_UTIL")
    public Short getNrMesesVidaUtil() {
        return this.nrMesesVidaUtil;
    }

    public void setNrMesesVidaUtil(Short nrMesesVidaUtil) {
        this.nrMesesVidaUtil = nrMesesVidaUtil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_BEM_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPRA")
    public Date getDataCompra() {
        return this.dataCompra;
    }

    public void setDataCompra(Date dataCompra) {
        this.dataCompra = dataCompra;
    }

    @Column(name="VALOR_ICMS", precision=15, scale=2)
    public Double getValorIcms() {
        return this.valorIcms;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_BEM_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BEM_PRINCIPAL", foreignKey=@ForeignKey(name="FK_BEM_BEM_PRINCIPAL"))
    public Bem getBemPrincipal() {
        return this.bemPrincipal;
    }

    public void setBemPrincipal(Bem bemPrincipal) {
        this.bemPrincipal = bemPrincipal;
    }

    @OneToMany(mappedBy="bemPrincipal", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE})
    public List<Bem> getComponentes() {
        return this.componentes;
    }

    public void setComponentes(List<Bem> componentes) {
        this.componentes = componentes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_BEM", foreignKey=@ForeignKey(name="FK_BEM_TIPO_BEM"))
    public TipoBem getTipoBem() {
        return this.tipoBem;
    }

    public void setTipoBem(TipoBem tipoBem) {
        this.tipoBem = tipoBem;
    }

    @Column(name="VALOR_COMPRA", precision=15, scale=2)
    public Double getValorCompra() {
        return this.valorCompra;
    }

    public void setValorCompra(Double valorCompra) {
        this.valorCompra = valorCompra;
    }

    @Column(name="VALOR_OUTRAS_DEPR", precision=15, scale=4)
    public Double getValorOutrasDepreciacoes() {
        return this.valorOutrasDepreciacoes;
    }

    public void setValorOutrasDepreciacoes(Double valorOutrasDepreciacoes) {
        this.valorOutrasDepreciacoes = valorOutrasDepreciacoes;
    }

    @OneToMany(mappedBy="bem", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<BemTipoDepreciacao> getBensTipoDepreciacao() {
        return this.bensTipoDepreciacao;
    }

    public void setBensTipoDepreciacao(List<BemTipoDepreciacao> bensTipoDepreciacao) {
        this.bensTipoDepreciacao = bensTipoDepreciacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_ICMS_ST", precision=15, scale=2)
    public Double getValorIcmsSt() {
        return this.valorIcmsSt;
    }

    public void setValorIcmsSt(Double valorIcmsSt) {
        this.valorIcmsSt = valorIcmsSt;
    }

    @Column(name="VALOR_ICMS_FRETE", precision=15, scale=2)
    public Double getValorIcmsFrete() {
        return this.valorIcmsFrete;
    }

    public void setValorIcmsFrete(Double valorIcmsFrete) {
        this.valorIcmsFrete = valorIcmsFrete;
    }

    @Column(name="VALOR_ICMS_DIF_ALIQUOTA", precision=15, scale=2)
    public Double getValorIcmsDifAliquota() {
        return this.valorIcmsDifAliquota;
    }

    public void setValorIcmsDifAliquota(Double valorIcmsDifAliquota) {
        this.valorIcmsDifAliquota = valorIcmsDifAliquota;
    }

    @Column(name="NR_PARCELA_ICMS_INI")
    public Short getNrParcelaIcmsInicial() {
        return this.nrParcelaIcmsInicial;
    }

    public void setNrParcelaIcmsInicial(Short nrParcelaIcmsInicial) {
        this.nrParcelaIcmsInicial = nrParcelaIcmsInicial;
    }

    @OneToMany(targetEntity=DocFiscalBem.class, mappedBy="bem", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DocFiscalBem> getDocFiscaisBem() {
        return this.docFiscaisBem;
    }

    public void setDocFiscaisBem(List<DocFiscalBem> docFiscaisBem) {
        this.docFiscaisBem = docFiscaisBem;
    }

    @OneToOne(mappedBy="bem", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public BemSpedPisCofins getBemSpedPisCofins() {
        return this.bemSpedPisCofins;
    }

    public void setBemSpedPisCofins(BemSpedPisCofins bemSpedPisCofins) {
        this.bemSpedPisCofins = bemSpedPisCofins;
    }

    @Column(name="BEM_USADO_PIS_COFINS")
    public Short getBemUsadoPisCofins() {
        return this.bemUsadoPisCofins;
    }

    public void setBemUsadoPisCofins(Short bemUsadoPisCofins) {
        this.bemUsadoPisCofins = bemUsadoPisCofins;
    }

    @JoinColumn(name="ID_ITEM_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_BEM_ITEM_NOTA_TERCEIROS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemNotaTerceiros getItemNotaTerceiros() {
        return this.itemNotaTerceiros;
    }

    public void setItemNotaTerceiros(ItemNotaTerceiros itemNotaTerceiros) {
        this.itemNotaTerceiros = itemNotaTerceiros;
    }

    @OneToMany(mappedBy="bem", fetch=FetchType.LAZY)
    public List<BaixaBem> getBaixasBem() {
        return this.baixasBem;
    }

    public void setBaixasBem(List<BaixaBem> baixasBem) {
        this.baixasBem = baixasBem;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_BEM_EQUIPAMENTO"))
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @Column(name="VALOR_NAO_DEPRECIAVEL", precision=15, scale=2)
    public Double getValorNaoDepreciavel() {
        return this.valorNaoDepreciavel;
    }

    public void setValorNaoDepreciavel(Double valorNaoDepreciavel) {
        this.valorNaoDepreciavel = valorNaoDepreciavel;
    }

    @OneToMany(mappedBy="bem", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<BemComponenteCompra> getComponentesProduto() {
        return this.componentesProduto;
    }

    public void setComponentesProduto(List<BemComponenteCompra> componentesProduto) {
        this.componentesProduto = componentesProduto;
    }
}

