/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.ItemProdNFCTeInf;
import com.touchcomp.basementor.model.vo.TipoDocOriginarioCTe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CTE_OUTROS")
public class CTeOutros
implements InterfaceVO {
    private Long identificador;
    private TipoDocOriginarioCTe tipoDoc;
    private String descricaoOutros;
    private String numeroDocumento;
    private Date dataEmissao;
    private Double valorDocumento = 0.0;
    private Cte cte;
    private Double qtdTotalNF = 0.0;
    private Double qtdTotalVolumesNf = 0.0;
    private Double pesoTotalNf = 0.0;
    private List<ItemProdNFCTeInf> itemProdNFCteInf = new ArrayList<ItemProdNFCTeInf>();

    @Id
    @Column(name="ID_CTE_OUTROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CTE_OUTROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO_OUTROS", length=100)
    public String getDescricaoOutros() {
        return this.descricaoOutros;
    }

    public void setDescricaoOutros(String descricaoOutros) {
        this.descricaoOutros = descricaoOutros;
    }

    @Column(name="NUMERO_DOCUMENTO", length=20)
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="VALOR_DOCUMENTO", precision=15, scale=2)
    public Double getValorDocumento() {
        return this.valorDocumento;
    }

    public void setValorDocumento(Double valorDocumento) {
        this.valorDocumento = valorDocumento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_ORIN_CTE", foreignKey=@ForeignKey(name="FK_CTE_OUTROS_TP_DOC_ORIG_CTE"))
    public TipoDocOriginarioCTe getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDocOriginarioCTe tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_CTE_OUTROS_CTE"))
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumeroDocumento()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="QTD_TOTAL_NF", precision=15, scale=6)
    public Double getQtdTotalNF() {
        return this.qtdTotalNF;
    }

    public void setQtdTotalNF(Double qtdTotalNF) {
        this.qtdTotalNF = qtdTotalNF;
    }

    @OneToMany(targetEntity=ItemProdNFCTeInf.class, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinTable(name="cte_out_doc_item_pr_inf", joinColumns={@JoinColumn(name="id_cte_outros")}, inverseJoinColumns={@JoinColumn(name="id_item_prod_nf_cte_inf")})
    public List<ItemProdNFCTeInf> getItemProdNFCteInf() {
        return this.itemProdNFCteInf;
    }

    public void setItemProdNFCteInf(List<ItemProdNFCTeInf> itemProdNFCteInf) {
        this.itemProdNFCteInf = itemProdNFCteInf;
    }

    @Column(name="QTD_TOTAL_VOLUMES_NF", precision=15, scale=6)
    public Double getQtdTotalVolumesNf() {
        return this.qtdTotalVolumesNf;
    }

    public void setQtdTotalVolumesNf(Double qtdTotalVolumesNf) {
        this.qtdTotalVolumesNf = qtdTotalVolumesNf;
    }

    @Column(nullable=false, name="PESO_TOTAL_NF", precision=15, scale=6)
    public Double getPesoTotalNf() {
        return this.pesoTotalNf;
    }

    public void setPesoTotalNf(Double pesoTotalNf) {
        this.pesoTotalNf = pesoTotalNf;
    }
}

