/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoConvencaoColetiva;
import com.touchcomp.basementor.model.vo.FornecedoraTicketAlimentacao;
import com.touchcomp.basementor.model.vo.FuncaoConvColetiva;
import com.touchcomp.basementor.model.vo.ItemConvColetivaAtSalarial;
import com.touchcomp.basementor.model.vo.SindicatoConvecaoColetiva;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CADASTRO_CONVECAO_COLETIVA")
public class CadastroConvencaoColetiva
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private Date dataLiberacao;
    private Integer ano;
    private Double valorValeAlimentacao = 0.0;
    private Double percDescontoVA = 0.0;
    private Double minimoHorasVA = 0.0;
    private Double valorCestaBasica = 0.0;
    private Double percDescontoCesta = 0.0;
    private Integer minimoDiasCesta = 0;
    private TipoCalculoEvento tpValeAlimentacao;
    private TipoCalculoEvento tpCestaBasica;
    private String clausulaCestaBasica;
    private String clausulaAcordoCompHoras;
    private Short computarJornadaReduzidaNoturna = 0;
    private List<SindicatoConvecaoColetiva> sindicatoConvencao = new ArrayList<SindicatoConvecaoColetiva>();
    private FornecedoraTicketAlimentacao fornecedorTicket;
    private Short tipoAtualizacaoSalarial = 0;
    private Short percValorAtualizacao = 0;
    private List<ItemConvColetivaAtSalarial> itensAtualizacao = new ArrayList<ItemConvColetivaAtSalarial>();
    private Short efetuarPagamentoCestaFerias = 0;
    private Short naoPagarCestaComFalta = 0;
    private Short tipoDescontoValor = 0;
    private Double valorDescontoVale = 0.0;
    private Double diasApuracaoVale = 0.0;
    private List<ColaboradorSalario> salarios = new ArrayList<ColaboradorSalario>();
    private List<FuncaoConvColetiva> funcoesConvencao;
    private TipoCalculoEvento tpIndenizacaoAviso;
    private Short indenizarAvisoTrabalhado = 0;
    private Date dataPagamento;
    private Date periodoInicial;
    private Date periodoFinal;
    private TipoCalculo tipoCalculo;
    private List<EventoConvencaoColetiva> eventosConvencao = new ArrayList<EventoConvencaoColetiva>();
    private Short gerarComplementoSalarial = 0;
    private CalculoComplementoSalario complementoSalario;
    private TipoCalculoEvento tpEvento;
    private Double limiteMinimo = 0.0;
    private Double limiteMaximo = 0.0;
    private Short comporFolhaDec = 0;
    private Short calcularProporcionalidadeAdmissao = 0;
    private Short respeitarLimiteFuncao = 0;

    public CadastroConvencaoColetiva() {
        this.funcoesConvencao = new ArrayList<FuncaoConvColetiva>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_CONVENCAO_COLETIVA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_CONVENCAO_COLETIVA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_LIBERACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiberacao() {
        return this.dataLiberacao;
    }

    public void setDataLiberacao(Date dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    @Ignore
    @Column(name="ANO")
    public Integer getAno() {
        return this.ano;
    }

    public void setAno(Integer ano) {
        this.ano = ano;
    }

    @Column(name="VALOR_VALE_ALIMENTACAO", precision=15, scale=2)
    public Double getValorValeAlimentacao() {
        return this.valorValeAlimentacao;
    }

    public void setValorValeAlimentacao(Double valorValeAlimentacao) {
        this.valorValeAlimentacao = valorValeAlimentacao;
    }

    @Column(name="PERC_DESCONTO_VA", precision=15, scale=2)
    public Double getPercDescontoVA() {
        return this.percDescontoVA;
    }

    public void setPercDescontoVA(Double percDescontoVA) {
        this.percDescontoVA = percDescontoVA;
    }

    @Column(name="MINIMO_HORAS_VA", precision=15, scale=2)
    public Double getMinimoHorasVA() {
        return this.minimoHorasVA;
    }

    public void setMinimoHorasVA(Double minimoHorasVA) {
        this.minimoHorasVA = minimoHorasVA;
    }

    @Column(name="VALOR_CESTA_BASICA", precision=15, scale=2)
    public Double getValorCestaBasica() {
        return this.valorCestaBasica;
    }

    public void setValorCestaBasica(Double valorCestaBasica) {
        this.valorCestaBasica = valorCestaBasica;
    }

    @Column(name="PERC_DESCONTO_CESTA", precision=15, scale=2)
    public Double getPercDescontoCesta() {
        return this.percDescontoCesta;
    }

    public void setPercDescontoCesta(Double percDescontoCesta) {
        this.percDescontoCesta = percDescontoCesta;
    }

    @Column(name="MINIMO_DIAS_CESTA")
    public Integer getMinimoDiasCesta() {
        return this.minimoDiasCesta;
    }

    public void setMinimoDiasCesta(Integer minimoDiasCesta) {
        this.minimoDiasCesta = minimoDiasCesta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_VALE_ALIMENTACAO", foreignKey=@ForeignKey(name="FK_EVENTO_VALE_ALIMENT"))
    public TipoCalculoEvento getTpValeAlimentacao() {
        return this.tpValeAlimentacao;
    }

    public void setTpValeAlimentacao(TipoCalculoEvento tpValeAlimentacao) {
        this.tpValeAlimentacao = tpValeAlimentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_CESTA_BASICA", foreignKey=@ForeignKey(name="FK_TP_EVENTO_CESTA_BASICA"))
    public TipoCalculoEvento getTpCestaBasica() {
        return this.tpCestaBasica;
    }

    public void setTpCestaBasica(TipoCalculoEvento tpCestaBasica) {
        this.tpCestaBasica = tpCestaBasica;
    }

    @Column(name="CLAUSULA_CESTA_BASICA", length=100)
    public String getClausulaCestaBasica() {
        return this.clausulaCestaBasica;
    }

    public void setClausulaCestaBasica(String clausulaCestaBasica) {
        this.clausulaCestaBasica = clausulaCestaBasica;
    }

    @Column(name="CLAUSULA_ACORDO_COMP_HORAS", length=100)
    public String getClausulaAcordoCompHoras() {
        return this.clausulaAcordoCompHoras;
    }

    public void setClausulaAcordoCompHoras(String clausulaAcordoCompHoras) {
        this.clausulaAcordoCompHoras = clausulaAcordoCompHoras;
    }

    @Column(name="COMPUTAR_JORNADA_RED_NOTURNA")
    public Short getComputarJornadaReduzidaNoturna() {
        return this.computarJornadaReduzidaNoturna;
    }

    public void setComputarJornadaReduzidaNoturna(Short computarJornadaReduzidaNoturna) {
        this.computarJornadaReduzidaNoturna = computarJornadaReduzidaNoturna;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONVENCAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="convencao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<SindicatoConvecaoColetiva> getSindicatoConvencao() {
        return this.sindicatoConvencao;
    }

    public void setSindicatoConvencao(List<SindicatoConvecaoColetiva> sindicatoConvencao) {
        this.sindicatoConvencao = sindicatoConvencao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORNECEDOR_TICKET", foreignKey=@ForeignKey(name="FK_CADASTRO_CONV_FORNEC_TICKET"))
    public FornecedoraTicketAlimentacao getFornecedorTicket() {
        return this.fornecedorTicket;
    }

    public void setFornecedorTicket(FornecedoraTicketAlimentacao fornecedorTicket) {
        this.fornecedorTicket = fornecedorTicket;
    }

    @Column(name="TIPO_AT_SALARIAL")
    public Short getTipoAtualizacaoSalarial() {
        return this.tipoAtualizacaoSalarial;
    }

    public void setTipoAtualizacaoSalarial(Short tipoAtualizacaoSalarial) {
        this.tipoAtualizacaoSalarial = tipoAtualizacaoSalarial;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="convencaoColetiva", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemConvColetivaAtSalarial> getItensAtualizacao() {
        return this.itensAtualizacao;
    }

    public void setItensAtualizacao(List<ItemConvColetivaAtSalarial> itensAtualizacao) {
        this.itensAtualizacao = itensAtualizacao;
    }

    @Column(name="PERC_VALOR_ATUALIZACAO")
    public Short getPercValorAtualizacao() {
        return this.percValorAtualizacao;
    }

    public void setPercValorAtualizacao(Short percValorAtualizacao) {
        this.percValorAtualizacao = percValorAtualizacao;
    }

    @Column(name="EFETUAR_PAG_CESTA_FERIAS")
    public Short getEfetuarPagamentoCestaFerias() {
        return this.efetuarPagamentoCestaFerias;
    }

    public void setEfetuarPagamentoCestaFerias(Short efetuarPagamentoCestaFerias) {
        this.efetuarPagamentoCestaFerias = efetuarPagamentoCestaFerias;
    }

    @Column(name="NAO_PAGAR_CESTA_COM_FALTA")
    public Short getNaoPagarCestaComFalta() {
        return this.naoPagarCestaComFalta;
    }

    public void setNaoPagarCestaComFalta(Short naoPagarCestaComFalta) {
        this.naoPagarCestaComFalta = naoPagarCestaComFalta;
    }

    @Column(name="TIPO_DESCONTO_VALOR")
    public Short getTipoDescontoValor() {
        return this.tipoDescontoValor;
    }

    public void setTipoDescontoValor(Short tipoDescontoValor) {
        this.tipoDescontoValor = tipoDescontoValor;
    }

    @Column(name="VALOR_DESCONTO_VALE", precision=15, scale=4)
    public Double getValorDescontoVale() {
        return this.valorDescontoVale;
    }

    public void setValorDescontoVale(Double valorDescontoVale) {
        this.valorDescontoVale = valorDescontoVale;
    }

    @Column(name="DIAS_APURACAO_VALE", precision=15, scale=4)
    public Double getDiasApuracaoVale() {
        return this.diasApuracaoVale;
    }

    public void setDiasApuracaoVale(Double diasApuracaoVale) {
        this.diasApuracaoVale = diasApuracaoVale;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroConvencao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FuncaoConvColetiva> getFuncoesConvencao() {
        return this.funcoesConvencao;
    }

    public void setFuncoesConvencao(List<FuncaoConvColetiva> funcoesConvencao) {
        this.funcoesConvencao = funcoesConvencao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="convencao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ColaboradorSalario> getSalarios() {
        return this.salarios;
    }

    public void setSalarios(List<ColaboradorSalario> salarios) {
        this.salarios = salarios;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_INDENIZAR_AVISO_TRAB", foreignKey=@ForeignKey(name="FK_CADAS_CONV_TP_IND_AVISO_TRAB"))
    public TipoCalculoEvento getTpIndenizacaoAviso() {
        return this.tpIndenizacaoAviso;
    }

    public void setTpIndenizacaoAviso(TipoCalculoEvento tpIndenizacaoAviso) {
        this.tpIndenizacaoAviso = tpIndenizacaoAviso;
    }

    @Column(name="INDENIZAR_AVISO_TRABALHADO")
    public Short getIndenizarAvisoTrabalhado() {
        return this.indenizarAvisoTrabalhado;
    }

    public void setIndenizarAvisoTrabalhado(Short indenizarAvisoTrabalhado) {
        this.indenizarAvisoTrabalhado = indenizarAvisoTrabalhado;
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="PERIODO_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Column(name="PERIODO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO", foreignKey=@ForeignKey(name="FK_TP_CALCULO_CONVENCAO"))
    public TipoCalculo getTipoCalculo() {
        return this.tipoCalculo;
    }

    public void setTipoCalculo(TipoCalculo tipoCalculo) {
        this.tipoCalculo = tipoCalculo;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="convencaoColetiva", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EventoConvencaoColetiva> getEventosConvencao() {
        return this.eventosConvencao;
    }

    public void setEventosConvencao(List<EventoConvencaoColetiva> eventosConvencao) {
        this.eventosConvencao = eventosConvencao;
    }

    @Column(name="GERAR_COMPLEMENTO_SALARIAL")
    public Short getGerarComplementoSalarial() {
        return this.gerarComplementoSalarial;
    }

    public void setGerarComplementoSalarial(Short gerarComplementoSalarial) {
        this.gerarComplementoSalarial = gerarComplementoSalarial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CALCULO_COMPLEMENTO_SALARIO", foreignKey=@ForeignKey(name="FK_CALCULO_COMP_CONVENCAO"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public CalculoComplementoSalario getComplementoSalario() {
        return this.complementoSalario;
    }

    public void setComplementoSalario(CalculoComplementoSalario complementoSalario) {
        this.complementoSalario = complementoSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_EVENTO", foreignKey=@ForeignKey(name="FK_TP_EVT_CONV_COLETIVA_FOLHA"))
    public TipoCalculoEvento getTpEvento() {
        return this.tpEvento;
    }

    public void setTpEvento(TipoCalculoEvento tpEvento) {
        this.tpEvento = tpEvento;
    }

    @Column(name="LIMITE_MINIMO", precision=15, scale=2)
    public Double getLimiteMinimo() {
        return this.limiteMinimo;
    }

    public void setLimiteMinimo(Double limiteMinimo) {
        this.limiteMinimo = limiteMinimo;
    }

    @Column(name="LIMITE_MAXIMO", precision=15, scale=2)
    public Double getLimiteMaximo() {
        return this.limiteMaximo;
    }

    public void setLimiteMaximo(Double limiteMaximo) {
        this.limiteMaximo = limiteMaximo;
    }

    @Column(name="COMPOR_FOLHA_DEC")
    public Short getComporFolhaDec() {
        return this.comporFolhaDec;
    }

    public void setComporFolhaDec(Short comporFolhaDec) {
        this.comporFolhaDec = comporFolhaDec;
    }

    @Column(name="CALCULAR_PROPORC_ADMISSAO")
    public Short getCalcularProporcionalidadeAdmissao() {
        return this.calcularProporcionalidadeAdmissao;
    }

    public void setCalcularProporcionalidadeAdmissao(Short calcularProporcionalidadeAdmissao) {
        this.calcularProporcionalidadeAdmissao = calcularProporcionalidadeAdmissao;
    }

    @Column(name="RESPEITAR_LIMITE_FUNCAO")
    public Short getRespeitarLimiteFuncao() {
        return this.respeitarLimiteFuncao;
    }

    public void setRespeitarLimiteFuncao(Short respeitarLimiteFuncao) {
        this.respeitarLimiteFuncao = respeitarLimiteFuncao;
    }
}

