/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoRotinaPeriodica;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.StatusExameColaborador;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="CADASTRO_EXAME_COLABORADOR")
public class CadastroExameColaborador
implements InterfaceVO {
    private Long identificador;
    private ClassificacaoRotinaPeriodica classificacaoRotina;
    private Colaborador colaborador;
    private Short exameDemissional = 0;
    private String codigoExame;
    private Date dataExame;
    private String cnpjLaboratorio;
    private String nomeLaboratorio;
    private String nomeMedico;
    private String crm;
    private UnidadeFederativa ufCrm;
    private StatusExameColaborador statusExame;

    @Id
    @Column(nullable=false, unique=true, name="ID_CADASTRO_EXAME")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CADASTRO_EXAME")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_ROTINA", foreignKey=@ForeignKey(name="FK_CADASTRO_EXAME_ROTINA_PERIOD"))
    public ClassificacaoRotinaPeriodica getClassificacaoRotina() {
        return this.classificacaoRotina;
    }

    public void setClassificacaoRotina(ClassificacaoRotinaPeriodica classificacaoRotina) {
        this.classificacaoRotina = classificacaoRotina;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_CADASTRO_EXAME_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="EXAME_DEMISSIONAL")
    public Short getExameDemissional() {
        return this.exameDemissional;
    }

    public void setExameDemissional(Short exameDemissional) {
        this.exameDemissional = exameDemissional;
    }

    @Column(name="CODIGO_EXAME", length=45)
    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EXAME")
    public Date getDataExame() {
        return this.dataExame;
    }

    public void setDataExame(Date dataExame) {
        this.dataExame = dataExame;
    }

    @Column(name="CNPJ_LABORATORIO", length=18)
    public String getCnpjLaboratorio() {
        return this.cnpjLaboratorio;
    }

    public void setCnpjLaboratorio(String cnpjLaboratorio) {
        this.cnpjLaboratorio = cnpjLaboratorio;
    }

    @Column(name="NOME_LABORATORIO", length=100)
    public String getNomeLaboratorio() {
        return this.nomeLaboratorio;
    }

    public void setNomeLaboratorio(String nomeLaboratorio) {
        this.nomeLaboratorio = nomeLaboratorio;
    }

    @Column(name="NOME_MEDICO", length=100)
    public String getNomeMedico() {
        return this.nomeMedico;
    }

    public void setNomeMedico(String nomeMedico) {
        this.nomeMedico = nomeMedico;
    }

    @Column(name="CRM", length=45)
    public String getCrm() {
        return this.crm;
    }

    public void setCrm(String crm) {
        this.crm = crm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CRM", foreignKey=@ForeignKey(name="FK_EXAME_COLABORADOR_UF_CRM"))
    public UnidadeFederativa getUfCrm() {
        return this.ufCrm;
    }

    public void setUfCrm(UnidadeFederativa ufCrm) {
        this.ufCrm = ufCrm;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getClassificacaoRotina() != null ? this.getClassificacaoRotina().getDescricao() : this.getClassificacaoRotina()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_EXAME", foreignKey=@ForeignKey(name="FK_CADASTRO_EXAME_STATUS"))
    public StatusExameColaborador getStatusExame() {
        return this.statusExame;
    }

    public void setStatusExame(StatusExameColaborador statusExame) {
        this.statusExame = statusExame;
    }
}

