/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CadastroConvencaoColetiva;
import com.touchcomp.basementor.model.vo.CalculoComplementoTipoColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocTipoAcordoConvencao;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioColaboradores;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioEvento;
import com.touchcomp.basementor.model.vo.ItemFaixaComplementoSalario;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CALCULO_COMPLEMENTO_SALARIAL")
public class CalculoComplementoSalario
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date periodoInicial;
    private Date periodoFinal;
    private Date dataPagamento;
    private List<ItemFaixaComplementoSalario> itensFaixaSalarial = new ArrayList<ItemFaixaComplementoSalario>();
    private List<ItemComplementoSalarioColaboradores> itensColaboradores = new ArrayList<ItemComplementoSalarioColaboradores>();
    private List<ItemComplementoSalarioEvento> itensEvento = new ArrayList<ItemComplementoSalarioEvento>();
    private List<CalculoComplementoTipoColaborador> tipoColaborar = new ArrayList<CalculoComplementoTipoColaborador>();
    private List<PagamentoFolhaCompColaborador> pagamentosComplementares;
    private TipoCalculoEvento tpValorAdicional;
    private Short possuiValorAdicional = 0;
    private Integer ano = 0;
    private TipoCalculo tipoCalculoFolha;
    private Short incluirFolhaDec = 0;
    private String descricao;
    private Short filtrarSindicato = 0;
    private Sindicato sindicato;
    private Date dataAcordo;
    private Date periodoAcordo;
    private Date dataEfeitoAcordo;
    private String detalhamento;
    private EsocTipoAcordoConvencao tipoAcordoConvencao;
    private CadastroConvencaoColetiva convencao;
    private Short calcularDecTerceiroDissidio = 0;

    public CalculoComplementoSalario() {
        this.dataPagamento = new Date();
        this.pagamentosComplementares = new ArrayList<PagamentoFolhaCompColaborador>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_COMPLEMENTO_SALARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMPLEMENTO_SALARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_INICIAL")
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_FINAL")
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CALCULO_COMPLEMENTO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="complementoSalario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemComplementoSalarioColaboradores> getItensColaboradores() {
        return this.itensColaboradores;
    }

    public void setItensColaboradores(List<ItemComplementoSalarioColaboradores> itensColaboradores) {
        this.itensColaboradores = itensColaboradores;
    }

    @OneToMany(mappedBy="complementoSalario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemComplementoSalarioEvento> getItensEvento() {
        return this.itensEvento;
    }

    public void setItensEvento(List<ItemComplementoSalarioEvento> itensEvento) {
        this.itensEvento = itensEvento;
    }

    @OneToMany(mappedBy="complementoSalario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemFaixaComplementoSalario> getItensFaixaSalarial() {
        return this.itensFaixaSalarial;
    }

    public void setItensFaixaSalarial(List<ItemFaixaComplementoSalario> itensFaixaSalarial) {
        this.itensFaixaSalarial = itensFaixaSalarial;
    }

    @OneToMany(mappedBy="complementoSalario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CalculoComplementoTipoColaborador> getTipoColaborar() {
        return this.tipoColaborar;
    }

    public void setTipoColaborar(List<CalculoComplementoTipoColaborador> tipoColaborar) {
        this.tipoColaborar = tipoColaborar;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.getIdentificador(), this.getPeriodoInicial(), this.getPeriodoFinal()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TP_VALOR_ADICIONAL", foreignKey=@ForeignKey(name="FK_CALCULO_COMPLEMENTO_TP_CAL_A"))
    public TipoCalculoEvento getTpValorAdicional() {
        return this.tpValorAdicional;
    }

    public void setTpValorAdicional(TipoCalculoEvento tpValorAdicional) {
        this.tpValorAdicional = tpValorAdicional;
    }

    @Column(name="POSSUI_VALOR_ADICIONAL")
    public Short getPossuiValorAdicional() {
        return this.possuiValorAdicional;
    }

    public void setPossuiValorAdicional(Short possuiValorAdicional) {
        this.possuiValorAdicional = possuiValorAdicional;
    }

    @Column(name="ANO")
    public Integer getAno() {
        return this.ano;
    }

    public void setAno(Integer ano) {
        this.ano = ano;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_FOLHA", foreignKey=@ForeignKey(name="FK_CALCULO_COMPLEMENTO_S"))
    public TipoCalculo getTipoCalculoFolha() {
        return this.tipoCalculoFolha;
    }

    public void setTipoCalculoFolha(TipoCalculo tipoCalculoFolha) {
        this.tipoCalculoFolha = tipoCalculoFolha;
    }

    @Column(name="INCLUIR_FOLHA_DEC")
    public Short getIncluirFolhaDec() {
        return this.incluirFolhaDec;
    }

    public void setIncluirFolhaDec(Short incluirFolhaDec) {
        this.incluirFolhaDec = incluirFolhaDec;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="FILTRAR_SINDICATO")
    public Short getFiltrarSindicato() {
        return this.filtrarSindicato;
    }

    public void setFiltrarSindicato(Short filtrarSindicato) {
        this.filtrarSindicato = filtrarSindicato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SINDICATO", foreignKey=@ForeignKey(name="FK_COMP_SALARIO_SINDICATO"))
    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicato = sindicato;
    }

    @OneToMany(mappedBy="calculoComplementoSalario", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<PagamentoFolhaCompColaborador> getPagamentosComplementares() {
        return this.pagamentosComplementares;
    }

    public void setPagamentosComplementares(List<PagamentoFolhaCompColaborador> pagamentosComplementares) {
        this.pagamentosComplementares = pagamentosComplementares;
    }

    @Column(name="DATA_ACORDO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAcordo() {
        return this.dataAcordo;
    }

    public void setDataAcordo(Date dataAcordo) {
        this.dataAcordo = dataAcordo;
    }

    @Column(name="PERIODO_ACORDO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoAcordo() {
        return this.periodoAcordo;
    }

    public void setPeriodoAcordo(Date periodoAcordo) {
        this.periodoAcordo = periodoAcordo;
    }

    @Column(name="DATA_EFEITO_ACORDO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEfeitoAcordo() {
        return this.dataEfeitoAcordo;
    }

    public void setDataEfeitoAcordo(Date dataEfeitoAcordo) {
        this.dataEfeitoAcordo = dataEfeitoAcordo;
    }

    @Column(name="DETALHAMENTO", length=255)
    public String getDetalhamento() {
        return this.detalhamento;
    }

    public void setDetalhamento(String detalhamento) {
        this.detalhamento = detalhamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ACORDO_CONVENCAO", foreignKey=@ForeignKey(name="FK_TIPO_ACORDO_COMP_SALARIO"))
    public EsocTipoAcordoConvencao getTipoAcordoConvencao() {
        return this.tipoAcordoConvencao;
    }

    public void setTipoAcordoConvencao(EsocTipoAcordoConvencao tipoAcordoConvencao) {
        this.tipoAcordoConvencao = tipoAcordoConvencao;
    }

    @OneToOne(mappedBy="complementoSalario")
    public CadastroConvencaoColetiva getConvencao() {
        return this.convencao;
    }

    public void setConvencao(CadastroConvencaoColetiva convencao) {
        this.convencao = convencao;
    }

    @Column(name="CALCULAR_DEC_TERCEIRO_DISSIDIO")
    public Short getCalcularDecTerceiroDissidio() {
        return this.calcularDecTerceiroDissidio;
    }

    public void setCalcularDecTerceiroDissidio(Short calcularDecTerceiroDissidio) {
        this.calcularDecTerceiroDissidio = calcularDecTerceiroDissidio;
    }
}

