/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CLASSIFICACAO_MARKETING", uniqueConstraints={@UniqueConstraint(name="UNQ1_CLASSIFICACAO_MARKETING", columnNames={"DESCRICAO"})})
public class ClassificacaoMarketing
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Short ativo = 1;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<SetorUsuario> setoresUsuario = new ArrayList<SetorUsuario>();
    private ModeloFichaTecnica modeloFichaTecnica;

    @Id
    @Column(nullable=false, name="ID_CLASSIFICACAO_MARKETING")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CLASSIFICACAO_MARKETING")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CLASSIFICACAO_MARKETING_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empreasa) {
        this.empresa = empreasa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    @JoinTable(name="class_marketing_set_usu", joinColumns={@JoinColumn(name="id_classificacao_marketing")}, inverseJoinColumns={@JoinColumn(name="id_setor_usuario")})
    public List<SetorUsuario> getSetoresUsuario() {
        return this.setoresUsuario;
    }

    public void setSetoresUsuario(List<SetorUsuario> setoresUsuario) {
        this.setoresUsuario = setoresUsuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FICHA_TEC", foreignKey=@ForeignKey(name="FK_CLASSIFICACAO_MARKETING_MOD"))
    public ModeloFichaTecnica getModeloFichaTecnica() {
        return this.modeloFichaTecnica;
    }

    public void setModeloFichaTecnica(ModeloFichaTecnica modeloFichaTecnica) {
        this.modeloFichaTecnica = modeloFichaTecnica;
    }
}

