/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstCnabPagamento;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.CadastroMultiplosVinculos;
import com.touchcomp.basementor.model.vo.CadastroPlanoSaude;
import com.touchcomp.basementor.model.vo.CategoriaSefip;
import com.touchcomp.basementor.model.vo.CategoriaTrabalhador;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoColaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.DepartamentoColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocCategoriaTrabalhador;
import com.touchcomp.basementor.model.vo.EsocCondicaoTrabalhadorEstrangeiro;
import com.touchcomp.basementor.model.vo.EsocGrauExpAgentNocivos;
import com.touchcomp.basementor.model.vo.EsocIndInssMultVinculos;
import com.touchcomp.basementor.model.vo.EsocIndicativoAdmissao;
import com.touchcomp.basementor.model.vo.EsocMotivoContratacao;
import com.touchcomp.basementor.model.vo.EsocNaturezaAtividade;
import com.touchcomp.basementor.model.vo.EsocNivelEstagio;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocRegimeJornadaTrab;
import com.touchcomp.basementor.model.vo.EsocTipoAdmissao;
import com.touchcomp.basementor.model.vo.EsocTipoInclusaoContrato;
import com.touchcomp.basementor.model.vo.EsocTipoInscricaoEmpregador;
import com.touchcomp.basementor.model.vo.EsocTreinamentoColaborador;
import com.touchcomp.basementor.model.vo.EstadoCivil;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GrauInstrucao;
import com.touchcomp.basementor.model.vo.GrupoSanguineo;
import com.touchcomp.basementor.model.vo.HistoricoHorarioColaborador;
import com.touchcomp.basementor.model.vo.HistoricoLotacaoTributaria;
import com.touchcomp.basementor.model.vo.HoraExtraHorTrab;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.IndicadorVinculoTrabalhador;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.InstituicaoEnsino;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.LocalTrabalhoColaboradorCidade;
import com.touchcomp.basementor.model.vo.Nacionalidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.RacaCor;
import com.touchcomp.basementor.model.vo.Rat;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RegistroAdmissaoPreLiminar;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.SituacaoColaborador;
import com.touchcomp.basementor.model.vo.TipoAdmissaoCaged;
import com.touchcomp.basementor.model.vo.TipoAdmissaoRais;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoDeficiencia;
import com.touchcomp.basementor.model.vo.TipoLogradouroEndereco;
import com.touchcomp.basementor.model.vo.TipoPagamentoFolha;
import com.touchcomp.basementor.model.vo.TipoPagamentoPensao;
import com.touchcomp.basementor.model.vo.TipoParentescoColaborador;
import com.touchcomp.basementor.model.vo.TipoRegimePrevidenciario;
import com.touchcomp.basementor.model.vo.TipoRegimeTrabalhista;
import com.touchcomp.basementor.model.vo.TipoSalario;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VinculoEmpregaticio;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="COLABORADOR", uniqueConstraints={@UniqueConstraint(name="UNQ1_COLABORADOR", columnNames={"ID_PESSOA", "DATA_DEMISSAO", "ID_EMPRESA"}), @UniqueConstraint(name="UNQ2_COLABORADOR", columnNames={"NUMERO_REGISTRO", "ID_EMPRESA"})})
public class Colaborador
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Pessoa pessoa;
    private CentroCusto centroCusto;
    private TipoColaborador tipoColaborador;
    private Nacionalidade nacionalidade;
    private Integer anoChegada = 0;
    private Cidade cidadeNascimento;
    private GrauInstrucao grauInstrucao;
    private EstadoCivil estadoCivil;
    private String numeroPis;
    private String carteiraProfissional;
    private String serieCarteiraProfissional;
    private UnidadeFederativa ufCarteiraProfissional;
    private String carteiraReservista;
    private String carteiraHabilitacao;
    private String tituloEleitor;
    private RacaCor racaCor;
    private TipoDeficiencia tipoDeficiencia;
    private Short alvaraJudicial = 0;
    private Date dataAdmissao;
    private Date novoPeriodoAquisitivo;
    private Date dataTransferencia;
    private TipoAdmissaoRais tipoAdmissaoRais;
    private String periodoAdmissao;
    private Short optanteFgts = 0;
    private Funcao funcao;
    private Sindicato sindicato;
    private VinculoEmpregaticio vinculoEmpregaticio;
    private Integer jornadaSemanal = 0;
    private Double horasTrabDia = 0.0;
    private Double diasJornada = 0.0;
    private Short tipoAdiantamento = 0;
    private Double percValorAdiantamento = 0.0;
    private Short periodoPagamento = 0;
    private Empresa empresa;
    private Date dataCadastro;
    private Short sexo = 0;
    private Timestamp dataAtualizacao;
    private String numeroRegistro;
    private HorarioTrabalho horarioTrabalho;
    private TipoSalario tipoSalario;
    private Double valorPorHora = 0.0;
    private Double valorTributosPorHora = 0.0;
    private String senhaAcessoColab;
    private List<EventoColaborador> eventos;
    private Short ativo = 1;
    private TipoAdmissaoCaged tipoAdmissaoCaged;
    private String codigoDesligamento;
    private CategoriaTrabalhador categoriaTrabalhador;
    private CategoriaSefip categoriaSefip;
    private Rat rat;
    private String nomeMae;
    private Date primeiraDataExperiencia;
    private Date segundaDataExperiencia;
    private String diasExperiencia;
    private Double qtdadeValeTransportes = 0.0;
    private List<Recisao> recisoes;
    private List<AfastamentoColaborador> afastamentos;
    private PlanoConta planoContaDebito;
    private PlanoConta planoContaCredito;
    private Date dataDemissao;
    private String observacoes;
    private Short recebimentoSeguroDesemprego = 0;
    private String nomePai;
    private Date dataEmissaoCTPS;
    private Short tipoPagamento;
    private Short gerarArredondamento = 1;
    private Date dataUltimaContribuicaoSindical;
    private Date dataChegada;
    private String portariaNaturalizacao;
    private Date dataNaturalizacao;
    private String zonaTituloEleitor;
    private String secaoTituloEleitor;
    private Short tipoEndereco = 0;
    private TipoLogradouroEndereco tipoLogradouroEndereco;
    private Short compoePlanilhaExcel = 0;
    private List<TipoParentescoColaborador> tipoParentescoColaborador;
    private String contato;
    private String foneFixo;
    private String foneCelular;
    private String registroNacionalEstrangeiros;
    private String orgaoEmissaoRNE;
    private Date dataEmissaoRNE;
    private String numeroOrgaoClasse;
    private String orgaoEmissorClasse;
    private Date dataEmissaoClasse;
    private Date dataValidadeOrgaoClasse;
    private Date dataExpedicaoCNH;
    private UnidadeFederativa ufCNH;
    private Date dataValidadeCNH;
    private Date dataPrimeiraCNH;
    private String categoriaCNH;
    private EsocCondicaoTrabalhadorEstrangeiro condicaoEstrangeiro;
    private Short estrangeiroFilhoBrasileiro = 0;
    private Short colaboradorReabilitado = 0;
    private Short recebeAposentadoria = 0;
    private EsocTipoAdmissao tipoAdmissaoEsocial;
    private EsocIndicativoAdmissao indicativoAdmissao;
    private EsocRegimeJornadaTrab regimeJornadaTrabalho;
    private EsocMotivoContratacao motivoContratacao;
    private Pessoa pessoaEmpregoAnterior;
    private String numeroRegistroAnterior;
    private Date dataAdmissaoAnterior;
    private String observacaoEmpregAnterior;
    private ArquivamentoDoc arquivamentoDoc;
    private Double valorTicket = 0.0;
    private Short horaExtraHabitual = 1;
    private Short addNoturnoHabitual = 1;
    private Short utilizacaoEPI = 1;
    private Integer jornadaSemanalTrabalho = 0;
    private Date alteracaoPeriodoAquisitivo;
    private IndicadorVinculoTrabalhador indicadorVinculoTrabalhador;
    private TipoRegimeTrabalhista regimeTrabalhista;
    private TipoRegimePrevidenciario regimePrevidenciario;
    private Short gerarFinanceiro = 1;
    private Short compoeIntegracaoPonto = 1;
    private GrupoSanguineo grupoSanguineo;
    private SituacaoColaborador situacaoColaborador;
    private ClassificacaoColaborador classificacaoColaborador;
    private InstituicaoEnsino instituicaoEnsino;
    private Double horasMesColaborador = 0.0;
    private Short trabalhoParcial = 0;
    private Short teleTrabalho = 0;
    private Short trabalhoInterminente = 0;
    private Short possuiDescontoPensao = 0;
    private Double percentualPensao = 0.0;
    private Short nrBeneficiarios = 0;
    private TipoPagamentoPensao tipoPagamentoPensao;
    private Double valorFixoPensao = 0.0;
    private Short pagAddNoturnoCincoHoras = 0;
    private Double horasNoturnas = 0.0;
    private Short naoPossuiValoresVA = 0;
    private InstituicaoValores banco;
    private String agencia;
    private String conta;
    private String operacao;
    private Short casadoComBrasileiro = 0;
    private EsocNaturezaAtividade naturezaAtividade;
    private EsocCategoriaTrabalhador esocCategoriaTrabalhador;
    private Short primeiroEmprego = 0;
    private UnidadeFederativa ufRNE;
    private UnidadeFederativa ufOrgaoClasse;
    private Short colaboradorIncapaz = 0;
    private String emailPessoal;
    private String descricaoColaboradorTemp;
    private EsocTipoInclusaoContrato tipoInclusaoContrato;
    private EsocTipoInscricaoEmpregador tipoInscricaoTomador;
    private EsocTipoInscricaoEmpregador tipoInscricaoEstabelecimento;
    private String inscricaoTomador;
    private String inscricaoEstabelecimento;
    private String cpfColaboradorSubstituido;
    private Short clausulaAssecuratoria = 0;
    private String observacaoContratoTrabalho;
    private String cnpjEmpregadorAnterior;
    private String matriculaAnterior;
    private Date dataTransferenciaEmpregado;
    private String observacaoSucessaoVinculo;
    private EsocNivelEstagio nivelEstagio;
    private String areaAtuacaoEstagio;
    private String nrApoliceSeguroEstagio;
    private Double valorBolsaEstagio = 0.0;
    private Date dataTerminoEstagio;
    private Short naturezaEstagio = 0;
    private InstituicaoEnsino instituicaoEnsinoEstagio;
    private Pessoa agenteEstagio;
    private String nomeSupervisorEstagio;
    private String cpfSupervisorEstagio;
    private String nomeSocialTravesti;
    private List<EsocPreEvento> preEventosEsocial;
    private String descricaoSalario;
    private Pessoa LocalTrabTemporario;
    private TipoLogradouroEndereco tipoLogradouroTemp;
    private List<HistoricoHorarioColaborador> historicoHorario;
    private EsocCadastroEstabelcimento estabelecimento;
    private EsocCadastroLotacaoTributaria lotacaoTributaria;
    private EsocGrauExpAgentNocivos grauExposicao;
    private RegistroAdmissaoPreLiminar registroAdmissao;
    private List<CadastroMultiplosVinculos> multiplosVinculos;
    private EsocIndInssMultVinculos esocIndicativoInss;
    private String numeroRegistroESocial;
    private TipoPagamentoFolha tipoPagamentoFolha;
    private Double valorSalario = 0.0;
    private LocalTrabalhoColaboradorCidade localTrabalhoColaboradorCidade;
    private Short informarReciboManual = 0;
    private String numeroReciboEsocial;
    private DepartamentoColaborador departamento;
    private Short preencherCarteiraCpf = 0;
    private CadastroPlanoSaude planoSaude;
    private String numeroCarteiraPlanoSaude;
    private Short pagamentoFeitoPeloBanco = 0;
    private Short tipoAdesao = 0;
    private Date dataAcordoBeneficio;
    private Date dataInicioBeneficio;
    private Date dataFinalBeneficio;
    private Long diasAdesao = 0L;
    private Double percReducao = 0.0;
    private Short aderidoBeneficioEmergencial = 0;
    private Double salarioPeriodo = 0.0;
    private List<HistoricoLotacaoTributaria> historicoLotacaoTributaria;
    private InfoHorarioTrabalho horarioAdmissao;
    private Double percDescontoCompras = 0.0;
    private List<HoraExtraHorTrab> horasExtras;
    private Date dataInicioIndice;
    private Pessoa pessoaGestor;
    private List<EsocTreinamentoColaborador> treinamentos;
    private List<ColaboradorDependente> dependentesColaborador = new ArrayList<ColaboradorDependente>();

    public Colaborador() {
        this.preEventosEsocial = new ArrayList<EsocPreEvento>();
        this.horasExtras = new ArrayList<HoraExtraHorTrab>();
        this.eventos = new ArrayList<EventoColaborador>();
        this.tipoPagamento = EnumConstCnabPagamento.PAGAMENTO_DINHEIRO.getEnumId();
        this.tipoParentescoColaborador = new ArrayList<TipoParentescoColaborador>();
        this.recisoes = new ArrayList<Recisao>();
        this.afastamentos = new ArrayList<AfastamentoColaborador>();
        this.historicoHorario = new ArrayList<HistoricoHorarioColaborador>();
        this.multiplosVinculos = new ArrayList<CadastroMultiplosVinculos>();
        this.historicoLotacaoTributaria = new ArrayList<HistoricoLotacaoTributaria>();
        this.treinamentos = new ArrayList<EsocTreinamentoColaborador>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getNumeroRegistro(), this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COLABORADOR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa idEmp) {
        this.empresa = idEmp;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_COLABORADOR_PESSOA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="ALVARA_JUDICIAL")
    public Short getAlvaraJudicial() {
        return this.alvaraJudicial;
    }

    public void setAlvaraJudicial(Short alvaraJudicial) {
        this.alvaraJudicial = alvaraJudicial;
    }

    @Column(name="ANO_CHEGADA")
    public Integer getAnoChegada() {
        return this.anoChegada;
    }

    public void setAnoChegada(Integer anoChegada) {
        this.anoChegada = anoChegada;
    }

    @Column(name="CARTEIRA_HABILITACAO", length=20)
    public String getCarteiraHabilitacao() {
        return this.carteiraHabilitacao;
    }

    public void setCarteiraHabilitacao(String carteiraHabilitacao) {
        this.carteiraHabilitacao = carteiraHabilitacao;
    }

    @Column(name="CARTEIRA_PROFISSIONAL", length=20)
    public String getCarteiraProfissional() {
        return this.carteiraProfissional;
    }

    public void setCarteiraProfissional(String carteiraProfissional) {
        this.carteiraProfissional = carteiraProfissional;
    }

    @Column(name="CARTEIRA_RESERVISTA", length=20)
    public String getCarteiraReservista() {
        return this.carteiraReservista;
    }

    public void setCarteiraReservista(String carteiraReservista) {
        this.carteiraReservista = carteiraReservista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_COLABORADOR_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_NASCIMENTO", foreignKey=@ForeignKey(name="FK_COLABORADOR_CID_NASCIMENTO"))
    public Cidade getCidadeNascimento() {
        return this.cidadeNascimento;
    }

    public void setCidadeNascimento(Cidade cidadeNascimento) {
        this.cidadeNascimento = cidadeNascimento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADMISSAO")
    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public void setDataAdmissao(Date dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TRANSFERENCIA")
    public Date getDataTransferencia() {
        return this.dataTransferencia;
    }

    public void setDataTransferencia(Date dataTransferencia) {
        this.dataTransferencia = dataTransferencia;
    }

    @Column(name="DIAS_JORNADA")
    public Double getDiasJornada() {
        return this.diasJornada;
    }

    public void setDiasJornada(Double diasJornada) {
        this.diasJornada = diasJornada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTADO_CIVIL", foreignKey=@ForeignKey(name="FK_COLABORADOR_ESTADO_CIVIL"))
    public EstadoCivil getEstadoCivil() {
        return this.estadoCivil;
    }

    public void setEstadoCivil(EstadoCivil estadoCivil) {
        this.estadoCivil = estadoCivil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_FUNCAO"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRAU_INSTRUCAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_GRAU_INSTR"))
    public GrauInstrucao getGrauInstrucao() {
        return this.grauInstrucao;
    }

    public void setGrauInstrucao(GrauInstrucao grauInstrucao) {
        this.grauInstrucao = grauInstrucao;
    }

    @Column(name="HORAS_TRAB_DIA", precision=15, scale=2)
    public Double getHorasTrabDia() {
        return this.horasTrabDia;
    }

    public void setHorasTrabDia(Double horasTrabDia) {
        this.horasTrabDia = horasTrabDia;
    }

    @Column(name="JORNADA_SEMANAL", precision=15, scale=2)
    public Integer getJornadaSemanal() {
        return this.jornadaSemanal;
    }

    public void setJornadaSemanal(Integer jornadaSemanal) {
        this.jornadaSemanal = jornadaSemanal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NACIONALIDADE", foreignKey=@ForeignKey(name="FK_COLABORADOR_NACIONALIDADE"))
    public Nacionalidade getNacionalidade() {
        return this.nacionalidade;
    }

    public void setNacionalidade(Nacionalidade nacionalidade) {
        this.nacionalidade = nacionalidade;
    }

    @Column(name="NOVO_PERIODO_AQUISITIVO")
    @Temporal(value=TemporalType.DATE)
    public Date getNovoPeriodoAquisitivo() {
        return this.novoPeriodoAquisitivo;
    }

    public void setNovoPeriodoAquisitivo(Date novoPeriodoAquisitivo) {
        this.novoPeriodoAquisitivo = novoPeriodoAquisitivo;
    }

    @Column(name="NUMERO_PIS", length=18)
    public String getNumeroPis() {
        return this.numeroPis;
    }

    public void setNumeroPis(String numeroPis) {
        this.numeroPis = numeroPis;
    }

    @Column(name="OPTANTE_FGTS")
    public Short getOptanteFgts() {
        return this.optanteFgts;
    }

    public void setOptanteFgts(Short optanteFgts) {
        this.optanteFgts = optanteFgts;
    }

    @Column(name="PERC_VALOR_ADIANTAMENTO", precision=12, scale=2)
    public Double getPercValorAdiantamento() {
        return this.percValorAdiantamento;
    }

    public void setPercValorAdiantamento(Double percValorAdiantamento) {
        this.percValorAdiantamento = percValorAdiantamento;
    }

    @Column(name="PERIODO_ADMISSAO", length=7)
    public String getPeriodoAdmissao() {
        return this.periodoAdmissao;
    }

    public void setPeriodoAdmissao(String periodoAdmissao) {
        this.periodoAdmissao = periodoAdmissao;
    }

    @Column(name="PERIODO_PAGAMENTO")
    public Short getPeriodoPagamento() {
        return this.periodoPagamento;
    }

    public void setPeriodoPagamento(Short periodoPagamento) {
        this.periodoPagamento = periodoPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RACA_COR", foreignKey=@ForeignKey(name="FK_COLABORADOR_RACA_COR"))
    public RacaCor getRacaCor() {
        return this.racaCor;
    }

    public void setRacaCor(RacaCor racaCor) {
        this.racaCor = racaCor;
    }

    @Column(name="SERIE_CARTEIRA_PROFISSIONAL", length=5)
    public String getSerieCarteiraProfissional() {
        return this.serieCarteiraProfissional;
    }

    public void setSerieCarteiraProfissional(String serieCarteiraProfissional) {
        this.serieCarteiraProfissional = serieCarteiraProfissional;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SINDICATO", foreignKey=@ForeignKey(name="FK_COLABORADOR_SINDICADO"))
    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicato = sindicato;
    }

    @Column(name="TIPO_ADIANTAMENTO")
    public Short getTipoAdiantamento() {
        return this.tipoAdiantamento;
    }

    public void setTipoAdiantamento(Short tipoAdiantamento) {
        this.tipoAdiantamento = tipoAdiantamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ADMISSAO_RAIS", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_ADMINISSAO_RA"))
    public TipoAdmissaoRais getTipoAdmissaoRais() {
        return this.tipoAdmissaoRais;
    }

    public void setTipoAdmissaoRais(TipoAdmissaoRais tipoAdmissaoRais) {
        this.tipoAdmissaoRais = tipoAdmissaoRais;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_TIPO_COLABORADOR"))
    public TipoColaborador getTipoColaborador() {
        return this.tipoColaborador;
    }

    public void setTipoColaborador(TipoColaborador tipoColaborador) {
        this.tipoColaborador = tipoColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DEFICIENCIA", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_DEFICIENCIA"))
    public TipoDeficiencia getTipoDeficiencia() {
        return this.tipoDeficiencia;
    }

    public void setTipoDeficiencia(TipoDeficiencia tipoDeficiencia) {
        this.tipoDeficiencia = tipoDeficiencia;
    }

    @Column(name="TITULO_ELEITOR", length=18)
    public String getTituloEleitor() {
        return this.tituloEleitor;
    }

    public void setTituloEleitor(String tituloEleitor) {
        this.tituloEleitor = tituloEleitor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CART_PROFISSIONAL", foreignKey=@ForeignKey(name="FK_COLABORADOR_UF_CART_PROF"))
    public UnidadeFederativa getUfCarteiraProfissional() {
        return this.ufCarteiraProfissional;
    }

    public void setUfCarteiraProfissional(UnidadeFederativa ufCarteiraProfissional) {
        this.ufCarteiraProfissional = ufCarteiraProfissional;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_VINCULO_EMPREGATICIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_VINC_EMPREGATICI"))
    public VinculoEmpregaticio getVinculoEmpregaticio() {
        return this.vinculoEmpregaticio;
    }

    public void setVinculoEmpregaticio(VinculoEmpregaticio vinculoEmpregaticio) {
        this.vinculoEmpregaticio = vinculoEmpregaticio;
    }

    @Column(nullable=false, name="SEXO")
    public Short getSexo() {
        return this.sexo;
    }

    public void setSexo(Short sexo) {
        this.sexo = sexo;
    }

    @Column(nullable=true, name="NUMERO_REGISTRO")
    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HORARIO_TRABALHO", foreignKey=@ForeignKey(name="FK_COLABORADOR_HORARIO_TRAB"))
    public HorarioTrabalho getHorarioTrabalho() {
        return this.horarioTrabalho;
    }

    public void setHorarioTrabalho(HorarioTrabalho horarioTrabalho) {
        this.horarioTrabalho = horarioTrabalho;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SALARIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_SALARIO"))
    public TipoSalario getTipoSalario() {
        return this.tipoSalario;
    }

    public void setTipoSalario(TipoSalario tipoSalario) {
        this.tipoSalario = tipoSalario;
    }

    @Column(name="VALOR_POR_HORA", precision=15, scale=4)
    public Double getValorPorHora() {
        return this.valorPorHora;
    }

    public void setValorPorHora(Double valorPorHora) {
        this.valorPorHora = valorPorHora;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EventoColaborador> getEventos() {
        return this.eventos;
    }

    public void setEventos(List<EventoColaborador> eventoColaborador) {
        this.eventos = eventoColaborador;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoParentescoColaborador> getTipoParentescoColaborador() {
        return this.tipoParentescoColaborador;
    }

    public void setTipoParentescoColaborador(List<TipoParentescoColaborador> tipoParentescoColaborador) {
        this.tipoParentescoColaborador = tipoParentescoColaborador;
    }

    @Column(name="VALOR_TRIBUTOS_POR_HORA", precision=15, scale=2)
    public Double getValorTributosPorHora() {
        return this.valorTributosPorHora;
    }

    public void setValorTributosPorHora(Double valorTributosPorHora) {
        this.valorTributosPorHora = valorTributosPorHora;
    }

    @Column(name="SENHA_ACESSO_COLAB", length=5)
    public String getSenhaAcessoColab() {
        return this.senhaAcessoColab;
    }

    public void setSenhaAcessoColab(String senhaAcessoColab) {
        this.senhaAcessoColab = senhaAcessoColab;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @JoinColumn(name="ID_TIPO_ADMISSAO_CAGED", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_ADM_CAGED"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoAdmissaoCaged getTipoAdmissaoCaged() {
        return this.tipoAdmissaoCaged;
    }

    public void setTipoAdmissaoCaged(TipoAdmissaoCaged tipoAdmissaoCaged) {
        this.tipoAdmissaoCaged = tipoAdmissaoCaged;
    }

    @Column(name="CODIGO_DESLIGAMENTO", length=5)
    public String getCodigoDesligamento() {
        return this.codigoDesligamento;
    }

    public void setCodigoDesligamento(String codigoDesligamento) {
        this.codigoDesligamento = codigoDesligamento;
    }

    @JoinColumn(name="ID_CATEGORIA_TRABALHADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_CAT_TRABALHADOR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CategoriaTrabalhador getCategoriaTrabalhador() {
        return this.categoriaTrabalhador;
    }

    public void setCategoriaTrabalhador(CategoriaTrabalhador categoriaTrabalhador) {
        this.categoriaTrabalhador = categoriaTrabalhador;
    }

    @JoinColumn(name="ID_CATEGORIA_SEFIP", foreignKey=@ForeignKey(name="FK_COLABORADOR_CAT_SEFIP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CategoriaSefip getCategoriaSefip() {
        return this.categoriaSefip;
    }

    public void setCategoriaSefip(CategoriaSefip categoriaSefip) {
        this.categoriaSefip = categoriaSefip;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RAT", foreignKey=@ForeignKey(name="FK_COLABORADOR_RAT"))
    public Rat getRat() {
        return this.rat;
    }

    public void setRat(Rat rat) {
        this.rat = rat;
    }

    @Transient
    public Double getSalarioPeriodo() {
        return this.salarioPeriodo;
    }

    public void setSalarioPeriodo(Double salarioPeriodo) {
        this.salarioPeriodo = salarioPeriodo;
    }

    @Column(name="NOME_MAE", length=150)
    public String getNomeMae() {
        return this.nomeMae;
    }

    public void setNomeMae(String nomeMae) {
        this.nomeMae = nomeMae;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PRIMEIRA_DATA_EXPERIENCIA")
    public Date getPrimeiraDataExperiencia() {
        return this.primeiraDataExperiencia;
    }

    public void setPrimeiraDataExperiencia(Date primeiraDataExperiencia) {
        this.primeiraDataExperiencia = primeiraDataExperiencia;
    }

    @Column(name="SEGUNDA_DATA_EXPERIENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getSegundaDataExperiencia() {
        return this.segundaDataExperiencia;
    }

    public void setSegundaDataExperiencia(Date segundaDataExperiencia) {
        this.segundaDataExperiencia = segundaDataExperiencia;
    }

    @Column(name="DIAS_EXPERIENCIA", length=100)
    public String getDiasExperiencia() {
        return this.diasExperiencia;
    }

    public void setDiasExperiencia(String diasExperiencia) {
        this.diasExperiencia = diasExperiencia;
    }

    @Column(name="QTDADE_VALE_TRANSPORTES", precision=15, scale=4)
    public Double getQtdadeValeTransportes() {
        return this.qtdadeValeTransportes;
    }

    public void setQtdadeValeTransportes(Double qtdadeValeTransportes) {
        this.qtdadeValeTransportes = qtdadeValeTransportes;
    }

    @OneToMany(mappedBy="colaborador")
    public List<Recisao> getRecisoes() {
        return this.recisoes;
    }

    public void setRecisoes(List<Recisao> recisoes) {
        this.recisoes = recisoes;
    }

    @OneToMany(mappedBy="colaborador")
    public List<AfastamentoColaborador> getAfastamentos() {
        return this.afastamentos;
    }

    public void setAfastamentos(List<AfastamentoColaborador> afastamentos) {
        this.afastamentos = afastamentos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEBITO", foreignKey=@ForeignKey(name="FK_COLABORADOR_PLANO_DEBITO"))
    public PlanoConta getPlanoContaDebito() {
        return this.planoContaDebito;
    }

    public void setPlanoContaDebito(PlanoConta planoContaDebito) {
        this.planoContaDebito = planoContaDebito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CREDITO", foreignKey=@ForeignKey(name="FK_COLABORADOR_PLANO_CREDITO"))
    public PlanoConta getPlanoContaCredito() {
        return this.planoContaCredito;
    }

    public void setPlanoContaCredito(PlanoConta planoContaCredito) {
        this.planoContaCredito = planoContaCredito;
    }

    @Column(name="DATA_DEMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataDemissao() {
        return this.dataDemissao;
    }

    public void setDataDemissao(Date dataDemissao) {
        this.dataDemissao = dataDemissao;
    }

    @Column(name="OBSERVACOES", length=500)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="RECEBIMENTO_SEGURO_DESEMPREGO")
    public Short getRecebimentoSeguroDesemprego() {
        return this.recebimentoSeguroDesemprego;
    }

    public void setRecebimentoSeguroDesemprego(Short recebimentoSeguroDesemprego) {
        this.recebimentoSeguroDesemprego = recebimentoSeguroDesemprego;
    }

    @Column(name="NOME_PAI", length=50)
    public String getNomePai() {
        return this.nomePai;
    }

    public void setNomePai(String nomePai) {
        this.nomePai = nomePai;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_CTPS")
    public Date getDataEmissaoCTPS() {
        return this.dataEmissaoCTPS;
    }

    public void setDataEmissaoCTPS(Date dataEmissaoCTPS) {
        this.dataEmissaoCTPS = dataEmissaoCTPS;
    }

    @Column(name="TIPO_PAGAMENTO")
    public Short getTipoPagamento() {
        return this.tipoPagamento;
    }

    public void setTipoPagamento(Short tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
    }

    @Column(name="GERAR_ARREDONDAMENTO_FOLHA")
    public Short getGerarArredondamento() {
        return this.gerarArredondamento;
    }

    public void setGerarArredondamento(Short gerarArredondamento) {
        this.gerarArredondamento = gerarArredondamento;
    }

    @Column(name="ULTIMA_CONTRIBUICAO_SINDICAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataUltimaContribuicaoSindical() {
        return this.dataUltimaContribuicaoSindical;
    }

    public void setDataUltimaContribuicaoSindical(Date dataUltimaContribuicaoSindical) {
        this.dataUltimaContribuicaoSindical = dataUltimaContribuicaoSindical;
    }

    @Column(name="DATA_CHEGADA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataChegada() {
        return this.dataChegada;
    }

    public void setDataChegada(Date dataChegada) {
        this.dataChegada = dataChegada;
    }

    @Column(name="PORTARIA_NATURALIZACAO", length=16)
    public String getPortariaNaturalizacao() {
        return this.portariaNaturalizacao;
    }

    public void setPortariaNaturalizacao(String portariaNaturalizacao) {
        this.portariaNaturalizacao = portariaNaturalizacao;
    }

    @Column(name="DATA_NATURALIZACAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataNaturalizacao() {
        return this.dataNaturalizacao;
    }

    public void setDataNaturalizacao(Date dataNaturalizacao) {
        this.dataNaturalizacao = dataNaturalizacao;
    }

    @Column(name="ZONA_TITULO_ELEITOR", length=40)
    public String getZonaTituloEleitor() {
        return this.zonaTituloEleitor;
    }

    public void setZonaTituloEleitor(String zonaTituloEleitor) {
        this.zonaTituloEleitor = zonaTituloEleitor;
    }

    @Column(name="SECAO_TITULO_ELEITOR", length=40)
    public String getSecaoTituloEleitor() {
        return this.secaoTituloEleitor;
    }

    public void setSecaoTituloEleitor(String secaoTituloEleitor) {
        this.secaoTituloEleitor = secaoTituloEleitor;
    }

    @Column(name="TIPO_ENDERECO")
    public Short getTipoEndereco() {
        return this.tipoEndereco;
    }

    public void setTipoEndereco(Short tipoEndereco) {
        this.tipoEndereco = tipoEndereco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_LOGRADOURO_ENDERECO", foreignKey=@ForeignKey(name="FK_COLABORADOR_TIPO_LOGRADOURO"))
    public TipoLogradouroEndereco getTipoLogradouroEndereco() {
        return this.tipoLogradouroEndereco;
    }

    public void setTipoLogradouroEndereco(TipoLogradouroEndereco tipoLogradouroEndereco) {
        this.tipoLogradouroEndereco = tipoLogradouroEndereco;
    }

    @Column(name="COMPOE_PLANILHA_EXCEL")
    public Short getCompoePlanilhaExcel() {
        return this.compoePlanilhaExcel;
    }

    public void setCompoePlanilhaExcel(Short compoePlanilhaExcel) {
        this.compoePlanilhaExcel = compoePlanilhaExcel;
    }

    @Column(name="CONTATO", length=100)
    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    @Column(name="FONE_FIXO", length=50)
    public String getFoneFixo() {
        return this.foneFixo;
    }

    public void setFoneFixo(String foneFixo) {
        this.foneFixo = foneFixo;
    }

    @Column(name="FONE_CELULAR", length=50)
    public String getFoneCelular() {
        return this.foneCelular;
    }

    public void setFoneCelular(String foneCelular) {
        this.foneCelular = foneCelular;
    }

    @Column(name="REGISTRO_NACIONAL_ESTRANGEIROS", length=50)
    public String getRegistroNacionalEstrangeiros() {
        return this.registroNacionalEstrangeiros;
    }

    public void setRegistroNacionalEstrangeiros(String registroNacionalEstrangeiros) {
        this.registroNacionalEstrangeiros = registroNacionalEstrangeiros;
    }

    @Column(name="ORGAO_EMISSAO_RNE", length=30)
    public String getOrgaoEmissaoRNE() {
        return this.orgaoEmissaoRNE;
    }

    public void setOrgaoEmissaoRNE(String orgaoEmissaoRNE) {
        this.orgaoEmissaoRNE = orgaoEmissaoRNE;
    }

    @Column(name="DATA_EMISSAO_RNE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoRNE() {
        return this.dataEmissaoRNE;
    }

    public void setDataEmissaoRNE(Date dataEmissaoRNE) {
        this.dataEmissaoRNE = dataEmissaoRNE;
    }

    @Column(name="NUMERO_ORGAO_CLASSE", length=50)
    public String getNumeroOrgaoClasse() {
        return this.numeroOrgaoClasse;
    }

    public void setNumeroOrgaoClasse(String numeroOrgaoClasse) {
        this.numeroOrgaoClasse = numeroOrgaoClasse;
    }

    @Column(name="ORGAO_EMISSOR_CLASSE", length=50)
    public String getOrgaoEmissorClasse() {
        return this.orgaoEmissorClasse;
    }

    public void setOrgaoEmissorClasse(String orgaoEmissorClasse) {
        this.orgaoEmissorClasse = orgaoEmissorClasse;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO_CLASSE")
    public Date getDataEmissaoClasse() {
        return this.dataEmissaoClasse;
    }

    public void setDataEmissaoClasse(Date dataEmissaoClasse) {
        this.dataEmissaoClasse = dataEmissaoClasse;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EXPEDICAO_CNH")
    public Date getDataExpedicaoCNH() {
        return this.dataExpedicaoCNH;
    }

    public void setDataExpedicaoCNH(Date dataExpedicaoCNH) {
        this.dataExpedicaoCNH = dataExpedicaoCNH;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_CNH", foreignKey=@ForeignKey(name="FK_COLABORADOR_UF_CNH"))
    public UnidadeFederativa getUfCNH() {
        return this.ufCNH;
    }

    public void setUfCNH(UnidadeFederativa ufCNH) {
        this.ufCNH = ufCNH;
    }

    @Column(name="DATA_VALIDADE_CNH")
    @Temporal(value=TemporalType.DATE)
    public Date getDataValidadeCNH() {
        return this.dataValidadeCNH;
    }

    public void setDataValidadeCNH(Date dataValidadeCNH) {
        this.dataValidadeCNH = dataValidadeCNH;
    }

    @Column(name="DATA_PRIMEIRA_CNH")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrimeiraCNH() {
        return this.dataPrimeiraCNH;
    }

    public void setDataPrimeiraCNH(Date dataPrimeiraCNH) {
        this.dataPrimeiraCNH = dataPrimeiraCNH;
    }

    @Column(name="CATEGORIA_CNH", length=10)
    public String getCategoriaCNH() {
        return this.categoriaCNH;
    }

    public void setCategoriaCNH(String categoriaCNH) {
        this.categoriaCNH = categoriaCNH;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_ESTRANGEIRO", foreignKey=@ForeignKey(name="FK_COLABORADOR_COND_ESTRANGEIRO"))
    public EsocCondicaoTrabalhadorEstrangeiro getCondicaoEstrangeiro() {
        return this.condicaoEstrangeiro;
    }

    public void setCondicaoEstrangeiro(EsocCondicaoTrabalhadorEstrangeiro condicaoEstrangeiro) {
        this.condicaoEstrangeiro = condicaoEstrangeiro;
    }

    @Column(name="ESTRANGEIRO_FILHO_BRASILEIRO")
    public Short getEstrangeiroFilhoBrasileiro() {
        return this.estrangeiroFilhoBrasileiro;
    }

    public void setEstrangeiroFilhoBrasileiro(Short estrangeiroFilhoBrasileiro) {
        this.estrangeiroFilhoBrasileiro = estrangeiroFilhoBrasileiro;
    }

    @Column(name="COLABORADOR_REABILITADO")
    public Short getColaboradorReabilitado() {
        return this.colaboradorReabilitado;
    }

    public void setColaboradorReabilitado(Short colaboradorReabilitado) {
        this.colaboradorReabilitado = colaboradorReabilitado;
    }

    @Column(name="RECEBE_APOSENTADORIA")
    public Short getRecebeAposentadoria() {
        return this.recebeAposentadoria;
    }

    public void setRecebeAposentadoria(Short recebeAposentadoria) {
        this.recebeAposentadoria = recebeAposentadoria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ADMISSAO_ESOCIAL", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_ADMIS_ESOCIAL"))
    public EsocTipoAdmissao getTipoAdmissaoEsocial() {
        return this.tipoAdmissaoEsocial;
    }

    public void setTipoAdmissaoEsocial(EsocTipoAdmissao tipoAdmissaoEsocial) {
        this.tipoAdmissaoEsocial = tipoAdmissaoEsocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICATIVO_ADMISSAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_IND_ADMISSAO"))
    public EsocIndicativoAdmissao getIndicativoAdmissao() {
        return this.indicativoAdmissao;
    }

    public void setIndicativoAdmissao(EsocIndicativoAdmissao indicativoAdmissao) {
        this.indicativoAdmissao = indicativoAdmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_JORNADA_TRABALHO", foreignKey=@ForeignKey(name="FK_COLABORADOR_REG_JOR_TRABALHO"))
    public EsocRegimeJornadaTrab getRegimeJornadaTrabalho() {
        return this.regimeJornadaTrabalho;
    }

    public void setRegimeJornadaTrabalho(EsocRegimeJornadaTrab regimeJornadaTrabalho) {
        this.regimeJornadaTrabalho = regimeJornadaTrabalho;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_CONTRATACAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_MOT_CONTRATACAO"))
    public EsocMotivoContratacao getMotivoContratacao() {
        return this.motivoContratacao;
    }

    public void setMotivoContratacao(EsocMotivoContratacao motivoContratacao) {
        this.motivoContratacao = motivoContratacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_EMPREGO_ANTERIOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_PES_EMP_ANT"))
    public Pessoa getPessoaEmpregoAnterior() {
        return this.pessoaEmpregoAnterior;
    }

    public void setPessoaEmpregoAnterior(Pessoa pessoaEmpregoAnterior) {
        this.pessoaEmpregoAnterior = pessoaEmpregoAnterior;
    }

    @Column(name="NUMERO_REGISTRO_ANTERIOR", length=10)
    public String getNumeroRegistroAnterior() {
        return this.numeroRegistroAnterior;
    }

    public void setNumeroRegistroAnterior(String numeroRegistroAnterior) {
        this.numeroRegistroAnterior = numeroRegistroAnterior;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ADMISSAO_ANTERIOR")
    public Date getDataAdmissaoAnterior() {
        return this.dataAdmissaoAnterior;
    }

    public void setDataAdmissaoAnterior(Date dataAdmissaoAnterior) {
        this.dataAdmissaoAnterior = dataAdmissaoAnterior;
    }

    @Column(name="OBSERVACAO_EMPREG_ANTERIOR", length=100)
    public String getObservacaoEmpregAnterior() {
        return this.observacaoEmpregAnterior;
    }

    public void setObservacaoEmpregAnterior(String observacaoEmpregAnterior) {
        this.observacaoEmpregAnterior = observacaoEmpregAnterior;
    }

    @JoinColumn(name="ID_ARQUIVAMENTO_DOC", foreignKey=@ForeignKey(name="FK_COLABORADOR_ARQ_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivamentoDoc() {
        return this.arquivamentoDoc;
    }

    public void setArquivamentoDoc(ArquivamentoDoc arquivamentoDoc) {
        this.arquivamentoDoc = arquivamentoDoc;
    }

    @Column(nullable=false, name="VALOR_TICKET", precision=15, scale=2)
    public Double getValorTicket() {
        return this.valorTicket;
    }

    public void setValorTicket(Double valorTicket) {
        this.valorTicket = valorTicket;
    }

    @Column(name="HORA_EXTRA_HABITUAL")
    public Short getHoraExtraHabitual() {
        return this.horaExtraHabitual;
    }

    public void setHoraExtraHabitual(Short horaExtraHabitual) {
        this.horaExtraHabitual = horaExtraHabitual;
    }

    @Column(name="ADD_NOTURNO_HABITUAL")
    public Short getAddNoturnoHabitual() {
        return this.addNoturnoHabitual;
    }

    public void setAddNoturnoHabitual(Short addNoturnoHabitual) {
        this.addNoturnoHabitual = addNoturnoHabitual;
    }

    @Column(name="UTILIZACAO_EPI")
    public Short getUtilizacaoEPI() {
        return this.utilizacaoEPI;
    }

    public void setUtilizacaoEPI(Short utilizacaoEPI) {
        this.utilizacaoEPI = utilizacaoEPI;
    }

    @Column(name="JORNADA_SEMANAL_TRABALHADA")
    public Integer getJornadaSemanalTrabalho() {
        return this.jornadaSemanalTrabalho;
    }

    public void setJornadaSemanalTrabalho(Integer jornadaSemanalTrabalho) {
        this.jornadaSemanalTrabalho = jornadaSemanalTrabalho;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO_ORGAO_CLASSE")
    public Date getDataValidadeOrgaoClasse() {
        return this.dataValidadeOrgaoClasse;
    }

    public void setDataValidadeOrgaoClasse(Date dataValidadeOrgaoClasse) {
        this.dataValidadeOrgaoClasse = dataValidadeOrgaoClasse;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ALTERACAO_PERIODO_AQUISITIVO")
    public Date getAlteracaoPeriodoAquisitivo() {
        return this.alteracaoPeriodoAquisitivo;
    }

    public void setAlteracaoPeriodoAquisitivo(Date alteracaoPeriodoAquisitivo) {
        this.alteracaoPeriodoAquisitivo = alteracaoPeriodoAquisitivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICADOR_VINCULO_TRABALHADO", foreignKey=@ForeignKey(name="FK_COLABORADOR_VINCULO"))
    public IndicadorVinculoTrabalhador getIndicadorVinculoTrabalhador() {
        return this.indicadorVinculoTrabalhador;
    }

    public void setIndicadorVinculoTrabalhador(IndicadorVinculoTrabalhador indicadorVinculoTrabalhador) {
        this.indicadorVinculoTrabalhador = indicadorVinculoTrabalhador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_TRABALHISTA", foreignKey=@ForeignKey(name="FK_COLABORADOR_REGIME_TRABALHIS"))
    public TipoRegimeTrabalhista getRegimeTrabalhista() {
        return this.regimeTrabalhista;
    }

    public void setRegimeTrabalhista(TipoRegimeTrabalhista regimeTrabalhista) {
        this.regimeTrabalhista = regimeTrabalhista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGIME_PREVIDENCIARIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_REG_PREVIDEN"))
    public TipoRegimePrevidenciario getRegimePrevidenciario() {
        return this.regimePrevidenciario;
    }

    public void setRegimePrevidenciario(TipoRegimePrevidenciario regimePrevidenciario) {
        this.regimePrevidenciario = regimePrevidenciario;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="COMPOE_INTEGRACAO_PTO")
    public Short getCompoeIntegracaoPonto() {
        return this.compoeIntegracaoPonto;
    }

    public void setCompoeIntegracaoPonto(Short compoeIntegracaoPonto) {
        this.compoeIntegracaoPonto = compoeIntegracaoPonto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_SANGUINEO", foreignKey=@ForeignKey(name="FK_GRUPO_SANGUINEO_COLABORADOR"))
    public GrupoSanguineo getGrupoSanguineo() {
        return this.grupoSanguineo;
    }

    public void setGrupoSanguineo(GrupoSanguineo grupoSanguineo) {
        this.grupoSanguineo = grupoSanguineo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_SIT_COLABOR"))
    public SituacaoColaborador getSituacaoColaborador() {
        return this.situacaoColaborador;
    }

    public void setSituacaoColaborador(SituacaoColaborador situacaoColaborador) {
        this.situacaoColaborador = situacaoColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_CLASSIF_COLABORA"))
    public ClassificacaoColaborador getClassificacaoColaborador() {
        return this.classificacaoColaborador;
    }

    public void setClassificacaoColaborador(ClassificacaoColaborador classificacaoColaborador) {
        this.classificacaoColaborador = classificacaoColaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_ENSINO", foreignKey=@ForeignKey(name="FK_COLABORADOR_INSTI_ENSINO"))
    public InstituicaoEnsino getInstituicaoEnsino() {
        return this.instituicaoEnsino;
    }

    public void setInstituicaoEnsino(InstituicaoEnsino instituicaoEnsino) {
        this.instituicaoEnsino = instituicaoEnsino;
    }

    @Column(name="HORAS_MES_COLABORADOR", precision=15, scale=4)
    public Double getHorasMesColaborador() {
        return this.horasMesColaborador;
    }

    public void setHorasMesColaborador(Double horasMesColaborador) {
        this.horasMesColaborador = horasMesColaborador;
    }

    @Column(name="TRABALHO_PARCIAL")
    public Short getTrabalhoParcial() {
        return this.trabalhoParcial;
    }

    public void setTrabalhoParcial(Short trabalhoParcial) {
        this.trabalhoParcial = trabalhoParcial;
    }

    @Column(name="TELETRABALHO")
    public Short getTeleTrabalho() {
        return this.teleTrabalho;
    }

    public void setTeleTrabalho(Short teleTrabalho) {
        this.teleTrabalho = teleTrabalho;
    }

    @Column(name="TRABALHO_INTERMITENTE")
    public Short getTrabalhoInterminente() {
        return this.trabalhoInterminente;
    }

    public void setTrabalhoInterminente(Short trabalhoInterminente) {
        this.trabalhoInterminente = trabalhoInterminente;
    }

    @Column(name="PERCENTUAL_PENSAO", precision=15, scale=4)
    public Double getPercentualPensao() {
        return this.percentualPensao;
    }

    public void setPercentualPensao(Double percentualPensao) {
        this.percentualPensao = percentualPensao;
    }

    @Column(name="NR_BENEFICARIOS_PENSAO")
    public Short getNrBeneficiarios() {
        return this.nrBeneficiarios;
    }

    public void setNrBeneficiarios(Short nrBeneficiarios) {
        this.nrBeneficiarios = nrBeneficiarios;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_PENSAO", foreignKey=@ForeignKey(name="FK_TIPO_PAG_PENSAO_COLABORADOR"))
    public TipoPagamentoPensao getTipoPagamentoPensao() {
        return this.tipoPagamentoPensao;
    }

    public void setTipoPagamentoPensao(TipoPagamentoPensao tipoPagamentoPensao) {
        this.tipoPagamentoPensao = tipoPagamentoPensao;
    }

    @Column(name="POSSUI_DESCONTO_PENSAO")
    public Short getPossuiDescontoPensao() {
        return this.possuiDescontoPensao;
    }

    public void setPossuiDescontoPensao(Short possuiDescontoPensao) {
        this.possuiDescontoPensao = possuiDescontoPensao;
    }

    @Column(name="VALOR_FIXO_PENSAO", precision=15, scale=2)
    public Double getValorFixoPensao() {
        return this.valorFixoPensao;
    }

    public void setValorFixoPensao(Double valorFixoPensao) {
        this.valorFixoPensao = valorFixoPensao;
    }

    @Column(name="PAG_ADD_NOT_CINCO_HORAS")
    public Short getPagAddNoturnoCincoHoras() {
        return this.pagAddNoturnoCincoHoras;
    }

    public void setPagAddNoturnoCincoHoras(Short pagAddNoturnoCincoHoras) {
        this.pagAddNoturnoCincoHoras = pagAddNoturnoCincoHoras;
    }

    @Column(name="HORAS_NOTURNAS", precision=15, scale=4)
    public Double getHorasNoturnas() {
        return this.horasNoturnas;
    }

    public void setHorasNoturnas(Double horasNoturnas) {
        this.horasNoturnas = horasNoturnas;
    }

    @Column(name="NAO_POSSUI_VALORES_VA")
    public Short getNaoPossuiValoresVA() {
        return this.naoPossuiValoresVA;
    }

    public void setNaoPossuiValoresVA(Short naoPossuiValoresVA) {
        this.naoPossuiValoresVA = naoPossuiValoresVA;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BANCO", foreignKey=@ForeignKey(name="FK_COLABORADOR_INSTI_VALOR"))
    public InstituicaoValores getBanco() {
        return this.banco;
    }

    public void setBanco(InstituicaoValores banco) {
        this.banco = banco;
    }

    @Column(name="AGENCIA", length=15)
    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Column(name="CONTA", length=15)
    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
    }

    @Column(name="OPERACAO", length=15)
    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    @Column(name="CASADO_COM_BRASILEIRO")
    public Short getCasadoComBrasileiro() {
        return this.casadoComBrasileiro;
    }

    public void setCasadoComBrasileiro(Short casadoComBrasileiro) {
        this.casadoComBrasileiro = casadoComBrasileiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_ATIVIDADE", foreignKey=@ForeignKey(name="FK_COLABORADOR_NATUREZA_ATV"))
    public EsocNaturezaAtividade getNaturezaAtividade() {
        return this.naturezaAtividade;
    }

    public void setNaturezaAtividade(EsocNaturezaAtividade naturezaAtividade) {
        this.naturezaAtividade = naturezaAtividade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CAT_TRABALHADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_ESOC_CAT_TRAB"))
    public EsocCategoriaTrabalhador getEsocCategoriaTrabalhador() {
        return this.esocCategoriaTrabalhador;
    }

    public void setEsocCategoriaTrabalhador(EsocCategoriaTrabalhador esocCategoriaTrabalhador) {
        this.esocCategoriaTrabalhador = esocCategoriaTrabalhador;
    }

    @Column(name="PRIMEIRO_EMPREGO")
    public Short getPrimeiroEmprego() {
        return this.primeiroEmprego;
    }

    public void setPrimeiroEmprego(Short primeiroEmprego) {
        this.primeiroEmprego = primeiroEmprego;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_RNE", foreignKey=@ForeignKey(name="FK_COLABORADOR_UF_RNE"))
    public UnidadeFederativa getUfRNE() {
        return this.ufRNE;
    }

    public void setUfRNE(UnidadeFederativa ufRNE) {
        this.ufRNE = ufRNE;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_ORGAO_CLASSE", foreignKey=@ForeignKey(name="FK_COLABORADOR_UF_OC"))
    public UnidadeFederativa getUfOrgaoClasse() {
        return this.ufOrgaoClasse;
    }

    public void setUfOrgaoClasse(UnidadeFederativa ufOrgaoClasse) {
        this.ufOrgaoClasse = ufOrgaoClasse;
    }

    @Column(name="COLABORADOR_INCAPAZ")
    public Short getColaboradorIncapaz() {
        return this.colaboradorIncapaz;
    }

    public void setColaboradorIncapaz(Short colaboradorIncapaz) {
        this.colaboradorIncapaz = colaboradorIncapaz;
    }

    @Column(name="EMAIL_PESSOAL", length=100)
    public String getEmailPessoal() {
        return this.emailPessoal;
    }

    public void setEmailPessoal(String emailPessoal) {
        this.emailPessoal = emailPessoal;
    }

    @Column(name="DESCRICAO_COLABORADOR_TEMP", length=1000)
    public String getDescricaoColaboradorTemp() {
        return this.descricaoColaboradorTemp;
    }

    public void setDescricaoColaboradorTemp(String descricaoColaboradorTemp) {
        this.descricaoColaboradorTemp = descricaoColaboradorTemp;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_INCLUSAO_CONT", foreignKey=@ForeignKey(name="FK_COLABORADOR_TIPO_INCLUSAO"))
    public EsocTipoInclusaoContrato getTipoInclusaoContrato() {
        return this.tipoInclusaoContrato;
    }

    public void setTipoInclusaoContrato(EsocTipoInclusaoContrato tipoInclusaoContrato) {
        this.tipoInclusaoContrato = tipoInclusaoContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_INSCRICAO_TOMADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_TIPO_INSC_TOM"))
    public EsocTipoInscricaoEmpregador getTipoInscricaoTomador() {
        return this.tipoInscricaoTomador;
    }

    public void setTipoInscricaoTomador(EsocTipoInscricaoEmpregador tipoInscricaoTomador) {
        this.tipoInscricaoTomador = tipoInscricaoTomador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_INSCRICAO_ESTABEL", foreignKey=@ForeignKey(name="FK_COLABORADOR_TIPO_INSC_ESTAB"))
    public EsocTipoInscricaoEmpregador getTipoInscricaoEstabelecimento() {
        return this.tipoInscricaoEstabelecimento;
    }

    public void setTipoInscricaoEstabelecimento(EsocTipoInscricaoEmpregador tipoInscricaoEstabelecimento) {
        this.tipoInscricaoEstabelecimento = tipoInscricaoEstabelecimento;
    }

    @Column(name="INSCRICAO_TOMADOR", length=50)
    public String getInscricaoTomador() {
        return this.inscricaoTomador;
    }

    public void setInscricaoTomador(String inscricaoTomador) {
        this.inscricaoTomador = inscricaoTomador;
    }

    @Column(name="INSCRICAO_ESTABELECIMENTO", length=50)
    public String getInscricaoEstabelecimento() {
        return this.inscricaoEstabelecimento;
    }

    public void setInscricaoEstabelecimento(String inscricaoEstabelecimento) {
        this.inscricaoEstabelecimento = inscricaoEstabelecimento;
    }

    @Column(name="CPF_COLABORADOR_SUBSTITUIDO", length=14)
    public String getCpfColaboradorSubstituido() {
        return this.cpfColaboradorSubstituido;
    }

    public void setCpfColaboradorSubstituido(String cpfColaboradorSubstituido) {
        this.cpfColaboradorSubstituido = cpfColaboradorSubstituido;
    }

    @Column(name="CLAUSULA_ASSECURATORIA")
    public Short getClausulaAssecuratoria() {
        return this.clausulaAssecuratoria;
    }

    public void setClausulaAssecuratoria(Short clausulaAssecuratoria) {
        this.clausulaAssecuratoria = clausulaAssecuratoria;
    }

    @Column(name="OBSERVACAO_CONTRATO_TRABALHO", length=1000)
    public String getObservacaoContratoTrabalho() {
        return this.observacaoContratoTrabalho;
    }

    public void setObservacaoContratoTrabalho(String observacaoContratoTrabalho) {
        this.observacaoContratoTrabalho = observacaoContratoTrabalho;
    }

    @Column(name="CNPJ_EMPREGADOR_ANTERIOR", length=14)
    public String getCnpjEmpregadorAnterior() {
        return this.cnpjEmpregadorAnterior;
    }

    public void setCnpjEmpregadorAnterior(String cnpjEmpregadorAnterior) {
        this.cnpjEmpregadorAnterior = cnpjEmpregadorAnterior;
    }

    @Column(name="MATRICULA_ANTERIOR", length=25)
    public String getMatriculaAnterior() {
        return this.matriculaAnterior;
    }

    public void setMatriculaAnterior(String matriculaAnterior) {
        this.matriculaAnterior = matriculaAnterior;
    }

    @Column(name="DATA_TRANSFERENCIA_EMPREGADO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataTransferenciaEmpregado() {
        return this.dataTransferenciaEmpregado;
    }

    public void setDataTransferenciaEmpregado(Date dataTransferenciaEmpregado) {
        this.dataTransferenciaEmpregado = dataTransferenciaEmpregado;
    }

    @Column(name="OBSERVACAO_SUCESSAO_VINCULO", length=1000)
    public String getObservacaoSucessaoVinculo() {
        return this.observacaoSucessaoVinculo;
    }

    public void setObservacaoSucessaoVinculo(String observacaoSucessaoVinculo) {
        this.observacaoSucessaoVinculo = observacaoSucessaoVinculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NIVEL_ESTAGIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_NIVEL_ESTAGIO"))
    public EsocNivelEstagio getNivelEstagio() {
        return this.nivelEstagio;
    }

    public void setNivelEstagio(EsocNivelEstagio nivelEstagio) {
        this.nivelEstagio = nivelEstagio;
    }

    @Column(name="AREA_ATUACAO_ESTAGIO", length=500)
    public String getAreaAtuacaoEstagio() {
        return this.areaAtuacaoEstagio;
    }

    public void setAreaAtuacaoEstagio(String areaAtuacaoEstagio) {
        this.areaAtuacaoEstagio = areaAtuacaoEstagio;
    }

    @Column(name="NR_APOLICE_SEGURO_ESTAGIO", length=50)
    public String getNrApoliceSeguroEstagio() {
        return this.nrApoliceSeguroEstagio;
    }

    public void setNrApoliceSeguroEstagio(String nrApoliceSeguroEstagio) {
        this.nrApoliceSeguroEstagio = nrApoliceSeguroEstagio;
    }

    @Column(name="VALOR_BOLSA_ESTAGIO", precision=15, scale=2)
    public Double getValorBolsaEstagio() {
        return this.valorBolsaEstagio;
    }

    public void setValorBolsaEstagio(Double valorBolsaEstagio) {
        this.valorBolsaEstagio = valorBolsaEstagio;
    }

    @Column(name="DATA_TERMINO_ESTAGIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataTerminoEstagio() {
        return this.dataTerminoEstagio;
    }

    public void setDataTerminoEstagio(Date dataTerminoEstagio) {
        this.dataTerminoEstagio = dataTerminoEstagio;
    }

    @Column(name="NATUREZA_ESTAGIO")
    public Short getNaturezaEstagio() {
        return this.naturezaEstagio;
    }

    public void setNaturezaEstagio(Short naturezaEstagio) {
        this.naturezaEstagio = naturezaEstagio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_ENSINO_ESTAGIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_NIVEL_ESTAG"))
    public InstituicaoEnsino getInstituicaoEnsinoEstagio() {
        return this.instituicaoEnsinoEstagio;
    }

    public void setInstituicaoEnsinoEstagio(InstituicaoEnsino instituicaoEnsinoEstagio) {
        this.instituicaoEnsinoEstagio = instituicaoEnsinoEstagio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AGENTE_ESTAGIO", foreignKey=@ForeignKey(name="FK_COLABORADOR_AGENTE"))
    public Pessoa getAgenteEstagio() {
        return this.agenteEstagio;
    }

    public void setAgenteEstagio(Pessoa agenteEstagio) {
        this.agenteEstagio = agenteEstagio;
    }

    @Column(name="NOME_SUPERVISOR_ESTAGIO", length=500)
    public String getNomeSupervisorEstagio() {
        return this.nomeSupervisorEstagio;
    }

    public void setNomeSupervisorEstagio(String nomeSupervisorEstagio) {
        this.nomeSupervisorEstagio = nomeSupervisorEstagio;
    }

    @Column(name="CPF_SUPERVISOR_ESTAGIO", length=14)
    public String getCpfSupervisorEstagio() {
        return this.cpfSupervisorEstagio;
    }

    public void setCpfSupervisorEstagio(String cpfSupervisorEstagio) {
        this.cpfSupervisorEstagio = cpfSupervisorEstagio;
    }

    @Column(name="NOME_SOCIAL_TRAVESTI", length=500)
    public String getNomeSocialTravesti() {
        return this.nomeSocialTravesti;
    }

    public void setNomeSocialTravesti(String nomeSocialTravesti) {
        this.nomeSocialTravesti = nomeSocialTravesti;
    }

    @Override
    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="DESCRICAO_SALARIO", length=200)
    public String getDescricaoSalario() {
        return this.descricaoSalario;
    }

    public void setDescricaoSalario(String descricaoSalario) {
        this.descricaoSalario = descricaoSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCAL_TRAB_TEMP", foreignKey=@ForeignKey(name="FK_LOCAL_TRAB_COLABORADOR_TEMP"))
    public Pessoa getLocalTrabTemporario() {
        return this.LocalTrabTemporario;
    }

    public void setLocalTrabTemporario(Pessoa LocalTrabTemporario) {
        this.LocalTrabTemporario = LocalTrabTemporario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_LOG_TEMPO", foreignKey=@ForeignKey(name="FK_TP_LOGRA_END_TEMP"))
    public TipoLogradouroEndereco getTipoLogradouroTemp() {
        return this.tipoLogradouroTemp;
    }

    public void setTipoLogradouroTemp(TipoLogradouroEndereco tipoLogradouroTemp) {
        this.tipoLogradouroTemp = tipoLogradouroTemp;
    }

    @OneToMany(mappedBy="colaborador")
    public List<HistoricoHorarioColaborador> getHistoricoHorario() {
        return this.historicoHorario;
    }

    public void setHistoricoHorario(List<HistoricoHorarioColaborador> historicoHorario) {
        this.historicoHorario = historicoHorario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESTABELECIMENTO", foreignKey=@ForeignKey(name="FK_COLABORADOR_ESTABELECIMENTO"))
    public EsocCadastroEstabelcimento getEstabelecimento() {
        return this.estabelecimento;
    }

    public void setEstabelecimento(EsocCadastroEstabelcimento estabelecimento) {
        this.estabelecimento = estabelecimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTACAO_TRIBURARIA", foreignKey=@ForeignKey(name="FK_COLABORADOR_LOT_TRIBUTARIA"))
    public EsocCadastroLotacaoTributaria getLotacaoTributaria() {
        return this.lotacaoTributaria;
    }

    public void setLotacaoTributaria(EsocCadastroLotacaoTributaria lotacaoTributaria) {
        this.lotacaoTributaria = lotacaoTributaria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_GRAU_EXPOSICAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_GRAU_EXPOSICAO"))
    public EsocGrauExpAgentNocivos getGrauExposicao() {
        return this.grauExposicao;
    }

    public void setGrauExposicao(EsocGrauExpAgentNocivos grauExposicao) {
        this.grauExposicao = grauExposicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REGISTRO_ADMISSAO", foreignKey=@ForeignKey(name="FK_COLABORADOR_REGISTRO_ADMISSA"))
    public RegistroAdmissaoPreLiminar getRegistroAdmissao() {
        return this.registroAdmissao;
    }

    public void setRegistroAdmissao(RegistroAdmissaoPreLiminar registroAdmissao) {
        this.registroAdmissao = registroAdmissao;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<CadastroMultiplosVinculos> getMultiplosVinculos() {
        return this.multiplosVinculos;
    }

    public void setMultiplosVinculos(List<CadastroMultiplosVinculos> multiplosVinculos) {
        this.multiplosVinculos = multiplosVinculos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_IND_INSS_MV", foreignKey=@ForeignKey(name="FK_ESOC_IND_INSS_MV_COLABORADOR"))
    public EsocIndInssMultVinculos getEsocIndicativoInss() {
        return this.esocIndicativoInss;
    }

    public void setEsocIndicativoInss(EsocIndInssMultVinculos esocIndicativoInss) {
        this.esocIndicativoInss = esocIndicativoInss;
    }

    @Column(name="NUMERO_REGISTRO_ESOCIAL", length=100)
    public String getNumeroRegistroESocial() {
        return this.numeroRegistroESocial;
    }

    public void setNumeroRegistroESocial(String numeroRegistroESocial) {
        this.numeroRegistroESocial = numeroRegistroESocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_FOLHA", foreignKey=@ForeignKey(name="FK_COLABORADOR_TP_FOL_SALAR"))
    public TipoPagamentoFolha getTipoPagamentoFolha() {
        return this.tipoPagamentoFolha;
    }

    public void setTipoPagamentoFolha(TipoPagamentoFolha tipoPagamentoFolha) {
        this.tipoPagamentoFolha = tipoPagamentoFolha;
    }

    @Column(name="VALOR_SALARIO", precision=15, scale=2)
    public Double getValorSalario() {
        return this.valorSalario;
    }

    public void setValorSalario(Double valorSalario) {
        this.valorSalario = valorSalario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCAL_TRABALHO_COLAB_CID", foreignKey=@ForeignKey(name="FK_COLABORADOR_LOCAL_TRAB_CID"))
    public LocalTrabalhoColaboradorCidade getLocalTrabalhoColaboradorCidade() {
        return this.localTrabalhoColaboradorCidade;
    }

    public void setLocalTrabalhoColaboradorCidade(LocalTrabalhoColaboradorCidade localTrabalhoColaboradorCidade) {
        this.localTrabalhoColaboradorCidade = localTrabalhoColaboradorCidade;
    }

    @Column(name="INFORMAR_RECIBO_MANUAL")
    public Short getInformarReciboManual() {
        return this.informarReciboManual;
    }

    public void setInformarReciboManual(Short informarReciboManual) {
        this.informarReciboManual = informarReciboManual;
    }

    @Column(name="NUMERO_RECIBO_ESOCIAL", length=100)
    public String getNumeroReciboEsocial() {
        return this.numeroReciboEsocial;
    }

    public void setNumeroReciboEsocial(String numeroReciboEsocial) {
        this.numeroReciboEsocial = numeroReciboEsocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEPARTAMENTO", foreignKey=@ForeignKey(name="FK_DEPARTAMENTO_COLABORADOR"))
    public DepartamentoColaborador getDepartamento() {
        return this.departamento;
    }

    public void setDepartamento(DepartamentoColaborador departamento) {
        this.departamento = departamento;
    }

    @Column(name="PREENCHER_CARTEIRA_CPF")
    public Short getPreencherCarteiraCpf() {
        return this.preencherCarteiraCpf;
    }

    public void setPreencherCarteiraCpf(Short preencherCarteiraCpf) {
        this.preencherCarteiraCpf = preencherCarteiraCpf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_SAUDE", foreignKey=@ForeignKey(name="FK_COLABORADOR_PLANO_SAUDE"))
    public CadastroPlanoSaude getPlanoSaude() {
        return this.planoSaude;
    }

    public void setPlanoSaude(CadastroPlanoSaude planoSaude) {
        this.planoSaude = planoSaude;
    }

    @Column(name="NUMERO_CARTEIRA", length=200)
    public String getNumeroCarteiraPlanoSaude() {
        return this.numeroCarteiraPlanoSaude;
    }

    public void setNumeroCarteiraPlanoSaude(String numeroCarteiraPlanoSaude) {
        this.numeroCarteiraPlanoSaude = numeroCarteiraPlanoSaude;
    }

    @Column(name="PAGAMENTO_FEITO_PELO_BANCO")
    public Short getPagamentoFeitoPeloBanco() {
        return this.pagamentoFeitoPeloBanco;
    }

    public void setPagamentoFeitoPeloBanco(Short pagamentoFeitoPeloBanco) {
        this.pagamentoFeitoPeloBanco = pagamentoFeitoPeloBanco;
    }

    @Column(name="TIPO_ADESAO")
    public Short getTipoAdesao() {
        return this.tipoAdesao;
    }

    public void setTipoAdesao(Short tipoAdesao) {
        this.tipoAdesao = tipoAdesao;
    }

    @Column(name="DATA_ACORDO_BENEFICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAcordoBeneficio() {
        return this.dataAcordoBeneficio;
    }

    public void setDataAcordoBeneficio(Date dataAcordoBeneficio) {
        this.dataAcordoBeneficio = dataAcordoBeneficio;
    }

    @Column(name="DATA_INICIO_BENEFICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioBeneficio() {
        return this.dataInicioBeneficio;
    }

    public void setDataInicioBeneficio(Date dataInicioBeneficio) {
        this.dataInicioBeneficio = dataInicioBeneficio;
    }

    @Column(name="DATA_FINAL_BENEFICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinalBeneficio() {
        return this.dataFinalBeneficio;
    }

    public void setDataFinalBeneficio(Date dataFinalBeneficio) {
        this.dataFinalBeneficio = dataFinalBeneficio;
    }

    @Column(name="DIAS_ADESAO")
    public Long getDiasAdesao() {
        return this.diasAdesao;
    }

    public void setDiasAdesao(Long diasAdesao) {
        this.diasAdesao = diasAdesao;
    }

    @Column(name="PERC_REDUCAO", precision=15, scale=2)
    public Double getPercReducao() {
        return this.percReducao;
    }

    public void setPercReducao(Double percReducao) {
        this.percReducao = percReducao;
    }

    @Column(name="ADERIDO_BENEFICIO_EMERGENCIAL")
    public Short getAderidoBeneficioEmergencial() {
        return this.aderidoBeneficioEmergencial;
    }

    public void setAderidoBeneficioEmergencial(Short aderidoBeneficioEmergencial) {
        this.aderidoBeneficioEmergencial = aderidoBeneficioEmergencial;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<HistoricoLotacaoTributaria> getHistoricoLotacaoTributaria() {
        return this.historicoLotacaoTributaria;
    }

    public void setHistoricoLotacaoTributaria(List<HistoricoLotacaoTributaria> historicoLotacaoTributaria) {
        this.historicoLotacaoTributaria = historicoLotacaoTributaria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_horario_admissao")
    public InfoHorarioTrabalho getHorarioAdmissao() {
        return this.horarioAdmissao;
    }

    public void setHorarioAdmissao(InfoHorarioTrabalho horarioAdmissao) {
        this.horarioAdmissao = horarioAdmissao;
    }

    @Column(name="perc_desconto_compras", precision=15, scale=2)
    public Double getPercDescontoCompras() {
        return this.percDescontoCompras;
    }

    public void setPercDescontoCompras(Double percDescontoCompras) {
        this.percDescontoCompras = percDescontoCompras;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<HoraExtraHorTrab> getHorasExtras() {
        return this.horasExtras;
    }

    public void setHorasExtras(List<HoraExtraHorTrab> horasExtras) {
        this.horasExtras = horasExtras;
    }

    @Column(name="data_inicio_indice")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioIndice() {
        return this.dataInicioIndice;
    }

    public void setDataInicioIndice(Date dataInicioIndice) {
        this.dataInicioIndice = dataInicioIndice;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_GESTOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_PESSOA_GESTOR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Pessoa getPessoaGestor() {
        return this.pessoaGestor;
    }

    public void setPessoaGestor(Pessoa pessoaGestor) {
        this.pessoaGestor = pessoaGestor;
    }

    @OneToMany(mappedBy="colaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocTreinamentoColaborador> getTreinamentos() {
        return this.treinamentos;
    }

    public void setTreinamentos(List<EsocTreinamentoColaborador> treinamentos) {
        this.treinamentos = treinamentos;
    }

    @OneToMany(mappedBy="colaborador", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ColaboradorDependente> getDependentesColaborador() {
        return this.dependentesColaborador;
    }

    public void setDependentesColaborador(List<ColaboradorDependente> dependentesColaborador) {
        this.dependentesColaborador = dependentesColaborador;
    }
}

