/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="COLABORADOR_DADOS_FERIAS")
public class ColaboradorDadosFerias
implements InterfaceVO {
    private Long identificador;
    private Date dataInicioPeriodo;
    private Date dataFimPeriodo;
    private Colaborador colaborador;
    private Date inicioGozoFerias;
    private Date fimGozoFerias;
    private Double valorFerias = 0.0;
    private Double numeroFaltas = 0.0;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Long recidoFerias = 0L;
    private Short fechado = 1;
    private Date dataPagamento;

    @Id
    @Column(name="ID_COLABORADOR_DADOS_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COLABORADOR_DADOS_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_DADOS_FERIAS_COL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="DATA_INICIO_GOZO_FERIAS")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioGozoFerias() {
        return this.inicioGozoFerias;
    }

    public void setInicioGozoFerias(Date inicioGozoFerias) {
        this.inicioGozoFerias = inicioGozoFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FIM_GOZO_FERIAS")
    public Date getFimGozoFerias() {
        return this.fimGozoFerias;
    }

    public void setFimGozoFerias(Date fimGozoFerias) {
        this.fimGozoFerias = fimGozoFerias;
    }

    @Column(nullable=false, name="VALORES_FERIAS", precision=15, scale=4)
    public Double getValorFerias() {
        return this.valorFerias;
    }

    public void setValorFerias(Double valorFerias) {
        this.valorFerias = valorFerias;
    }

    @Column(nullable=false, name="NUMERO_FALTAS", precision=15, scale=4)
    public Double getNumeroFaltas() {
        return this.numeroFaltas;
    }

    public void setNumeroFaltas(Double numeroFerias) {
        this.numeroFaltas = numeroFerias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO_PERIODO")
    public Date getDataInicioPeriodo() {
        return this.dataInicioPeriodo;
    }

    public void setDataInicioPeriodo(Date dataInicioPeriodo) {
        this.dataInicioPeriodo = dataInicioPeriodo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FIM_PERIODO")
    public Date getDataFimPeriodo() {
        return this.dataFimPeriodo;
    }

    public void setDataFimPeriodo(Date dataFimPeriodo) {
        this.dataFimPeriodo = dataFimPeriodo;
    }

    @Column(name="NUMERO_RECIBO_FERIAS")
    public Long getRecidoFerias() {
        return this.recidoFerias;
    }

    public void setRecidoFerias(Long recidoFerias) {
        this.recidoFerias = recidoFerias;
    }

    @Column(name="FECHADO")
    public Short getFechado() {
        return this.fechado;
    }

    public void setFechado(Short fechado) {
        this.fechado = fechado;
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.getIdentificador(), this.getDataInicioPeriodo(), this.getDataFimPeriodo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

