/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EsocAgenteCausadorCAT;
import com.touchcomp.basementor.model.vo.EsocAgenteCausadorSitGeradoraCAT;
import com.touchcomp.basementor.model.vo.EsocLocalAcidente;
import com.touchcomp.basementor.model.vo.EsocParteAtingidaCAT;
import com.touchcomp.basementor.model.vo.EsocSituacaoGeradoraAcidente;
import com.touchcomp.basementor.model.vo.EsocTipoAcidenteTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="COMUNICACAO_ACIDENTE_TRABALHO")
public class ComunicaoAcidenteTrabalho
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Colaborador colaborador;
    private Timestamp dataAtualizacao;
    private Timestamp dataHoraAcidente;
    private EsocTipoAcidenteTrabalho tipoAcidente;
    private Double hsTrabAntesAcidente = 0.0;
    private Short tipoCat = 0;
    private Short obito = 0;
    private Short comunicaoAutoridadePolicial = 0;
    private EsocSituacaoGeradoraAcidente situacaoGeradora;
    private Short iniciativaEmissaoCAT = 0;
    private String observacao;
    private EsocLocalAcidente localAcidente;
    private String especificacaoEndereco;
    private Endereco enderecoAcidente;
    private EsocParteAtingidaCAT parteAtingida;
    private Short ladoAtingido = 0;
    private EsocAgenteCausadorCAT agenteCausador;
    private EsocAgenteCausadorSitGeradoraCAT agenteCausadorSitGeradora;

    @Id
    @Column(nullable=false, unique=true, name="ID_COMUNICACAO_ACIDENTE_TRAB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_COMUNICACAO_ACIDENTE_TRABAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_TRABAL"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_HORA_ACIDENTE")
    public Timestamp getDataHoraAcidente() {
        return this.dataHoraAcidente;
    }

    public void setDataHoraAcidente(Timestamp dataHoraAcidente) {
        this.dataHoraAcidente = dataHoraAcidente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ACIDENTE_TRABALHO", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_TRA"))
    public EsocTipoAcidenteTrabalho getTipoAcidente() {
        return this.tipoAcidente;
    }

    public void setTipoAcidente(EsocTipoAcidenteTrabalho tipoAcidente) {
        this.tipoAcidente = tipoAcidente;
    }

    @Column(nullable=false, name="HORAS_TRAB_ANT_ACIDENTE", precision=15, scale=2)
    public Double getHsTrabAntesAcidente() {
        return this.hsTrabAntesAcidente;
    }

    public void setHsTrabAntesAcidente(Double hsTrabAntesAcidente) {
        this.hsTrabAntesAcidente = hsTrabAntesAcidente;
    }

    @Column(name="TIPO_CAT")
    public Short getTipoCat() {
        return this.tipoCat;
    }

    public void setTipoCat(Short tipoCat) {
        this.tipoCat = tipoCat;
    }

    @Column(name="OBITO")
    public Short getObito() {
        return this.obito;
    }

    public void setObito(Short obito) {
        this.obito = obito;
    }

    @Column(name="COMUNICAO_AUTORIDADE_POLICIAL")
    public Short getComunicaoAutoridadePolicial() {
        return this.comunicaoAutoridadePolicial;
    }

    public void setComunicaoAutoridadePolicial(Short comunicaoAutoridadePolicial) {
        this.comunicaoAutoridadePolicial = comunicaoAutoridadePolicial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_GERADOR_ACIDENTE", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_TRAB"))
    public EsocSituacaoGeradoraAcidente getSituacaoGeradora() {
        return this.situacaoGeradora;
    }

    public void setSituacaoGeradora(EsocSituacaoGeradoraAcidente situacaoGeradora) {
        this.situacaoGeradora = situacaoGeradora;
    }

    @Column(name="INICIATICA_EMISSAO_CAT")
    public Short getIniciativaEmissaoCAT() {
        return this.iniciativaEmissaoCAT;
    }

    public void setIniciativaEmissaoCAT(Short iniciativaEmissaoCAT) {
        this.iniciativaEmissaoCAT = iniciativaEmissaoCAT;
    }

    @Column(name="OBSERVACAO", length=400)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCAL_ACIDENTE", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_T"))
    public EsocLocalAcidente getLocalAcidente() {
        return this.localAcidente;
    }

    public void setLocalAcidente(EsocLocalAcidente localAcidente) {
        this.localAcidente = localAcidente;
    }

    @Column(name="ESPECIFICACAO_ENDERECO", length=400)
    public String getEspecificacaoEndereco() {
        return this.especificacaoEndereco;
    }

    public void setEspecificacaoEndereco(String especificacaoEndereco) {
        this.especificacaoEndereco = especificacaoEndereco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENDERECO_ACIDENTE", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_TR"))
    public Endereco getEnderecoAcidente() {
        return this.enderecoAcidente;
    }

    public void setEnderecoAcidente(Endereco enderecoAcidente) {
        this.enderecoAcidente = enderecoAcidente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARTE_ATINGIDA_CAT", foreignKey=@ForeignKey(name="FK_COMUNICACAO"))
    public EsocParteAtingidaCAT getParteAtingida() {
        return this.parteAtingida;
    }

    public void setParteAtingida(EsocParteAtingidaCAT parteAtingida) {
        this.parteAtingida = parteAtingida;
    }

    @Column(name="LADO_ATINGIDO")
    public Short getLadoAtingido() {
        return this.ladoAtingido;
    }

    public void setLadoAtingido(Short ladoAtingido) {
        this.ladoAtingido = ladoAtingido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AGENTE_CAUSADOR", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDENTE_AG_CAUS"))
    public EsocAgenteCausadorCAT getAgenteCausador() {
        return this.agenteCausador;
    }

    public void setAgenteCausador(EsocAgenteCausadorCAT agenteCausador) {
        this.agenteCausador = agenteCausador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AGENTE_CAUSADOR_SIT_GERADORA", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACIDEN"))
    public EsocAgenteCausadorSitGeradoraCAT getAgenteCausadorSitGeradora() {
        return this.agenteCausadorSitGeradora;
    }

    public void setAgenteCausadorSitGeradora(EsocAgenteCausadorSitGeradoraCAT agenteCausadorSitGeradora) {
        this.agenteCausadorSitGeradora = agenteCausadorSitGeradora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_COMUNICACAO_ACID"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColaborador() != null ? this.getColaborador().getPessoa().getNome() : this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

