/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.DiaSemana;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoCondicoesPagamentoRelCond;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CONDICOES_PAGAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_CONDICOES_PAGAMENTO_NOME", columnNames={"NOME"}), @UniqueConstraint(name="UNQ1_CONDICOES_PAG_COD_SINC", columnNames={"CODIGO_SINCRONIZACAO"})})
public class CondicoesPagamento
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Integer numeroParcelas = 0;
    private Integer entrada = 0;
    private Integer numeroDiasVencimento = 0;
    private Empresa empresa;
    private Date dataCadastro;
    private Double majoracaoPreco = 0.0;
    private Double minoracaoComissao = 0.0;
    private Short tipoCondEntrada;
    private Short tipoCondSaida;
    private Short condMutante;
    private Short nrMaximoDiasMedios;
    private Short tpCondicao;
    private Timestamp dataAtualizacao;
    private Double valorMinimoVenda = 0.0;
    private Double percentualMaximoDesconto = 0.0;
    private Short mutanteFixa;
    private String parcelasMutante;
    private CarteiraCobranca cartCobrancaDestino;
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();
    private Short excluirDiasNaoUteis = EnumConstantsMentorSimNao.NAO.getValue();
    private Double valorMinimoParcela = 0.0;
    private Short disponivelMobile = EnumConstantsMentorSimNao.NAO.getValue();
    private MeioPagamento meioPagamento;
    private List<GrupoCondicoesPagamentoRelCond> grupoCondicoesPagamento;
    private Short forcarData;
    private DiaSemana diaSemana;
    private Short delayDias;
    private Double taxaCartao = 0.0;
    private Short dataFixa;
    private Integer diaFixo = 0;
    private Integer diaVariavel = 0;
    private Short deducaoTaxa;
    private Short tipoCredito;
    private Integer diasDeslocamento = 0;
    private Short tipoDebito;
    private Short naoUtilizaTEF;
    private Short exibirBandeiraCartao;
    private Short utilizaTEFPix;
    private ContaValores contaValorPix;
    private Pessoa beneficiarioPagamento;
    private String codigoSincronizacao;

    public CondicoesPagamento() {
        this.tipoCondEntrada = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCondSaida = EnumConstantsMentorSimNao.NAO.getValue();
        this.condMutante = EnumConstantsMentorSimNao.NAO.getValue();
        this.nrMaximoDiasMedios = EnumConstantsMentorSimNao.NAO.getValue();
        this.tpCondicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.mutanteFixa = EnumConstantsMentorSimNao.NAO.getValue();
        this.grupoCondicoesPagamento = new ArrayList<GrupoCondicoesPagamentoRelCond>();
        this.forcarData = EnumConstantsMentorSimNao.NAO.getValue();
        this.delayDias = Short.valueOf("0");
        this.dataFixa = EnumConstantsMentorSimNao.NAO.getValue();
        this.deducaoTaxa = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCredito = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoDebito = EnumConstantsMentorSimNao.NAO.getValue();
        this.naoUtilizaTEF = EnumConstantsMentorSimNao.NAO.getValue();
        this.exibirBandeiraCartao = EnumConstantsMentorSimNao.NAO.getValue();
        this.utilizaTEFPix = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_CONDICOES_PAGAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONDICOES_PAGAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @Column(nullable=false, name="NUMERO_PARCELAS")
    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    @Column(nullable=false, name="ENTRADA")
    public Integer getEntrada() {
        return this.entrada;
    }

    @Column(nullable=false, name="NUMERO_DIAS_VENCIMENTO")
    public Integer getNumeroDiasVencimento() {
        return this.numeroDiasVencimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONDICOES_PAGAMENTO_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long idCondPg) {
        this.identificador = idCondPg;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setNumeroParcelas(Integer numParc) {
        this.numeroParcelas = numParc;
    }

    public void setEntrada(Integer entrada) {
        this.entrada = entrada;
    }

    public void setNumeroDiasVencimento(Integer numDiasVenc) {
        this.numeroDiasVencimento = numDiasVenc;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="MAJORACAO_PRECO", precision=15, scale=4)
    public Double getMajoracaoPreco() {
        return this.majoracaoPreco;
    }

    public void setMajoracaoPreco(Double majoracaoPreco) {
        this.majoracaoPreco = majoracaoPreco;
    }

    @Column(name="MINORACAO_COMISSAO", precision=15, scale=2)
    public Double getMinoracaoComissao() {
        return this.minoracaoComissao;
    }

    public void setMinoracaoComissao(Double minoracaoComissao) {
        this.minoracaoComissao = minoracaoComissao;
    }

    @Column(name="TIPO_COND_ENTRADA")
    public Short getTipoCondEntrada() {
        return this.tipoCondEntrada;
    }

    public void setTipoCondEntrada(Short tipoCondEntrada) {
        this.tipoCondEntrada = tipoCondEntrada;
    }

    @Column(name="TIPO_COND_SAIDA")
    public Short getTipoCondSaida() {
        return this.tipoCondSaida;
    }

    public void setTipoCondSaida(Short tipoCondSaida) {
        this.tipoCondSaida = tipoCondSaida;
    }

    @Column(name="COND_MUTANTE")
    public Short getCondMutante() {
        return this.condMutante;
    }

    public void setCondMutante(Short condMutante) {
        this.condMutante = condMutante;
    }

    @Column(name="NR_MAXIMO_DIAS_MEDIOS")
    public Short getNrMaximoDiasMedios() {
        return this.nrMaximoDiasMedios;
    }

    public void setNrMaximoDiasMedios(Short nrMaximoDiasMedios) {
        this.nrMaximoDiasMedios = nrMaximoDiasMedios;
    }

    @Transient
    public boolean isAvista() {
        return this.getNumeroParcelas() == 1 && this.getEntrada() == 1;
    }

    @Column(name="TP_CONDICAO")
    public Short getTpCondicao() {
        return this.tpCondicao;
    }

    public void setTpCondicao(Short tpCondicao) {
        this.tpCondicao = tpCondicao;
    }

    @Column(name="VALOR_MIN_VENDA", precision=15, scale=2)
    public Double getValorMinimoVenda() {
        return this.valorMinimoVenda;
    }

    public void setValorMinimoVenda(Double valorMinimoVenda) {
        this.valorMinimoVenda = valorMinimoVenda;
    }

    @Column(name="PERCENTUAL_MAXIMO_DESCONTO", precision=15, scale=4)
    public Double getPercentualMaximoDesconto() {
        return this.percentualMaximoDesconto;
    }

    public void setPercentualMaximoDesconto(Double percentualMaximoDesconto) {
        this.percentualMaximoDesconto = percentualMaximoDesconto;
    }

    @Column(name="MUTANTE_FIXA")
    public Short getMutanteFixa() {
        return this.mutanteFixa;
    }

    public void setMutanteFixa(Short mutanteFixa) {
        this.mutanteFixa = mutanteFixa;
    }

    @Column(name="PARCELAS_MUTANTE", length=100)
    public String getParcelasMutante() {
        return this.parcelasMutante;
    }

    public void setParcelasMutante(String parcelasMutante) {
        this.parcelasMutante = parcelasMutante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CART_COBRANCA_DESTINO", foreignKey=@ForeignKey(name="FK_CONDICOES_PAG_CART_DESTINO"))
    public CarteiraCobranca getCartCobrancaDestino() {
        return this.cartCobrancaDestino;
    }

    public void setCartCobrancaDestino(CarteiraCobranca cartCobrancaDestino) {
        this.cartCobrancaDestino = cartCobrancaDestino;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="EXCLUIR_DIAS_NAO_UTEIS")
    public Short getExcluirDiasNaoUteis() {
        return this.excluirDiasNaoUteis;
    }

    public void setExcluirDiasNaoUteis(Short excluirDiasNaoUteis) {
        this.excluirDiasNaoUteis = excluirDiasNaoUteis;
    }

    @Column(nullable=false, name="VALOR_MINIMO_PARCELA", precision=15, scale=2)
    public Double getValorMinimoParcela() {
        return this.valorMinimoParcela;
    }

    public void setValorMinimoParcela(Double valorMinimoParcela) {
        this.valorMinimoParcela = valorMinimoParcela;
    }

    @Column(name="DISPONIVEL_MOBILE")
    public Short getDisponivelMobile() {
        return this.disponivelMobile;
    }

    public void setDisponivelMobile(Short disponivelMobile) {
        this.disponivelMobile = disponivelMobile;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_COND_PAG_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @OneToMany(mappedBy="condicoesPagamento")
    public List<GrupoCondicoesPagamentoRelCond> getGrupoCondicoesPagamento() {
        return this.grupoCondicoesPagamento;
    }

    public void setGrupoCondicoesPagamento(List<GrupoCondicoesPagamentoRelCond> grupoCondicoesPagamento) {
        this.grupoCondicoesPagamento = grupoCondicoesPagamento;
    }

    @Column(name="FORCAR_DATA")
    public Short getForcarData() {
        return this.forcarData;
    }

    public void setForcarData(Short forcarData) {
        this.forcarData = forcarData;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DIA_SEMANA", foreignKey=@ForeignKey(name="FK_COND_PAG_DIA_SEMANA"))
    public DiaSemana getDiaSemana() {
        return this.diaSemana;
    }

    public void setDiaSemana(DiaSemana diaSemana) {
        this.diaSemana = diaSemana;
    }

    @Column(name="DELAY_DIAS")
    public Short getDelayDias() {
        return this.delayDias;
    }

    public void setDelayDias(Short delayDias) {
        this.delayDias = delayDias;
    }

    @Column(nullable=false, name="TAXA_CARTAO", precision=15, scale=2)
    public Double getTaxaCartao() {
        return this.taxaCartao;
    }

    public void setTaxaCartao(Double taxaCartao) {
        this.taxaCartao = taxaCartao;
    }

    @Column(name="DATA_FIXA")
    public Short getDataFixa() {
        return this.dataFixa;
    }

    public void setDataFixa(Short dataFixa) {
        this.dataFixa = dataFixa;
    }

    @Column(name="DIA_FIXO")
    public Integer getDiaFixo() {
        return this.diaFixo;
    }

    public void setDiaFixo(Integer diaFixo) {
        this.diaFixo = diaFixo;
    }

    @Column(name="DIA_VARIAVEL")
    public Integer getDiaVariavel() {
        return this.diaVariavel;
    }

    public void setDiaVariavel(Integer diaVariavel) {
        this.diaVariavel = diaVariavel;
    }

    @Column(name="DEDUCAO_TAXA")
    public Short getDeducaoTaxa() {
        return this.deducaoTaxa;
    }

    public void setDeducaoTaxa(Short deducaoTaxa) {
        this.deducaoTaxa = deducaoTaxa;
    }

    @Column(name="TIPO_CREDITO")
    public Short getTipoCredito() {
        return this.tipoCredito;
    }

    public void setTipoCredito(Short tipoCredito) {
        this.tipoCredito = tipoCredito;
    }

    @Column(name="DIAS_DESLOCAMENTO")
    public Integer getDiasDeslocamento() {
        return this.diasDeslocamento;
    }

    public void setDiasDeslocamento(Integer diasDeslocamento) {
        this.diasDeslocamento = diasDeslocamento;
    }

    @Column(name="TIPO_DEBITO")
    public Short getTipoDebito() {
        return this.tipoDebito;
    }

    public void setTipoDebito(Short tipoDebito) {
        this.tipoDebito = tipoDebito;
    }

    @Column(name="NAO_UTILIZA_TEF")
    public Short getNaoUtilizaTEF() {
        return this.naoUtilizaTEF;
    }

    public void setNaoUtilizaTEF(Short naoUtilizaTEF) {
        this.naoUtilizaTEF = naoUtilizaTEF;
    }

    @Column(name="EXIBIR_BANDEIRA_CARTAO")
    public Short getExibirBandeiraCartao() {
        return this.exibirBandeiraCartao;
    }

    public void setExibirBandeiraCartao(Short exibirBandeiraCartao) {
        this.exibirBandeiraCartao = exibirBandeiraCartao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR_PIX", foreignKey=@ForeignKey(name="FK_COND_PAG_C_V_PIX"))
    public ContaValores getContaValorPix() {
        return this.contaValorPix;
    }

    public void setContaValorPix(ContaValores contaValorPix) {
        this.contaValorPix = contaValorPix;
    }

    @Column(name="UTILIZA_TEF_PIX")
    public Short getUtilizaTEFPix() {
        return this.utilizaTEFPix;
    }

    public void setUtilizaTEFPix(Short utilizaTEFPix) {
        this.utilizaTEFPix = utilizaTEFPix;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_CONDICOES_PAGAMENTO_PESSOA"))
    public Pessoa getBeneficiarioPagamento() {
        return this.beneficiarioPagamento;
    }

    public void setBeneficiarioPagamento(Pessoa beneficiarioPagamento) {
        this.beneficiarioPagamento = beneficiarioPagamento;
    }

    @Column(name="CODIGO_SINCRONIZACAO", length=100)
    public String getCodigoSincronizacao() {
        return this.codigoSincronizacao;
    }

    public void setCodigoSincronizacao(String codigoSincronizacao) {
        this.codigoSincronizacao = codigoSincronizacao;
    }
}

