/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CartaoValePedagio;
import com.touchcomp.basementor.model.vo.ComponenteFrete;
import com.touchcomp.basementor.model.vo.ConjTransportadorEventos;
import com.touchcomp.basementor.model.vo.ConjuntoTranspVeiculo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.TipoConjuntoTransportador;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="CONJUNTO_TRANSPORTADOR")
public class ConjuntoTransportador
implements InterfaceVO {
    private Long identificador;
    private TransportadorAgregado transportadorAgregado;
    private Motorista motorista;
    private Timestamp dataInicial;
    private Timestamp dataFinal;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<ConjuntoTranspVeiculo> conjuntoTranspVeiculo = new ArrayList<ConjuntoTranspVeiculo>();
    private CartaoValePedagio cartaoValePedagio;
    private TipoConjuntoTransportador tipoConjuntoTransportador;
    private List<ConjTransportadorEventos> conjTransportadorEventos = new ArrayList<ConjTransportadorEventos>();
    private Double vrPercentualFrete = 0.0;
    private ComponenteFrete componenteFrete;
    private String observacao;

    @Id
    @Column(nullable=false, name="ID_CONJUNTO_TRANSPORTADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONJUNTO_TRANSPORTADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_AGREGADO", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_TR_AG"))
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_MOTOR"))
    public Motorista getMotorista() {
        return this.motorista;
    }

    @Column(name="DATA_INICIAL")
    public Timestamp getDataInicial() {
        return this.dataInicial;
    }

    @Column(name="DATA_FINAL")
    public Timestamp getDataFinal() {
        return this.dataFinal;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_EMPRE"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(mappedBy="conjuntoTransportador", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<ConjuntoTranspVeiculo> getConjuntoTranspVeiculo() {
        return this.conjuntoTranspVeiculo;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    public void setMotorista(Motorista motorista) {
        this.motorista = motorista;
    }

    public void setDataInicial(Timestamp dataInicial) {
        this.dataInicial = dataInicial;
    }

    public void setDataFinal(Timestamp dataFinal) {
        this.dataFinal = dataFinal;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setConjuntoTranspVeiculo(List<ConjuntoTranspVeiculo> conjuntoTranspVeiculo) {
        this.conjuntoTranspVeiculo = conjuntoTranspVeiculo;
    }

    @OneToMany(mappedBy="conjuntoTransportador", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<ConjTransportadorEventos> getConjTransportadorEventos() {
        return this.conjTransportadorEventos;
    }

    public void setConjTransportadorEventos(List<ConjTransportadorEventos> conjTransportadorEventos) {
        this.conjTransportadorEventos = conjTransportadorEventos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getDataInicial(), this.getDataFinal()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_CARTAO_VALE_PEDAGIO", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_CARTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CartaoValePedagio getCartaoValePedagio() {
        return this.cartaoValePedagio;
    }

    public void setCartaoValePedagio(CartaoValePedagio cartaoValePedagio) {
        this.cartaoValePedagio = cartaoValePedagio;
    }

    @JoinColumn(name="ID_TIPO_CONJ_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_TP_CO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoConjuntoTransportador getTipoConjuntoTransportador() {
        return this.tipoConjuntoTransportador;
    }

    public void setTipoConjuntoTransportador(TipoConjuntoTransportador caracteristicaVeiculo) {
        this.tipoConjuntoTransportador = caracteristicaVeiculo;
    }

    @Column(nullable=false, name="VR_PERCENTUAL_FRETE", precision=15, scale=2)
    public Double getVrPercentualFrete() {
        return this.vrPercentualFrete;
    }

    public void setVrPercentualFrete(Double vrPercentualFrete) {
        this.vrPercentualFrete = vrPercentualFrete;
    }

    @JoinColumn(name="ID_COMPONENTE_FRETE", foreignKey=@ForeignKey(name="FK_CONJUNTO_TRANSPORTADOR_COM_F"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ComponenteFrete getComponenteFrete() {
        return this.componenteFrete;
    }

    public void setComponenteFrete(ComponenteFrete componenteFrete) {
        this.componenteFrete = componenteFrete;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

