/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AgenciaValores;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoContaValor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="CONTA_VALORES")
public class ContaValores
implements InterfaceVO {
    private Long identificador;
    private String nrConta;
    private String operacao;
    private String dvConta;
    private String nrCliente;
    private String descricao;
    private Double vlrMaximoCheque = 0.0;
    private Short gerarLancamentoContabil = EnumConstantsMentorSimNao.NAO.getValue();
    private Short imprimirSaldoFluxoCaixa = EnumConstantsMentorSimNao.NAO.getValue();
    private PlanoConta planoConta;
    private AgenciaValores agenciaValor;
    private String numeroConvenio;
    private String numeroConvenioPagamento;
    private String numeroConvenioPagamentoFolha;
    private String numeroConvenioCustodiaCheque;
    private String numeroAgenciaRecepCheque;
    private String dvAgenciaRecepCheque;
    private String numeroConvenioAutorDebito;
    private String codigoDac;
    private PlanoConta pcChequeTransito;
    private List<EmpresaFinanceiro> empresaFinanceiro = new ArrayList<EmpresaFinanceiro>();
    private List<CarteiraCobranca> carteiras = new ArrayList<CarteiraCobranca>();
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();
    private Integer numeroDiasDifConc = 0;
    private TipoContaValor tipoContaValor;
    private Short excluirDiasNaoUteis = EnumConstantsMentorSimNao.NAO.getValue();

    @Id
    @Column(name="ID_CONTA_VALOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTA_VALORES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DV_CONTA", length=20)
    public String getDvConta() {
        return this.dvConta;
    }

    public void setDvConta(String dvConta) {
        this.dvConta = dvConta;
    }

    @Column(name="GERAR_LANCAMENTO_CONTABIL")
    public Short getGerarLancamentoContabil() {
        return this.gerarLancamentoContabil;
    }

    public void setGerarLancamentoContabil(Short gerarLancamentoContabil) {
        this.gerarLancamentoContabil = gerarLancamentoContabil;
    }

    @Column(name="IMPRIMIR_SALDO_FLUXO_CAIXA")
    public Short getImprimirSaldoFluxoCaixa() {
        return this.imprimirSaldoFluxoCaixa;
    }

    public void setImprimirSaldoFluxoCaixa(Short imprimirSaldoFluxoCaixa) {
        this.imprimirSaldoFluxoCaixa = imprimirSaldoFluxoCaixa;
    }

    @Column(name="NR_CLIENTE", length=20)
    public String getNrCliente() {
        return this.nrCliente;
    }

    public void setNrCliente(String nrCliente) {
        this.nrCliente = nrCliente;
    }

    @Column(name="NR_CONTA", length=20)
    public String getNrConta() {
        return this.nrConta;
    }

    public void setNrConta(String nrConta) {
        this.nrConta = nrConta;
    }

    @Column(name="OPERACAO", length=5)
    public String getOperacao() {
        return this.operacao;
    }

    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_CONTA_VAL_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Column(nullable=false, name="VLR_MAXIMO_CHEQUE", precision=15, scale=4)
    public Double getVlrMaximoCheque() {
        return this.vlrMaximoCheque;
    }

    public void setVlrMaximoCheque(Double vlrMaximoCheque) {
        this.vlrMaximoCheque = vlrMaximoCheque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_AGENCIA_VALOR", foreignKey=@ForeignKey(name="FK_CONTA_VAL_AG_VALORES"))
    public AgenciaValores getAgenciaValor() {
        return this.agenciaValor;
    }

    public void setAgenciaValor(AgenciaValores agenciaValor) {
        this.agenciaValor = agenciaValor;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="EMP_FINANCEIRO_CONTA_VALOR", joinColumns={@JoinColumn(name="ID_CONTA_VALORES")}, inverseJoinColumns={@JoinColumn(name="ID_EMP_FINANCEIRO")})
    public List<EmpresaFinanceiro> getEmpresaFinanceiro() {
        return this.empresaFinanceiro;
    }

    public void setEmpresaFinanceiro(List<EmpresaFinanceiro> empresaFinanceiro) {
        this.empresaFinanceiro = empresaFinanceiro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getAgenciaValor() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getAgenciaValor().getPessoa().getNome(), this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NUMERO_CONVENIO", length=20)
    public String getNumeroConvenio() {
        return this.numeroConvenio;
    }

    public void setNumeroConvenio(String numeroConvenio) {
        this.numeroConvenio = numeroConvenio;
    }

    @Column(name="NUMERO_CONVENIO_PAGAMENTO", length=20)
    public String getNumeroConvenioPagamento() {
        return this.numeroConvenioPagamento;
    }

    public void setNumeroConvenioPagamento(String numeroConvenioPagamento) {
        this.numeroConvenioPagamento = numeroConvenioPagamento;
    }

    @Column(name="NUMERO_CONVENIO_PAGAMENTO_FOLHA", length=20)
    public String getNumeroConvenioPagamentoFolha() {
        return this.numeroConvenioPagamentoFolha;
    }

    public void setNumeroConvenioPagamentoFolha(String numeroConvenioPagamentoFolha) {
        this.numeroConvenioPagamentoFolha = numeroConvenioPagamentoFolha;
    }

    @Column(name="NUMERO_CONVENIO_CUSTODIA_CHEQUE", length=20)
    public String getNumeroConvenioCustodiaCheque() {
        return this.numeroConvenioCustodiaCheque;
    }

    public void setNumeroConvenioCustodiaCheque(String numeroConvenioCustodiaCheque) {
        this.numeroConvenioCustodiaCheque = numeroConvenioCustodiaCheque;
    }

    @Column(name="CODIGO_DAC", length=1)
    public String getCodigoDac() {
        return this.codigoDac;
    }

    public void setCodigoDac(String codigoDac) {
        this.codigoDac = codigoDac;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CH_TRANSITO", foreignKey=@ForeignKey(name="FK_CONTA_VAL_PC_CH_TRANSITO"))
    public PlanoConta getPcChequeTransito() {
        return this.pcChequeTransito;
    }

    public void setPcChequeTransito(PlanoConta pcChequeTransito) {
        this.pcChequeTransito = pcChequeTransito;
    }

    @OneToMany(mappedBy="contaValor", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<CarteiraCobranca> getCarteiras() {
        return this.carteiras;
    }

    public void setCarteiras(List<CarteiraCobranca> carteiras) {
        this.carteiras = carteiras;
    }

    @Column(name="DESCRICAO", length=150)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="NUMERO_DIAS_DIF_CONC")
    public Integer getNumeroDiasDifConc() {
        return this.numeroDiasDifConc;
    }

    public void setNumeroDiasDifConc(Integer numeroDiasDifConc) {
        this.numeroDiasDifConc = numeroDiasDifConc;
    }

    @Column(name="NUMERO_CONVENIO_AUT_DEB", length=20)
    public String getNumeroConvenioAutorDebito() {
        return this.numeroConvenioAutorDebito;
    }

    public void setNumeroConvenioAutorDebito(String numeroConvenioAutorDebito) {
        this.numeroConvenioAutorDebito = numeroConvenioAutorDebito;
    }

    @Column(name="NR_AGENCIA_RECEP_CHEQUE")
    public String getNumeroAgenciaRecepCheque() {
        return this.numeroAgenciaRecepCheque;
    }

    public void setNumeroAgenciaRecepCheque(String numeroAgenciaRecepCheque) {
        this.numeroAgenciaRecepCheque = numeroAgenciaRecepCheque;
    }

    @Column(name="DV_AGENCIA_RECEP_CHEQUE")
    public String getDvAgenciaRecepCheque() {
        return this.dvAgenciaRecepCheque;
    }

    public void setDvAgenciaRecepCheque(String dvAgenciaRecepCheque) {
        this.dvAgenciaRecepCheque = dvAgenciaRecepCheque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONTA_VALOR")
    public TipoContaValor getTipoContaValor() {
        return this.tipoContaValor;
    }

    public void setTipoContaValor(TipoContaValor tipoContaValor) {
        this.tipoContaValor = tipoContaValor;
    }

    @Column(name="EXCLUIR_DIAS_NAO_UTEIS")
    public Short getExcluirDiasNaoUteis() {
        return this.excluirDiasNaoUteis;
    }

    public void setExcluirDiasNaoUteis(Short excluirDiasNaoUteis) {
        this.excluirDiasNaoUteis = excluirDiasNaoUteis;
    }
}

