/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AcuracidadeEstContProdutos;
import com.touchcomp.basementor.model.vo.ContagemProdCentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="CONTAGEM_PRODUTOS")
public class ContagemProdutos
implements InterfaceVO {
    @Id
    @Column(name="ID_CONTAGEM_PRODUTOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTAGEM_PRODUTOS")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false)
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", nullable=true, unique=false)
    private Usuario usuario;
    @Column(name="DESCRICAO", nullable=true, unique=false, length=255)
    private String descricao;
    @Column(name="OBSERVACAO", nullable=true, unique=false, length=255)
    private String observacao;
    @Column(name="STATUS", nullable=true, unique=false)
    private Short status;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CONTAGEM", nullable=true, unique=false)
    private Date dataContagem;
    @OneToMany(mappedBy="contagemProdutos", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ContagemProdCentroEstoque> centrosEstoqueContagem = new LinkedList<ContagemProdCentroEstoque>();
    @Column(name="ID_MOBILE", nullable=true)
    private Long idMobile = 0L;
    @OneToOne(mappedBy="contagemProdutos")
    private AcuracidadeEstContProdutos acuracidadeEstContProdutos;

    public ContagemProdutos() {
        this.status = EnumConstStatusObjeto.EM_PREENCHIMENTO.getValue();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public Date getDataContagem() {
        return this.dataContagem;
    }

    @Generated
    public List<ContagemProdCentroEstoque> getCentrosEstoqueContagem() {
        return this.centrosEstoqueContagem;
    }

    @Generated
    public Long getIdMobile() {
        return this.idMobile;
    }

    @Generated
    public AcuracidadeEstContProdutos getAcuracidadeEstContProdutos() {
        return this.acuracidadeEstContProdutos;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setDataContagem(Date dataContagem) {
        this.dataContagem = dataContagem;
    }

    @Generated
    public void setCentrosEstoqueContagem(List<ContagemProdCentroEstoque> centrosEstoqueContagem) {
        this.centrosEstoqueContagem = centrosEstoqueContagem;
    }

    @Generated
    public void setIdMobile(Long idMobile) {
        this.idMobile = idMobile;
    }

    @Generated
    public void setAcuracidadeEstContProdutos(AcuracidadeEstContProdutos acuracidadeEstContProdutos) {
        this.acuracidadeEstContProdutos = acuracidadeEstContProdutos;
    }
}

