/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AdicionaisContratoLocacao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoContratoLocacao;
import com.touchcomp.basementor.model.vo.GrupoContrLocacao;
import com.touchcomp.basementor.model.vo.ItemContratoLocacao;
import com.touchcomp.basementor.model.vo.OrigemCheckList;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Procurador;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="CONTRATO_LOCACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_CONTRATO_LOCACAO_NR_CONTR", columnNames={"NUMERO_CONTRATO"})})
public class ContratoLocacao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Timestamp dataInicialVigencia;
    private Timestamp dataFinalVigencia;
    private Long numeroContrato;
    private Short tipoContrato = 0;
    private Cliente cliente;
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private FechamentoContratoLocacao fechamentoContratoLocacao;
    private Short preContrato = 0;
    private String email;
    private String telefone;
    private List<RepresentanteContratoComissao> representantesContrato = new ArrayList<RepresentanteContratoComissao>();
    private String pessoaContatoString;
    private Procurador procuradorEmpresa;
    private Procurador procuradorCliente;
    private String observacao;
    private ServicoRPS servicoRPS;
    private PlanoContaGerencial planoContaGerencial;
    private Short gerarFinanceiro = 0;
    private Short gerarContabil = 0;
    private Long diaPreferencialApuracao = 0L;
    private GrupoContrLocacao grupoContrLocacao;
    private Double valorTotalContrato = 0.0;
    private CentroCusto centroCusto;
    private String codigoSeguradora;
    private Long numeroContratoInf;
    private List<AdicionaisContratoLocacao> adicionaisConratoLoc = new ArrayList<AdicionaisContratoLocacao>();
    private List<ItemContratoLocacao> itensContratoLocacao = new ArrayList<ItemContratoLocacao>();
    private List<OrigemCheckList> locaisCheckList = new LinkedList<OrigemCheckList>();
    private Date dataEncerramento;
    private String nrControleContrato;
    private Double valorGarantia = 0.0;
    private Double valorApolice = 0.0;
    private Date dataVigencia;
    private String numeroApolice;
    private Pessoa seguradora;
    private Pessoa corretora;
    private TomadorPrestadorRps tomador;
    private Date dataEmissao;

    @Id
    @Column(nullable=false, name="ID_CONTRATO_LOCACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTRATO_LOCACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_INICIAL_VIGENCIA")
    public Timestamp getDataInicialVigencia() {
        return this.dataInicialVigencia;
    }

    public void setDataInicialVigencia(Timestamp dataInicialVigencia) {
        this.dataInicialVigencia = dataInicialVigencia;
    }

    @Column(name="DATA_FINAL_VIGENCIA")
    public Timestamp getDataFinalVigencia() {
        return this.dataFinalVigencia;
    }

    public void setDataFinalVigencia(Timestamp dataFinalVigencia) {
        this.dataFinalVigencia = dataFinalVigencia;
    }

    @Column(name="NUMERO_CONTRATO")
    @Ignore
    @Generated(value=GenerationTime.ALWAYS)
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Column(name="TIPO_CONTRATO")
    public Short getTipoContrato() {
        return this.tipoContrato;
    }

    public void setTipoContrato(Short tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=50)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @OneToOne(mappedBy="contratoLocacao", fetch=FetchType.LAZY)
    public FechamentoContratoLocacao getFechamentoContratoLocacao() {
        return this.fechamentoContratoLocacao;
    }

    public void setFechamentoContratoLocacao(FechamentoContratoLocacao fechamentoContratoLocacao) {
        this.fechamentoContratoLocacao = fechamentoContratoLocacao;
    }

    @Column(name="PRE_CONTRATO")
    public Short getPreContrato() {
        return this.preContrato;
    }

    public void setPreContrato(Short preContrato) {
        this.preContrato = preContrato;
    }

    @Column(name="EMAIL", length=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="TELEFONE", length=20)
    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Column(name="PESSOA_CONTATO_STRING", length=50)
    public String getPessoaContatoString() {
        return this.pessoaContatoString;
    }

    public void setPessoaContatoString(String pessoaContatoString) {
        this.pessoaContatoString = pessoaContatoString;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROCURADOR_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_PROC_EMPRES"))
    public Procurador getProcuradorEmpresa() {
        return this.procuradorEmpresa;
    }

    public void setProcuradorEmpresa(Procurador procuradorEmpresa) {
        this.procuradorEmpresa = procuradorEmpresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROCURADOR_CLIENTE", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_PROC_CLIENT"))
    public Procurador getProcuradorCliente() {
        return this.procuradorCliente;
    }

    public void setProcuradorCliente(Procurador procuradorCliente) {
        this.procuradorCliente = procuradorCliente;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        String ret = "Nr: " + this.numeroContrato;
        if (this.getCliente() != null) {
            ret = ret + " - Cliente: " + this.getCliente().getPessoa().getNome();
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{ret});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO_RPS", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_SERV_RPS"))
    public ServicoRPS getServicoRPS() {
        return this.servicoRPS;
    }

    public void setServicoRPS(ServicoRPS servicoRPS) {
        this.servicoRPS = servicoRPS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_PC_GER"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="GERAR_CONTABIL")
    public Short getGerarContabil() {
        return this.gerarContabil;
    }

    public void setGerarContabil(Short gerarContabil) {
        this.gerarContabil = gerarContabil;
    }

    @Column(name="DIA_PREFERENCIAL_APURACAO")
    public Long getDiaPreferencialApuracao() {
        return this.diaPreferencialApuracao;
    }

    public void setDiaPreferencialApuracao(Long diaPreferencialApuracao) {
        this.diaPreferencialApuracao = diaPreferencialApuracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_CONTR_LOC", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_CONT_SOC"))
    public GrupoContrLocacao getGrupoContrLocacao() {
        return this.grupoContrLocacao;
    }

    public void setGrupoContrLocacao(GrupoContrLocacao grupoContrLocacao) {
        this.grupoContrLocacao = grupoContrLocacao;
    }

    @Column(nullable=false, name="VALOR_TOTAL_CONTRATO", precision=15, scale=4)
    public Double getValorTotalContrato() {
        return this.valorTotalContrato;
    }

    public void setValorTotalContrato(Double valorTotalContrato) {
        this.valorTotalContrato = valorTotalContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CONTRATO_LOCACAO_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @OneToMany(mappedBy="contratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RepresentanteContratoComissao> getRepresentantesContrato() {
        return this.representantesContrato;
    }

    public void setRepresentantesContrato(List<RepresentanteContratoComissao> representantesContrato) {
        this.representantesContrato = representantesContrato;
    }

    @Column(name="CODIGO_SEGURADORA", length=50)
    public String getCodigoSeguradora() {
        return this.codigoSeguradora;
    }

    public void setCodigoSeguradora(String codigoSeguradora) {
        this.codigoSeguradora = codigoSeguradora;
    }

    @Ignore
    @Column(name="NUMERO_CONTRATO_INF")
    public Long getNumeroContratoInf() {
        return this.numeroContratoInf;
    }

    public void setNumeroContratoInf(Long numeroContratoInf) {
        this.numeroContratoInf = numeroContratoInf;
    }

    @OneToMany(mappedBy="contratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<AdicionaisContratoLocacao> getAdicionaisConratoLoc() {
        return this.adicionaisConratoLoc;
    }

    public void setAdicionaisConratoLoc(List<AdicionaisContratoLocacao> adicionaisConratoLoc) {
        this.adicionaisConratoLoc = adicionaisConratoLoc;
    }

    @OneToMany(mappedBy="contratoLocacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemContratoLocacao> getItensContratoLocacao() {
        return this.itensContratoLocacao;
    }

    public void setItensContratoLocacao(List<ItemContratoLocacao> itensContratoLocacao) {
        this.itensContratoLocacao = itensContratoLocacao;
    }

    @OneToMany(mappedBy="contratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<OrigemCheckList> getLocaisCheckList() {
        return this.locaisCheckList;
    }

    public void setLocaisCheckList(List<OrigemCheckList> locaisCheckList) {
        this.locaisCheckList = locaisCheckList;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENCERRAMENTO")
    public Date getDataEncerramento() {
        return this.dataEncerramento;
    }

    public void setDataEncerramento(Date dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @Column(name="NR_CONTROLE_CONTRATO", length=20)
    public String getNrControleContrato() {
        return this.nrControleContrato;
    }

    public void setNrControleContrato(String nrControleContrato) {
        this.nrControleContrato = nrControleContrato;
    }

    @Column(name="VALOR_GARANTIA", precision=15, scale=4)
    public Double getValorGarantia() {
        return this.valorGarantia;
    }

    public void setValorGarantia(Double valorGarantia) {
        this.valorGarantia = valorGarantia;
    }

    @Column(name="VALOR_APOLICE", precision=15, scale=4)
    public Double getValorApolice() {
        return this.valorApolice;
    }

    public void setValorApolice(Double valorApolice) {
        this.valorApolice = valorApolice;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VIGENCIA")
    public Date getDataVigencia() {
        return this.dataVigencia;
    }

    public void setDataVigencia(Date dataVigencia) {
        this.dataVigencia = dataVigencia;
    }

    @Column(name="NUMERO_APOLICE", length=20)
    public String getNumeroApolice() {
        return this.numeroApolice;
    }

    public void setNumeroApolice(String numeroApolice) {
        this.numeroApolice = numeroApolice;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SEGURADORA", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_SEGURADORA"))
    public Pessoa getSeguradora() {
        return this.seguradora;
    }

    public void setSeguradora(Pessoa seguradora) {
        this.seguradora = seguradora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CORRETORA", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_CORRETORA"))
    public Pessoa getCorretora() {
        return this.corretora;
    }

    public void setCorretora(Pessoa corretora) {
        this.corretora = corretora;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TOMADOR", foreignKey=@ForeignKey(name="FK_CONTRATO_LOC_TOMADOR"))
    public TomadorPrestadorRps getTomador() {
        return this.tomador;
    }

    public void setTomador(TomadorPrestadorRps tomador) {
        this.tomador = tomador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }
}

