/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.ContrConsViagemConsumos;
import com.touchcomp.basementor.model.vo.ContrConsumosViagemCte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TransportadorAgregado;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CONTROLE_CONSUMOS_VIAGEM")
public class ControleConsumosViagem
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataAberturaViagem;
    private Date dataEncerramentoViagem;
    private ConjuntoTransportador conjuntoTransportador;
    private List<ContrConsumosViagemCte> contrConsumosViagemCte = new ArrayList<ContrConsumosViagemCte>();
    private Cidade cidadeInicioViagem;
    private Cidade cidadeEncerramentoViagem;
    private List<ContrConsViagemConsumos> contrConsViagemConsumos = new ArrayList<ContrConsViagemConsumos>();
    private String observacao;
    private Cidade cidadeCarregamento;
    private Cidade cidadeDescarregamento;
    private Date dataPrevisao;
    private Long identificacaoTicket = 0L;
    private Pessoa remetente;
    private Pessoa destinatario;
    private TransportadorAgregado transportadorAgregado;
    private Double peso = 0.0;
    private Double valor = 0.0;
    private Double quantidade = 0.0;
    private UnidadeMedida unidMedida;
    private Double vrPedagio = 0.0;
    private Double vrCarga = 0.0;
    private Double desconto = 0.0;
    private Double vrTotal = 0.0;
    private Motorista motorista;
    private CentroCusto centroCusto;
    private String placa;

    @Id
    @Column(nullable=false, name="ID_CONTROLE_CONSUMOS_VIAGEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CONTROLE_CONSUMOS_VIAGEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CONTROLE_CONSUMOS_VIAGEM_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_ABERTURA_VIAGEM")
    public Date getDataAberturaViagem() {
        return this.dataAberturaViagem;
    }

    public void setDataAberturaViagem(Date dataAberturaViagem) {
        this.dataAberturaViagem = dataAberturaViagem;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENCERRAMENTO_VIAGEM")
    public Date getDataEncerramentoViagem() {
        return this.dataEncerramentoViagem;
    }

    public void setDataEncerramentoViagem(Date dataEncerramentoViagem) {
        this.dataEncerramentoViagem = dataEncerramentoViagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_CONTROLE_CONSUMOS_VIAGEM_CON"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @OneToMany(mappedBy="controleConsumosViagem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ContrConsumosViagemCte> getContrConsumosViagemCte() {
        return this.contrConsumosViagemCte;
    }

    public void setContrConsumosViagemCte(List<ContrConsumosViagemCte> contrConsumosViagemCte) {
        this.contrConsumosViagemCte = contrConsumosViagemCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_INICIO_VIAGEM", foreignKey=@ForeignKey(name="FK_CONTROLE_CONSUMOS_VIAGEM_CIV"))
    public Cidade getCidadeInicioViagem() {
        return this.cidadeInicioViagem;
    }

    public void setCidadeInicioViagem(Cidade cidadeInicioViagem) {
        this.cidadeInicioViagem = cidadeInicioViagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_ENCERRAMENTO_VIAGEM", foreignKey=@ForeignKey(name="FK_CONTROLE_CONSUMOS_VIAGEM_CEV"))
    public Cidade getCidadeEncerramentoViagem() {
        return this.cidadeEncerramentoViagem;
    }

    public void setCidadeEncerramentoViagem(Cidade cidadeEncerramentoViagem) {
        this.cidadeEncerramentoViagem = cidadeEncerramentoViagem;
    }

    @OneToMany(mappedBy="controleConsumosViagem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ContrConsViagemConsumos> getContrConsViagemConsumos() {
        return this.contrConsViagemConsumos;
    }

    public void setContrConsViagemConsumos(List<ContrConsViagemConsumos> contrConsViagemConsumos) {
        this.contrConsViagemConsumos = contrConsViagemConsumos;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_CARREGAMENTO", foreignKey=@ForeignKey(name="FK_CONT_CONS_VIAGEM_CARREG"))
    public Cidade getCidadeCarregamento() {
        return this.cidadeCarregamento;
    }

    public void setCidadeCarregamento(Cidade cidadeCarregamento) {
        this.cidadeCarregamento = cidadeCarregamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CIDADE_DESCARREGAMENTO", foreignKey=@ForeignKey(name="FK_CONT_CONS_VIAGEM_DESCARREG"))
    public Cidade getCidadeDescarregamento() {
        return this.cidadeDescarregamento;
    }

    public void setCidadeDescarregamento(Cidade cidadeDescarregamento) {
        this.cidadeDescarregamento = cidadeDescarregamento;
    }

    @Column(name="data_previsao")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevisao() {
        return this.dataPrevisao;
    }

    public void setDataPrevisao(Date dataPrevisao) {
        this.dataPrevisao = dataPrevisao;
    }

    @Column(name="identificacao_ticket")
    public Long getIdentificacaoTicket() {
        return this.identificacaoTicket;
    }

    public void setIdentificacaoTicket(Long identificacaoTicket) {
        this.identificacaoTicket = identificacaoTicket;
    }

    @ManyToOne
    @JoinColumn(name="id_remetente", foreignKey=@ForeignKey(name="FK_CONTROLE_VIAGEM_REMETENTE"))
    public Pessoa getRemetente() {
        return this.remetente;
    }

    public void setRemetente(Pessoa remetente) {
        this.remetente = remetente;
    }

    @ManyToOne
    @JoinColumn(name="id_destinatario", foreignKey=@ForeignKey(name="FK_CONTROLE_VIAGEM_DESTINATARIO"))
    public Pessoa getDestinatario() {
        return this.destinatario;
    }

    public void setDestinatario(Pessoa destinatario) {
        this.destinatario = destinatario;
    }

    @ManyToOne
    @JoinColumn(name="id_transportador_agregado", foreignKey=@ForeignKey(name="fk_controle_viagem_trans_agregado"))
    public TransportadorAgregado getTransportadorAgregado() {
        return this.transportadorAgregado;
    }

    public void setTransportadorAgregado(TransportadorAgregado transportadorAgregado) {
        this.transportadorAgregado = transportadorAgregado;
    }

    @Column(name="peso", precision=15, scale=2)
    public Double getPeso() {
        return this.peso;
    }

    public void setPeso(Double peso) {
        this.peso = peso;
    }

    @Column(name="valor", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="quantidade", precision=15, scale=2)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne
    @JoinColumn(name="id_unidade_medida", foreignKey=@ForeignKey(name="fk_controle_viagem_unidade_med"))
    public UnidadeMedida getUnidMedida() {
        return this.unidMedida;
    }

    public void setUnidMedida(UnidadeMedida unidMedida) {
        this.unidMedida = unidMedida;
    }

    @Column(name="vr_pedagio", precision=15, scale=2)
    public Double getVrPedagio() {
        return this.vrPedagio;
    }

    public void setVrPedagio(Double vrPedagio) {
        this.vrPedagio = vrPedagio;
    }

    @Column(name="vr_carga", precision=15, scale=2)
    public Double getVrCarga() {
        return this.vrCarga;
    }

    public void setVrCarga(Double vrCarga) {
        this.vrCarga = vrCarga;
    }

    @Column(name="desconto", precision=15, scale=2)
    public Double getDesconto() {
        return this.desconto;
    }

    public void setDesconto(Double desconto) {
        this.desconto = desconto;
    }

    @Column(name="vr_total", precision=15, scale=2)
    public Double getVrTotal() {
        return this.vrTotal;
    }

    public void setVrTotal(Double vrTotal) {
        this.vrTotal = vrTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_CONT_CONS_VIAGEM_MOTORISTA"))
    public Motorista getMotorista() {
        return this.motorista;
    }

    public void setMotorista(Motorista motorista) {
        this.motorista = motorista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CONT_CONS_VIAGEM_CENTRO_CUST"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="PLACA", length=7)
    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }
}

