/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CronogramaPlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GeracaoOrdemServicoPlanoManutencao;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementor.model.vo.TipoServico;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="CRONOGRAMA_ORDEM_SERVICO", uniqueConstraints={@UniqueConstraint(name="UNQ1_CRONOGRAMA_ORDEM_SERVICO", columnNames={"ID_ORDEM_SERVICO"})})
public class CronogramaOrdemServico
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private OrdemServico ordemServico;
    private GeracaoOrdemServicoPlanoManutencao geracaoOrdemServico;
    private Timestamp dataProgramada;
    private Short simulado = 0;
    private Equipamento equipamento;
    private SetorExecutante setorExecutante;
    private CentroCusto centroCusto;
    private TipoServico tipoServico;
    private Short status = 0;
    private List<CronogramaPlanoManutencaoAtivo> planoManutencao = new ArrayList<CronogramaPlanoManutencaoAtivo>();

    @Id
    @Column(name="ID_CRONOGRAMA_ORDEM_SERVICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_CRONOGRAMA_ORDEM_SERVICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_EMPR"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GERACAO_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_GER_OS"))
    public GeracaoOrdemServicoPlanoManutencao getGeracaoOrdemServico() {
        return this.geracaoOrdemServico;
    }

    public void setGeracaoOrdemServico(GeracaoOrdemServicoPlanoManutencao geracaoOrdemServico) {
        this.geracaoOrdemServico = geracaoOrdemServico;
    }

    @OneToOne(fetch=FetchType.LAZY, targetEntity=OrdemServico.class)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_OS"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_PROGRAMADA")
    public Timestamp getDataProgramada() {
        return this.dataProgramada;
    }

    public void setDataProgramada(Timestamp dataProgramada) {
        this.dataProgramada = dataProgramada;
    }

    @Column(name="SIMULADO")
    public Short getSimulado() {
        return this.simulado;
    }

    public void setSimulado(Short simulado) {
        this.simulado = simulado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_EQUIPA"))
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SETOR_EXECUTANTE", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_SET_EX"))
    public SetorExecutante getSetorExecutante() {
        return this.setorExecutante;
    }

    public void setSetorExecutante(SetorExecutante setorExecutante) {
        this.setorExecutante = setorExecutante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_CEN_C"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO", foreignKey=@ForeignKey(name="FK_CRONOGR_ORDEM_SERVICO_TIP_SE"))
    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(TipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short Status) {
        this.status = Status;
    }

    @OneToMany(mappedBy="cronograma", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CronogramaPlanoManutencaoAtivo> getPlanoManutencao() {
        return this.planoManutencao;
    }

    public void setPlanoManutencao(List<CronogramaPlanoManutencaoAtivo> planoManutencao) {
        this.planoManutencao = planoManutencao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

