/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="DIAGNOSTICO_OS_ATIVO")
public class DiagnosticoOSAtivo
implements InterfaceVO {
    private Long identificador;
    private OrdemServico ordemServico;
    private String observacao;
    private Date dataCadastro;
    private Pessoa responsavel;
    private PedidoAlmoxarifado pedidoAlmoxarifado;
    private Short gerarPedAlmoxarifado = 0;
    private Date dataNecessidade;
    private List<DiagnosticoOSAtivoServico> servicos = new ArrayList<DiagnosticoOSAtivoServico>();

    @Id
    @Column(nullable=false, name="ID_DIAGNOSTICO_OS_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_DIAGNOSTICO_OS_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_ATIVO_OS"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_ATIVO_RESPONS"))
    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_ALMOXARIFADO", foreignKey=@ForeignKey(name="FK_DIAGNOSTICO_OS_ATIVO_PED_ALM"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN, CascadeType.SAVE_UPDATE})
    public PedidoAlmoxarifado getPedidoAlmoxarifado() {
        return this.pedidoAlmoxarifado;
    }

    public void setPedidoAlmoxarifado(PedidoAlmoxarifado pedidoAlmoxarifado) {
        this.pedidoAlmoxarifado = pedidoAlmoxarifado;
    }

    @Column(name="GERAR_PED_ALMOXARIFADO")
    public Short getGerarPedAlmoxarifado() {
        return this.gerarPedAlmoxarifado;
    }

    public void setGerarPedAlmoxarifado(Short gerarPedAlmoxarifado) {
        this.gerarPedAlmoxarifado = gerarPedAlmoxarifado;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_NECESSIDADE")
    public Date getDataNecessidade() {
        return this.dataNecessidade;
    }

    public void setDataNecessidade(Date dataNecessidade) {
        this.dataNecessidade = dataNecessidade;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Diagnostico: {0} Codigo OS: {1} Ativo: {2}", (Object[])new Object[]{this.getIdentificador(), this.getOrdemServico() != null ? this.getOrdemServico().getCodigo() : this.getOrdemServico(), this.getOrdemServico() != null ? this.getOrdemServico().getEquipamento().getNome() : this.getOrdemServico()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="diagnosticoOSAtivo")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<DiagnosticoOSAtivoServico> getServicos() {
        return this.servicos;
    }

    public void setServicos(List<DiagnosticoOSAtivoServico> servicos) {
        this.servicos = servicos;
    }
}

