/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BloqueioGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EncerramentoContabilItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ENCERRAMENTO_CONTABIL")
public class EncerramentoContabil
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private Date dataFinal;
    private Long ano;
    private Short bloquearPeriodo = 0;
    private PlanoConta contaResultado;
    private Short tipoEncerramento = 0;
    private HistoricoPadrao historicoPadrao;
    private String historico;
    private Empresa empresa;
    private PlanoConta contaCredora;
    private PlanoConta contaDevedora;
    private HistoricoPadrao historicoPadraoLanc;
    private String historicoLanc;
    private BloqueioGeral bloqueioGeral;
    private GrupoEmpresa grupoEmpresa;
    private Long mes;
    private List<EncerramentoContabilItem> itensEncerramentoContabil;

    public EncerramentoContabil() {
        this.setItensEncerramentoContabil(new ArrayList<EncerramentoContabilItem>());
    }

    @Id
    @Column(nullable=false, name="ID_ENCERRAMENTO_CONTABIL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ENCERRAMENTO_CONTABIL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Ignore
    @Column(name="ANO")
    public Long getAno() {
        return this.ano;
    }

    public void setAno(Long ano) {
        this.ano = ano;
    }

    @JoinColumn(name="ID_PC_RESULTADO", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_PC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getContaResultado() {
        return this.contaResultado;
    }

    public void setContaResultado(PlanoConta contaResultado) {
        this.contaResultado = contaResultado;
    }

    @Column(name="TIPO_ENCERRAMENTO")
    public Short getTipoEncerramento() {
        return this.tipoEncerramento;
    }

    public void setTipoEncerramento(Short tipoEncerramento) {
        this.tipoEncerramento = tipoEncerramento;
    }

    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_HIST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @Column(name="BLOQUEAR_PERIODO")
    public Short getBloquearPeriodo() {
        return this.bloquearPeriodo;
    }

    public void setBloquearPeriodo(Short bloquearPeriodo) {
        this.bloquearPeriodo = bloquearPeriodo;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ENCERRAMENTO_CONTABIL_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_PLANO_CONTA_CREDORA", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_PC_CREDORA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getContaCredora() {
        return this.contaCredora;
    }

    public void setContaCredora(PlanoConta contaCredora) {
        this.contaCredora = contaCredora;
    }

    @JoinColumn(name="ID_PLANO_CONTA_DEVEDORA", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_PC_DEVEDORA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getContaDevedora() {
        return this.contaDevedora;
    }

    public void setContaDevedora(PlanoConta contaDevedora) {
        this.contaDevedora = contaDevedora;
    }

    @JoinColumn(name="ID_HISTORICO_PADRAO_LANC", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_HIST_LANC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public HistoricoPadrao getHistoricoPadraoLanc() {
        return this.historicoPadraoLanc;
    }

    public void setHistoricoPadraoLanc(HistoricoPadrao historicoPadraoLanc) {
        this.historicoPadraoLanc = historicoPadraoLanc;
    }

    @Column(name="HISTORICO_LANC", length=500)
    public String getHistoricoLanc() {
        return this.historicoLanc;
    }

    public void setHistoricoLanc(String historicoLanc) {
        this.historicoLanc = historicoLanc;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_BLOQUEIO_GERAL", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_BLOQ_GERAL"))
    public BloqueioGeral getBloqueioGeral() {
        return this.bloqueioGeral;
    }

    public void setBloqueioGeral(BloqueioGeral bloqueioGeral) {
        this.bloqueioGeral = bloqueioGeral;
    }

    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_ENC_CONTABIL_GRUPO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getGrupoEmpresa() == null) {
            return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
        }
        return ToolBaseMethodsVO.toString((String)"{0} {1} - {2}", (Object[])new Object[]{"Encerramento ", this.getGrupoEmpresa().getDescricao(), ToolDate.dateToStr((Date)this.dataFinal)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Ignore
    @Column(name="MES")
    public Long getMes() {
        return this.mes;
    }

    public void setMes(Long mes) {
        this.mes = mes;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="encerramentoContabil", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<EncerramentoContabilItem> getItensEncerramentoContabil() {
        return this.itensEncerramentoContabil;
    }

    public void setItensEncerramentoContabil(List<EncerramentoContabilItem> itensEncerramentoContabil) {
        this.itensEncerramentoContabil = itensEncerramentoContabil;
    }
}

