/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnvioMensagensMsg;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="ENVIO_MENSAGENS")
public class EnvioMensagens
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_ENVIO_MENSAGENS")
    @GeneratedValue(generator="gen", strategy=GenerationType.SEQUENCE)
    @GenericGenerator(name="gen", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="GEN_ENVIO_MENSAGENS")})
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    private Date dataCadastro;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_AGENDAMENTO_ENVIO")
    private Date dataAgendamentoEnvio;
    @Column(name="DESCRICAO", length=500)
    private String descricao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ENVIO_MENSAGENS_EMP"))
    private Empresa empresa;
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO")
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_ENVIO_MENSAGENS_USU"))
    private Usuario usuario;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_ENVIO_MSG", foreignKey=@ForeignKey(name="FK_ENVIO_MENSAGENS_MOD"))
    private ModeloEnvioMensagens modeloEnvioMensagens;
    @Column(name="TODAS_MSG_ENVIADAS")
    private Short todasMsgEnviadas = 0;
    @Column(name="STATUS")
    private Short status;
    @OneToMany(mappedBy="envioMensagens", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="indice")
    private List<EnvioMensagensMsg> mensagens = new LinkedList<EnvioMensagensMsg>();

    public EnvioMensagens() {
        this.status = EnumConstStatusObjeto.ATIVO.getValue();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAgendamentoEnvio() {
        return this.dataAgendamentoEnvio;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public ModeloEnvioMensagens getModeloEnvioMensagens() {
        return this.modeloEnvioMensagens;
    }

    @Generated
    public Short getTodasMsgEnviadas() {
        return this.todasMsgEnviadas;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public List<EnvioMensagensMsg> getMensagens() {
        return this.mensagens;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAgendamentoEnvio(Date dataAgendamentoEnvio) {
        this.dataAgendamentoEnvio = dataAgendamentoEnvio;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setModeloEnvioMensagens(ModeloEnvioMensagens modeloEnvioMensagens) {
        this.modeloEnvioMensagens = modeloEnvioMensagens;
    }

    @Generated
    public void setTodasMsgEnviadas(Short todasMsgEnviadas) {
        this.todasMsgEnviadas = todasMsgEnviadas;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setMensagens(List<EnvioMensagensMsg> mensagens) {
        this.mensagens = mensagens;
    }
}

