/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroMedicoResponsavel;
import com.touchcomp.basementor.model.vo.EsocMonSaudeDadosExame;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocResultadoAso;
import com.touchcomp.basementor.model.vo.EsocTipoExameOcupacional;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ESOC_MONITORAMENTO_SAUDE")
public class EsocMonitoramentoSaude
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Colaborador colaborador;
    private EsocTipoExameOcupacional esocTipoExameOcupacional;
    private Date dataEmissaoAso;
    private EsocResultadoAso esocResultadoAso;
    private EsocCadastroMedicoResponsavel esocCadastroMedicoResponsavel;
    private EsocCadastroMedicoResponsavel medicoResponsavelPcmso;
    private List<EsocMonSaudeDadosExame> esocMonSaudeDadosExame = new ArrayList<EsocMonSaudeDadosExame>();
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Date dataVencimentoAso;

    @Id
    @Column(nullable=false, name="ID_ESOC_MONITORAMENTO_SAUDE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ESOC_MONITORAMENTO_SAUDE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESOC_TIPO_EXAME_OCUPACIONAL", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_TIPO_EX_OC"))
    public EsocTipoExameOcupacional getEsocTipoExameOcupacional() {
        return this.esocTipoExameOcupacional;
    }

    public void setEsocTipoExameOcupacional(EsocTipoExameOcupacional esocTipoExameOcupacional) {
        this.esocTipoExameOcupacional = esocTipoExameOcupacional;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO_ASO")
    public Date getDataEmissaoAso() {
        return this.dataEmissaoAso;
    }

    public void setDataEmissaoAso(Date dataEmissaoAso) {
        this.dataEmissaoAso = dataEmissaoAso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESOC_RESULTADO_ASO", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_RESULT_ASO"))
    public EsocResultadoAso getEsocResultadoAso() {
        return this.esocResultadoAso;
    }

    public void setEsocResultadoAso(EsocResultadoAso esocResultadoAso) {
        this.esocResultadoAso = esocResultadoAso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESOC_CAD_MEDICO_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_CAD_MED_RESP"))
    public EsocCadastroMedicoResponsavel getEsocCadastroMedicoResponsavel() {
        return this.esocCadastroMedicoResponsavel;
    }

    public void setEsocCadastroMedicoResponsavel(EsocCadastroMedicoResponsavel esocCadastroMedicoResponsavel) {
        this.esocCadastroMedicoResponsavel = esocCadastroMedicoResponsavel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_MEDICO_RESPONSAVEL_PCMSO", foreignKey=@ForeignKey(name="FK_ESOC_MON_SAUDE_MED_RESP_PCMS"))
    public EsocCadastroMedicoResponsavel getMedicoResponsavelPcmso() {
        return this.medicoResponsavelPcmso;
    }

    public void setMedicoResponsavelPcmso(EsocCadastroMedicoResponsavel medicoResponsavelPcmso) {
        this.medicoResponsavelPcmso = medicoResponsavelPcmso;
    }

    @OneToMany(mappedBy="esocMonitoramentoSaude", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<EsocMonSaudeDadosExame> getEsocMonSaudeDadosExame() {
        return this.esocMonSaudeDadosExame;
    }

    public void setEsocMonSaudeDadosExame(List<EsocMonSaudeDadosExame> esocMonSaudeDadosExame) {
        this.esocMonSaudeDadosExame = esocMonSaudeDadosExame;
    }

    @Override
    @OneToMany(mappedBy="monitoramento")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO_ASO")
    public Date getDataVencimentoAso() {
        return this.dataVencimentoAso;
    }

    public void setDataVencimentoAso(Date dataVencimentoAso) {
        this.dataVencimentoAso = dataVencimentoAso;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

