/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoTipoReferenciaPadrao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoEventoFolha;
import com.touchcomp.basementor.model.vo.DeParaTipoEventoDirf;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EVENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_EVENTO_DESCRICAO", columnNames={"DESCRICAO"}), @UniqueConstraint(name="UNQ3_EVENTO_CHAVE", columnNames={"CHAVE"}), @UniqueConstraint(name="UNQ2_EVENTO_CODIGO", columnNames={"CODIGO"})})
public class Evento
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Short tipoEvento = EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue();
    private String formula;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Long codigo;
    private Short fixo;
    private String chave;
    private String referencia;
    private List<TipoCalculoEvento> tipoCalculoEvento;
    private String campo;
    private Short eventoPadraoRescisao = EnumConstantsMentorSimNao.NAO.getValue();
    private DeParaTipoEventoDirf deParaTipoEventoDirf;
    private Short tipoEventoPlanilha;
    private Short tipoReferenciaPadrao = EnumConstEventoTipoReferenciaPadrao.REFERENCIA_VALOR.getValue();
    private Double valorReferenciaPadrao = 0.0;
    private Short utilizarDescontoImpostoFormula = EnumConstantsMentorSimNao.NAO.getValue();
    private String formulaImpressaoRescisao;
    private ClassificacaoEventoFolha classificacaoEvento;
    private Short informarCodigoEsocial;
    private String codigoEsocial;
    private String ideTabelaRubrica;
    private Short eventoFixoParaMedia;

    public Evento() {
        this.fixo = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCalculoEvento = new ArrayList<TipoCalculoEvento>();
        this.tipoEventoPlanilha = EnumConstantsMentorSimNao.NAO.getValue();
        this.informarCodigoEsocial = EnumConstantsMentorSimNao.NAO.getValue();
        this.eventoFixoParaMedia = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_EVENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(unique=true, nullable=false, name="DESCRICAO", length=250)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="TIPO_EVENTO")
    public Short getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(Short tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Column(nullable=true, name="FORMULA", length=300)
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(unique=true, nullable=false, name="CODIGO")
    @Ignore
    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Column(name="FIXO")
    public Short getFixo() {
        return this.fixo;
    }

    public void setFixo(Short fixo) {
        this.fixo = fixo;
    }

    @Column(name="CHAVE", length=50)
    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    @Column(name="REFERENCIA", length=200)
    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    @OneToMany(mappedBy="evento", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoCalculoEvento> getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(List<TipoCalculoEvento> tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @Column(name="CAMPO", length=15)
    public String getCampo() {
        return this.campo;
    }

    public void setCampo(String campo) {
        this.campo = campo;
    }

    @Column(name="EVENTO_PADRAO_RESCISAO")
    public Short getEventoPadraoRescisao() {
        return this.eventoPadraoRescisao;
    }

    public void setEventoPadraoRescisao(Short eventoPadraoRescisao) {
        this.eventoPadraoRescisao = eventoPadraoRescisao;
    }

    @Column(nullable=false, name="REFERENCIA_PADRAO", precision=15, scale=2)
    public Double getValorReferenciaPadrao() {
        return this.valorReferenciaPadrao;
    }

    public void setValorReferenciaPadrao(Double valorReferenciaPadrao) {
        this.valorReferenciaPadrao = valorReferenciaPadrao;
    }

    @OneToOne(mappedBy="evento")
    public DeParaTipoEventoDirf getDeParaTipoEventoDirf() {
        return this.deParaTipoEventoDirf;
    }

    public void setDeParaTipoEventoDirf(DeParaTipoEventoDirf deParaTipoEventoDirf) {
        this.deParaTipoEventoDirf = deParaTipoEventoDirf;
    }

    @Column(name="TIPO_EVENTO_PLANILHA")
    public Short getTipoEventoPlanilha() {
        return this.tipoEventoPlanilha;
    }

    public void setTipoEventoPlanilha(Short tipoEventoPlanilha) {
        this.tipoEventoPlanilha = tipoEventoPlanilha;
    }

    @Column(name="TIPO_REFERENCIA_PADRAO")
    public Short getTipoReferenciaPadrao() {
        return this.tipoReferenciaPadrao;
    }

    public void setTipoReferenciaPadrao(Short tipoReferenciaPadrao) {
        this.tipoReferenciaPadrao = tipoReferenciaPadrao;
    }

    @Column(name="UTILIZAR_DESCONTO_IMPOSTO_FORM")
    public Short getUtilizarDescontoImpostoFormula() {
        return this.utilizarDescontoImpostoFormula;
    }

    public void setUtilizarDescontoImpostoFormula(Short utilizarDescontoImpostoFormula) {
        this.utilizarDescontoImpostoFormula = utilizarDescontoImpostoFormula;
    }

    @Column(name="FORMULA_IMPRESSAO_RESCISAO", length=50)
    public String getFormulaImpressaoRescisao() {
        return this.formulaImpressaoRescisao;
    }

    public void setFormulaImpressaoRescisao(String formulaImpressaoRescisao) {
        this.formulaImpressaoRescisao = formulaImpressaoRescisao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_EVENTO", foreignKey=@ForeignKey(name="FK_EVENTO_CLASSIFICACAO_EVENTO"))
    public ClassificacaoEventoFolha getClassificacaoEvento() {
        return this.classificacaoEvento;
    }

    public void setClassificacaoEvento(ClassificacaoEventoFolha classificacaoEvento) {
        this.classificacaoEvento = classificacaoEvento;
    }

    @Column(name="INFORMAR_CODIGO_ESOCIAL")
    public Short getInformarCodigoEsocial() {
        return this.informarCodigoEsocial;
    }

    public void setInformarCodigoEsocial(Short informarCodigoEsocial) {
        this.informarCodigoEsocial = informarCodigoEsocial;
    }

    @Column(name="CODIGO_E_ESOCIAL", length=100)
    public String getCodigoEsocial() {
        return this.codigoEsocial;
    }

    public void setCodigoEsocial(String codigoEsocial) {
        this.codigoEsocial = codigoEsocial;
    }

    @Column(name="IDE_TABELA_RUBRICA", length=10)
    public String getIdeTabelaRubrica() {
        return this.ideTabelaRubrica;
    }

    public void setIdeTabelaRubrica(String ideTabelaRubrica) {
        this.ideTabelaRubrica = ideTabelaRubrica;
    }

    @Column(name="EVENTO_FIXO_PARA_MEDIA")
    public Short getEventoFixoParaMedia() {
        return this.eventoFixoParaMedia;
    }

    public void setEventoFixoParaMedia(Short eventoFixoParaMedia) {
        this.eventoFixoParaMedia = eventoFixoParaMedia;
    }
}

