/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoEvtOsPCP;
import com.touchcomp.basementor.model.vo.ColabEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOSProdLinMultSubOS;
import com.touchcomp.basementor.model.vo.EventoOsProdLinProdEquip;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FuncoesEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducaoOS;
import com.touchcomp.basementor.model.vo.PreEventoOsLinhaProducao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="EVENTO_OS_PROD_LINHA_PROD")
public class EventoOsProducaoLinhaProd
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataAbertura;
    private Date dataFechamento;
    private TipoEvento tipoEvento;
    private FaseProdutiva faseProdutiva;
    private Double horaEvento = 0.0;
    private Double horaEventoRoteiro = 0.0;
    private SubdivisaoOSProdLinhaProd subdivisaoOSProd;
    private List<ColabEvtOsProdLinhaProd> colaboradoresEvtProd = new ArrayList<ColabEvtOsProdLinhaProd>();
    private ComunicadoProducao comunicadoProducao;
    private Requisicao requisicao;
    private TurnoDeTrabalho turnoDeTrabalho;
    private ItemEmbalagemProducaoOS itemEmbalagemProdOS;
    private List<EventoOsProdLinProdEquip> equipamentos;
    private Short tipoApontEvento = 1;
    private Short origemEvento;
    private ClassificacaoEvtOsPCP classificacaoEvento;
    private EventoOSProdLinMultSubOS eventoMultiploSubOS;
    private String codigoBarras;
    private String codigoSincronizacao;
    private List<PreEventoOsLinhaProducao> preEventos = new ArrayList<PreEventoOsLinhaProducao>();
    private PreEventoOsLinhaProducao preEventoOsLinhaProducaoGerado;
    private List<FuncoesEvtOsProdLinhaProd> funcoesEvt;

    public EventoOsProducaoLinhaProd() {
        this.equipamentos = new ArrayList<EventoOsProdLinProdEquip>();
        this.origemEvento = EnumConstOrigemEventoOSProd.COMPLETO.getValue();
        this.funcoesEvt = new ArrayList<FuncoesEvtOsProdLinhaProd>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_EVENTO_OS_PROD_LINHA_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_EVENTO_OS_PROD_LINHA_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_ABERTURA")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ENCERRAMENTO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @JoinColumn(name="ID_TIPO_EVENTO", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_TP_EVT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEvento getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEvento tipoEvento) {
        this.tipoEvento = tipoEvento;
    }

    @Column(nullable=false, name="HORA_EVENTO", precision=12, scale=4)
    public Double getHoraEvento() {
        return this.horaEvento;
    }

    public void setHoraEvento(Double horaEvento) {
        this.horaEvento = horaEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FASE_PRODUTIVA", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD__PROD"))
    public FaseProdutiva getFaseProdutiva() {
        return this.faseProdutiva;
    }

    public void setFaseProdutiva(FaseProdutiva faseProdutiva) {
        this.faseProdutiva = faseProdutiva;
    }

    @OneToMany(mappedBy="eventoOsProducao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ColabEvtOsProdLinhaProd> getColaboradoresEvtProd() {
        return this.colaboradoresEvtProd;
    }

    public void setColaboradoresEvtProd(List<ColabEvtOsProdLinhaProd> colaboradoresEvtProd) {
        this.colaboradoresEvtProd = colaboradoresEvtProd;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_SUBDIVISAO_OS_PROD", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_SUB"))
    public SubdivisaoOSProdLinhaProd getSubdivisaoOSProd() {
        return this.subdivisaoOSProd;
    }

    public void setSubdivisaoOSProd(SubdivisaoOSProdLinhaProd subdivisaoOSProd) {
        this.subdivisaoOSProd = subdivisaoOSProd;
    }

    @OneToOne(mappedBy="eventoOsProducao", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ComunicadoProducao getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    public void setComunicadoProducao(ComunicadoProducao comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    @OneToOne(mappedBy="eventoOsProducaoLinhaProd", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getIdentificador() != null) {
            return ToolBaseMethodsVO.toString((String)"Evento: {0}", (Object[])new Object[]{this.getIdentificador()});
        }
        return ToolBaseMethodsVO.toString((String)"Evento: sem identificador", (Object[])new Object[]{""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TURNO_DE_TRABALHO", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_TURN_TR"))
    public TurnoDeTrabalho getTurnoDeTrabalho() {
        return this.turnoDeTrabalho;
    }

    public void setTurnoDeTrabalho(TurnoDeTrabalho turnoDeTrabalho) {
        this.turnoDeTrabalho = turnoDeTrabalho;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_EMBALAGEM_PRODUCAO_OS", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_IT_EMB_"))
    public ItemEmbalagemProducaoOS getItemEmbalagemProdOS() {
        return this.itemEmbalagemProdOS;
    }

    public void setItemEmbalagemProdOS(ItemEmbalagemProducaoOS itemEmbalagemProdOS) {
        this.itemEmbalagemProdOS = itemEmbalagemProdOS;
    }

    @OneToMany(mappedBy="eventoOsLinProd")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EventoOsProdLinProdEquip> getEquipamentos() {
        return this.equipamentos;
    }

    public void setEquipamentos(List<EventoOsProdLinProdEquip> equipamentos) {
        this.equipamentos = equipamentos;
    }

    @Column(name="TIPO_APONT_EVENTO")
    public Short getTipoApontEvento() {
        return this.tipoApontEvento;
    }

    public void setTipoApontEvento(Short tipoApontEvento) {
        this.tipoApontEvento = tipoApontEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_EVT_OS_LIN_PR", foreignKey=@ForeignKey(name="FK_EVT_OS_PROD_LIN_PROD_CL_EVT"))
    public ClassificacaoEvtOsPCP getClassificacaoEvento() {
        return this.classificacaoEvento;
    }

    public void setClassificacaoEvento(ClassificacaoEvtOsPCP classificacaoEvento) {
        this.classificacaoEvento = classificacaoEvento;
    }

    @OneToOne(mappedBy="eventoGerado")
    public EventoOSProdLinMultSubOS getEventoMultiplos() {
        return this.eventoMultiploSubOS;
    }

    public void setEventoMultiplos(EventoOSProdLinMultSubOS eventoMultiplos) {
        this.eventoMultiploSubOS = eventoMultiplos;
    }

    @Column(name="HORA_EVENTO_ROTEIRO", precision=15, scale=4)
    public Double getHoraEventoRoteiro() {
        return this.horaEventoRoteiro;
    }

    public void setHoraEventoRoteiro(Double horaEventoRoteiro) {
        this.horaEventoRoteiro = horaEventoRoteiro;
    }

    @Column(name="CODIGO_BARRAS", length=12)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Column(name="CODIGO_SINCRONIZACAO", length=25)
    public String getCodigoSincronizacao() {
        return this.codigoSincronizacao;
    }

    public void setCodigoSincronizacao(String codigoSincronizacao) {
        this.codigoSincronizacao = codigoSincronizacao;
    }

    @OneToMany(mappedBy="eventoOSProducaoLinProd", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<PreEventoOsLinhaProducao> getPreEventos() {
        return this.preEventos;
    }

    public void setPreEventos(List<PreEventoOsLinhaProducao> preEventos) {
        this.preEventos = preEventos;
    }

    @Column(name="ORIGEM_EVENTO")
    public Short getOrigemEvento() {
        return this.origemEvento;
    }

    public void setOrigemEvento(Short origemEvento) {
        this.origemEvento = origemEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_EVENTO_OS_LINHA_PROD")
    public PreEventoOsLinhaProducao getPreEventoOsLinhaProducaoGerado() {
        return this.preEventoOsLinhaProducaoGerado;
    }

    public void setPreEventoOsLinhaProducaoGerado(PreEventoOsLinhaProducao preEventoOsLinhaProducaoGerado) {
        this.preEventoOsLinhaProducaoGerado = preEventoOsLinhaProducaoGerado;
    }

    @OneToMany(mappedBy="eventoOsProducao", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<FuncoesEvtOsProdLinhaProd> getFuncoesEvt() {
        return this.funcoesEvt;
    }

    public void setFuncoesEvt(List<FuncoesEvtOsProdLinhaProd> funcoesEvt) {
        this.funcoesEvt = funcoesEvt;
    }
}

