/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.fasecomercial.EnumConstStatusFaseComercial;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.MotivoDesistencia;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="FASE_COMERCIAL")
public class FaseComercial
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private Double percentual = 0.0;
    private ProcedenciaSolicitacao procedenciaSolicitacao;
    private ClassificacaoMarketing classificacaoMarketing;
    private SetorUsuario setorUsuario;
    private ModeloFichaTecnica modeloFichaTecnica;
    private Integer indiceAvancoComercial = 0;
    private Short exigirPropostaComercial = 0;
    private List<MotivoDesistencia> motivosDesistencia;
    private Short statusProspeccaoComercial = EnumConstStatusFaseComercial.ANDAMENTO.getValue();

    public FaseComercial() {
        this.motivosDesistencia = new LinkedList<MotivoDesistencia>();
    }

    @Id
    @Column(nullable=false, name="ID_FASE_COMERCIAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FASE_COMERCIAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_FASE_COMERCIAL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=150)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="PERCENTUAL", precision=15, scale=2)
    public Double getPercentual() {
        return this.percentual;
    }

    public void setPercentual(Double percentual) {
        this.percentual = percentual;
    }

    @JoinColumn(name="ID_PROCEDENCIA_SOLICITACAO", foreignKey=@ForeignKey(name="FK_FASE_COMERCIAL_PROC_SOL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ProcedenciaSolicitacao getProcedenciaSolicitacao() {
        return this.procedenciaSolicitacao;
    }

    public void setProcedenciaSolicitacao(ProcedenciaSolicitacao procedenciaSolicitacao) {
        this.procedenciaSolicitacao = procedenciaSolicitacao;
    }

    @JoinColumn(name="ID_CLASSIFICACAO_MARKETING", foreignKey=@ForeignKey(name="FK_FASE_COMERCIAL_CLAS_MARK"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClassificacaoMarketing getClassificacaoMarketing() {
        return this.classificacaoMarketing;
    }

    public void setClassificacaoMarketing(ClassificacaoMarketing classificacaoMarketing) {
        this.classificacaoMarketing = classificacaoMarketing;
    }

    @JoinColumn(name="ID_MODELO_FICHA_TECNICA", foreignKey=@ForeignKey(name="FK_FASE_COMERCIAL_MOD_FICHA_TEC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModeloFichaTecnica getModeloFichaTecnica() {
        return this.modeloFichaTecnica;
    }

    public void setModeloFichaTecnica(ModeloFichaTecnica modeloFichaTecnica) {
        this.modeloFichaTecnica = modeloFichaTecnica;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_SETOR_USUARIO", foreignKey=@ForeignKey(name="FK_FASE_COMERCIAL_SET_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SetorUsuario getSetorUsuario() {
        return this.setorUsuario;
    }

    public void setSetorUsuario(SetorUsuario setorUsuario) {
        this.setorUsuario = setorUsuario;
    }

    @Column(name="INDICE_AVANCO_COM")
    public Integer getIndiceAvancoComercial() {
        return this.indiceAvancoComercial;
    }

    public void setIndiceAvancoComercial(Integer indiceAvancoComercial) {
        this.indiceAvancoComercial = indiceAvancoComercial;
    }

    @Column(name="STATUS_PROSPECCAO")
    public Short getStatusProspeccaoComercial() {
        return this.statusProspeccaoComercial;
    }

    public void setStatusProspeccaoComercial(Short tipoProspecaoComercial) {
        this.statusProspeccaoComercial = tipoProspecaoComercial;
    }

    @OneToMany
    @JoinTable(name="fase_comercial_mot_desis", joinColumns={@JoinColumn(name="id_fase_comercial")}, inverseJoinColumns={@JoinColumn(name="id_motivo_desistencia")})
    public List<MotivoDesistencia> getMotivosDesistencia() {
        return this.motivosDesistencia;
    }

    public void setMotivosDesistencia(List<MotivoDesistencia> motivosDesistencia) {
        this.motivosDesistencia = motivosDesistencia;
    }

    @Column(name="EXIGIR_PROPOSTA_COMERCIAL")
    public Short getExigirPropostaComercial() {
        return this.exigirPropostaComercial;
    }

    public void setExigirPropostaComercial(Short exigirPropostaComercial) {
        this.exigirPropostaComercial = exigirPropostaComercial;
    }
}

