/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.TipoOperacaoGeracaoFaturamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FATURA_CTE")
public class FaturaCte
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Double valorPrestacao = 0.0;
    private Double valorReceber = 0.0;
    private Double baseCalcIcms = 0.0;
    private Double vrIcms = 0.0;
    private Date dataVencimento;
    private TipoOperacaoGeracaoFaturamento tipoOperacaoGeracaoFatur;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private List<Cte> cte = new ArrayList<Cte>();
    private List<Rps> rps = new ArrayList<Rps>();
    private LoteContabil loteContabil;
    private Double vlrAcrescimo = 0.0;
    private Double vlrDesconto = 0.0;
    private Double vlrFatura = 0.0;
    private Integer nrCtes = 0;
    private Integer nrRps = 0;

    @Id
    @Column(nullable=false, name="ID_FATURA_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FATURA_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_FATURA_CTE_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(nullable=false, name="VALOR_PRESTACAO", precision=12, scale=2)
    public Double getValorPrestacao() {
        return this.valorPrestacao;
    }

    public void setValorPrestacao(Double valorPrestacao) {
        this.valorPrestacao = valorPrestacao;
    }

    @Column(nullable=false, name="VALOR_RECEBER", precision=12, scale=2)
    public Double getValorReceber() {
        return this.valorReceber;
    }

    public void setValorReceber(Double valorReceber) {
        this.valorReceber = valorReceber;
    }

    @Column(nullable=false, name="BASE_CALC_ICMS", precision=12, scale=2)
    public Double getBaseCalcIcms() {
        return this.baseCalcIcms;
    }

    public void setBaseCalcIcms(Double baseCalcIcms) {
        this.baseCalcIcms = baseCalcIcms;
    }

    @Column(nullable=false, name="VR_ICMS", precision=12, scale=2)
    public Double getVrIcms() {
        return this.vrIcms;
    }

    public void setVrIcms(Double vrIcms) {
        this.vrIcms = vrIcms;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @OneToMany(mappedBy="faturaCte", fetch=FetchType.LAZY, cascade={CascadeType.ALL, CascadeType.PERSIST})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @OneToMany(mappedBy="faturaCte", fetch=FetchType.LAZY)
    public List<Cte> getCte() {
        return this.cte;
    }

    public void setCte(List<Cte> cte) {
        this.cte = cte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TIPO_OPERACAO_GERACAO_FATUR", foreignKey=@ForeignKey(name="FK_FATURA_CTE_TIPO_OPER_GER_FAT"))
    public TipoOperacaoGeracaoFaturamento getTipoOperacaoGeracaoFatur() {
        return this.tipoOperacaoGeracaoFatur;
    }

    public void setTipoOperacaoGeracaoFatur(TipoOperacaoGeracaoFaturamento tipoOperacaoGeracaoFatur) {
        this.tipoOperacaoGeracaoFatur = tipoOperacaoGeracaoFatur;
    }

    @OneToMany(mappedBy="faturaCte", fetch=FetchType.LAZY)
    public List<Rps> getRps() {
        return this.rps;
    }

    public void setRps(List<Rps> rps) {
        this.rps = rps;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_FATURA_CTE_LOTE_CONTABIL"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @Column(name="VLR_ACRESCIMO", precision=15, scale=2)
    public Double getVlrAcrescimo() {
        return this.vlrAcrescimo;
    }

    public void setVlrAcrescimo(Double vlrAcrescimo) {
        this.vlrAcrescimo = vlrAcrescimo;
    }

    @Column(name="VLR_DESCONTO", precision=15, scale=2)
    public Double getVlrDesconto() {
        return this.vlrDesconto;
    }

    public void setVlrDesconto(Double vlrDesconto) {
        this.vlrDesconto = vlrDesconto;
    }

    @Column(name="VLR_FATURA", precision=15, scale=2)
    public Double getVlrFatura() {
        return this.vlrFatura;
    }

    public void setVlrFatura(Double vlrFatura) {
        this.vlrFatura = vlrFatura;
    }

    @Column(name="NUMERO_CTES")
    public Integer getNrCtes() {
        return this.nrCtes;
    }

    public void setNrCtes(Integer nrCtes) {
        this.nrCtes = nrCtes;
    }

    @Column(name="NUMERO_RPS")
    public Integer getNrRps() {
        return this.nrRps;
    }

    public void setNrRps(Integer nrRps) {
        this.nrRps = nrRps;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

