/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.FeriadoAno;
import com.touchcomp.basementor.model.vo.FeriadoCidade;
import com.touchcomp.basementor.model.vo.FeriadoEmpresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="FERIADO")
public class Feriado
implements InterfaceVO {
    private Long identificador;
    private Short ativo = 1;
    private String descricao;
    private Integer dia = 0;
    private Integer mes = 0;
    private List<FeriadoAno> anos = new ArrayList<FeriadoAno>();
    private List<FeriadoEmpresa> empresas;
    private List<FeriadoCidade> cidades = new ArrayList<FeriadoCidade>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short todoAno = 0;
    private Short tipoFeriado = 1;

    public Feriado() {
        this.empresas = new ArrayList<FeriadoEmpresa>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_FERIADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_FERIADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DIA")
    public Integer getDia() {
        return this.dia;
    }

    public void setDia(Integer dia) {
        this.dia = dia;
    }

    @Column(name="MES")
    public Integer getMes() {
        return this.mes;
    }

    public void setMes(Integer mes) {
        this.mes = mes;
    }

    @OneToMany(mappedBy="feriado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FeriadoAno> getAnos() {
        return this.anos;
    }

    public void setAnos(List<FeriadoAno> anos) {
        this.anos = anos;
    }

    @OneToMany(mappedBy="feriado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FeriadoEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<FeriadoEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TODO_ANO")
    public Short getTodoAno() {
        return this.todoAno;
    }

    public void setTodoAno(Short todoAno) {
        this.todoAno = todoAno;
    }

    @OneToMany(mappedBy="feriado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FeriadoCidade> getCidades() {
        return this.cidades;
    }

    public void setCidades(List<FeriadoCidade> cidades) {
        this.cidades = cidades;
    }

    @Column(name="TIPO_FERIADO")
    public Short getTipoFeriado() {
        return this.tipoFeriado;
    }

    public void setTipoFeriado(Short tipoFeriado) {
        this.tipoFeriado = tipoFeriado;
    }
}

