/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRADE_ITEM_NOTA_PROPRIA")
public class GradeItemNotaFiscalPropria
implements InterfaceVO {
    private Long identificador;
    private Double quantidade;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private ItemNotaFiscalPropria itemNotaFiscalPropria;
    private Short movimentacaoFisica;
    private Short entradaSaida;
    private Double valorCusto;
    private Date dataEntradaSaida;
    private CentroEstoque centroEstoque;
    private EstoqueTerceiros estoqueTerceiros;
    private Empresa empresa;
    private Double fatorConversao;
    private Double valorTransfFiscal;
    private Double valorUltPrecoCompra;

    public GradeItemNotaFiscalPropria() {
        this.quantidade = 0.0;
        this.valorCusto = 0.0;
        this.valorTransfFiscal = 0.0;
        this.valorUltPrecoCompra = 0.0;
        this.movimentacaoFisica = 0;
        this.entradaSaida = 1;
        this.fatorConversao = 1.0;
    }

    public GradeItemNotaFiscalPropria(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
        this.quantidade = 0.0;
        this.valorCusto = 0.0;
        this.valorTransfFiscal = 0.0;
        this.valorUltPrecoCompra = 0.0;
        this.movimentacaoFisica = 0;
        this.entradaSaida = 1;
        this.fatorConversao = 1.0;
    }

    @Id
    @Column(nullable=false, name="ID_GRADE_ITEM_NOTA_PROPRIA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRADE_ITEM_NOTA_PROPRIA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="QUANTIDADE", precision=15, scale=6)
    public Double getQuantidade() {
        return this.quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NOTA_PROPRIA_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NOTA_PROPRIA_LT"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NOTA_PROPRIA_IT"))
    public ItemNotaFiscalPropria getItemNotaFiscalPropria() {
        return this.itemNotaFiscalPropria;
    }

    @Column(name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    @Column(nullable=false, name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    @Column(name="DATA_ENTRADA_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public void setItemNotaFiscalPropria(ItemNotaFiscalPropria itemNotaFiscalPropria) {
        this.itemNotaFiscalPropria = itemNotaFiscalPropria;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NOTA_PROPRIA_CE"), updatable=false)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToOne(mappedBy="gradeItemNotaPropria", targetEntity=EstoqueTerceiros.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public EstoqueTerceiros getEstoqueTerceiros() {
        return this.estoqueTerceiros;
    }

    public void setEstoqueTerceiros(EstoqueTerceiros estoqueTerceiros) {
        this.estoqueTerceiros = estoqueTerceiros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_GRADE_ITEM_NOTA_PROPRIA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="FATOR_CONVERSAO", precision=15, scale=6)
    public Double getFatorConversao() {
        return this.fatorConversao;
    }

    public void setFatorConversao(Double fatorConversao) {
        this.fatorConversao = fatorConversao;
    }

    @Column(name="ENTRADA_SAIDA")
    public Short getEntradaSaida() {
        return this.entradaSaida;
    }

    public void setEntradaSaida(Short entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    @Column(name="VALOR_TRANSF_FISCAL", precision=15, scale=6)
    public Double getValorTransfFiscal() {
        return this.valorTransfFiscal;
    }

    public void setValorTransfFiscal(Double valorTransfFiscal) {
        this.valorTransfFiscal = valorTransfFiscal;
    }

    @Column(name="VALOR_ULT_PRECO_COMPRA", precision=15, scale=6)
    public Double getValorUltPrecoCompra() {
        return this.valorUltPrecoCompra;
    }

    public void setValorUltPrecoCompra(Double valorUltPrecoCompra) {
        this.valorUltPrecoCompra = valorUltPrecoCompra;
    }
}

