/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BaixaTituloAntecipado;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.FormasPagCupomFiscal;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.IntegracaoBaixaTituloGrupoBaixaFormas;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.TituloBaixaCartao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="GRUPO_DE_BAIXA_FORMAS")
public class GrupoDeBaixaFormas
implements InterfaceVO {
    private Long identificador;
    private Short formaPagamento = 0;
    private List<BaixaTitulo> baixaTitulo = new ArrayList<BaixaTitulo>();
    private GrupoDeBaixa grupoBaixaCompensacao;
    private List<ChequeTerceiros> chequeTerceirosRec = new ArrayList<ChequeTerceiros>();
    private List<ChequeTerceiros> chequeTerceirosPag = new ArrayList<ChequeTerceiros>();
    private BorderoTitulos borderoTitulos;
    private ContaValores contaValor;
    private ContaValores contaValorTroco;
    private String observacaoBaixaTitulo;
    private FormasPagCupomFiscal formaPagamentoCartao;
    private List<TituloBaixaCartao> titulos;
    private List<BaixaTituloAntecipado> baixaTitulosAntecipados;
    private GrupoDeBaixa grupoDeBaixa;
    private Short agrupamento = 0;
    private List<MovimentoBancario> movimentoBancario = new ArrayList<MovimentoBancario>();
    private IntegracaoBaixaTituloGrupoBaixaFormas integracaoBaixaTituloGrupoBaixaFormas;

    public GrupoDeBaixaFormas() {
        this.titulos = new ArrayList<TituloBaixaCartao>();
        this.baixaTitulosAntecipados = new ArrayList<BaixaTituloAntecipado>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_GRUPO_DE_BAIXA_FORMAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_DE_BAIXA_FORMAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(mappedBy="grupoDeBaixaFormas", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<BaixaTitulo> getBaixaTitulo() {
        return this.baixaTitulo;
    }

    public void setBaixaTitulo(List<BaixaTitulo> baixaTitulo) {
        this.baixaTitulo = baixaTitulo;
    }

    @OneToMany(mappedBy="grupoDeBaixaFormasRec", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<ChequeTerceiros> getChequeTerceirosRec() {
        return this.chequeTerceirosRec;
    }

    public void setChequeTerceirosRec(List<ChequeTerceiros> chequeTerceiros) {
        this.chequeTerceirosRec = chequeTerceiros;
    }

    @OneToMany(mappedBy="grupoDeBaixaFormasPag", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<ChequeTerceiros> getChequeTerceirosPag() {
        return this.chequeTerceirosPag;
    }

    public void setChequeTerceirosPag(List<ChequeTerceiros> chequeTerceirosPag) {
        this.chequeTerceirosPag = chequeTerceirosPag;
    }

    @JoinColumn(name="ID_CONTA_VALOR", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_CT_VR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ContaValores getContaValor() {
        return this.contaValor;
    }

    public void setContaValor(ContaValores contaValor) {
        this.contaValor = contaValor;
    }

    @JoinColumn(name="ID_CONTA_VALOR_TROCO", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_CT_TR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ContaValores getContaValorTroco() {
        return this.contaValorTroco;
    }

    public void setContaValorTroco(ContaValores contaValorTroco) {
        this.contaValorTroco = contaValorTroco;
    }

    @Column(name="OBSERVACAO_BAIXA_TITULO", length=500)
    public String getObservacaoBaixaTitulo() {
        return this.observacaoBaixaTitulo;
    }

    public void setObservacaoBaixaTitulo(String observacaoBaixaTitulo) {
        this.observacaoBaixaTitulo = observacaoBaixaTitulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Id: ");
        sb.append(this.getGrupoDeBaixa() != null ? this.getGrupoDeBaixa().getIdentificador() : this.getIdentificador());
        sb.append("  Tipo: ");
        sb.append(this.getGrupoDeBaixa() != null && this.getGrupoDeBaixa().getPagRec().equals((short)1) ? "Recebimento" : "Pagamento");
        sb.append("  Titulos: ");
        int cont = 1;
        int size = this.getBaixaTitulo().size();
        for (BaixaTitulo b : this.getBaixaTitulo()) {
            sb.append(b.getTitulo().getIdentificador());
            if (size != cont) {
                sb.append(", ");
            }
            ++cont;
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{sb});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMA_PAGAMENTO_CARTAO", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_FP_CAR"))
    public FormasPagCupomFiscal getFormaPagamentoCartao() {
        return this.formaPagamentoCartao;
    }

    public void setFormaPagamentoCartao(FormasPagCupomFiscal formaPagamentoCartao) {
        this.formaPagamentoCartao = formaPagamentoCartao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="grupoBaixaFormas", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TituloBaixaCartao> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<TituloBaixaCartao> titulos) {
        this.titulos = titulos;
    }

    @OneToMany(mappedBy="grupoDeBaixaFormas", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BaixaTituloAntecipado> getBaixaTitulosAntecipados() {
        return this.baixaTitulosAntecipados;
    }

    public void setBaixaTitulosAntecipados(List<BaixaTituloAntecipado> baixaTitulosAntecipados) {
        this.baixaTitulosAntecipados = baixaTitulosAntecipados;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_GB"))
    public GrupoDeBaixa getGrupoDeBaixa() {
        return this.grupoDeBaixa;
    }

    public void setGrupoDeBaixa(GrupoDeBaixa grupoDeBaixa) {
        this.grupoDeBaixa = grupoDeBaixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BORDERO_TITULOS", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_BT"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public BorderoTitulos getBorderoTitulos() {
        return this.borderoTitulos;
    }

    public void setBorderoTitulos(BorderoTitulos borderoTitulos) {
        this.borderoTitulos = borderoTitulos;
    }

    @Column(name="AGRUPAMENTO")
    public Short getAgrupamento() {
        return this.agrupamento;
    }

    public void setAgrupamento(Short agrupamento) {
        this.agrupamento = agrupamento;
    }

    @Column(nullable=false, name="FORMA_PAGAMENTO")
    public Short getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(Short formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @OneToMany(mappedBy="grupoDeBaixaFormas", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<MovimentoBancario> getMovimentoBancario() {
        return this.movimentoBancario;
    }

    public void setMovimentoBancario(List<MovimentoBancario> movimentoBancario) {
        this.movimentoBancario = movimentoBancario;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_GRUPO_BAIXA_COMPENSACAO", foreignKey=@ForeignKey(name="FK_GRUPO_DE_BAIXA_FORMAS_GR_BAI"))
    public GrupoDeBaixa getGrupoBaixaCompensacao() {
        return this.grupoBaixaCompensacao;
    }

    public void setGrupoBaixaCompensacao(GrupoDeBaixa grupoBaixaCompensacao) {
        this.grupoBaixaCompensacao = grupoBaixaCompensacao;
    }

    @OneToOne(mappedBy="grupoDeBaixaFormas", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public IntegracaoBaixaTituloGrupoBaixaFormas getIntegracaoBaixaTituloGrupoBaixaFormas() {
        return this.integracaoBaixaTituloGrupoBaixaFormas;
    }

    public void setIntegracaoBaixaTituloGrupoBaixaFormas(IntegracaoBaixaTituloGrupoBaixaFormas integracaoBaixaTituloGrupoBaixaFormas) {
        this.integracaoBaixaTituloGrupoBaixaFormas = integracaoBaixaTituloGrupoBaixaFormas;
    }
}

