/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorAcessoRemoto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="GRUPO_EMPRESA")
public class GrupoEmpresa
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private ServidorAcessoRemoto servidorAcessoRemoto;
    private List<EmpresaDados> empresas = new ArrayList<EmpresaDados>();
    private List<Pessoa> sociedadesContaParticipacao = new ArrayList<Pessoa>();

    @Id
    @Column(name="ID_GRUPO_EMPRESA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_GRUPO_EMPRESA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DESCRICAO", length=50)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="grupoEmpresa", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.REFRESH})
    public List<EmpresaDados> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<EmpresaDados> empresas) {
        this.empresas = empresas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVIDOR_ACESSO_REMOTO", foreignKey=@ForeignKey(name="FK_GRUPO_EMP_SERV_ACESSO_REM"))
    public ServidorAcessoRemoto getServidorAcessoRemoto() {
        return this.servidorAcessoRemoto;
    }

    public void setServidorAcessoRemoto(ServidorAcessoRemoto servidorAcessoRemoto) {
        this.servidorAcessoRemoto = servidorAcessoRemoto;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="grupo_empresa_soc_conta_part", joinColumns={@JoinColumn(name="id_grupo_empresa")}, inverseJoinColumns={@JoinColumn(name="ID_PESSOA")})
    public List<Pessoa> getSociedadesContaParticipacao() {
        return this.sociedadesContaParticipacao;
    }

    public void setSociedadesContaParticipacao(List<Pessoa> sociedadesContaParticipacao) {
        this.sociedadesContaParticipacao = sociedadesContaParticipacao;
    }
}

