/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="IMPLANTACAO_SALDO")
public class ImplantacaoSaldos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<ItemImplantaSaldo> itemImplantaSaldo;
    private Date dataEntradaSaida;
    private String observacao;
    private WmsEntradaEstoque wmsEntradaEstoque;

    public ImplantacaoSaldos() {
        this.itemImplantaSaldo = new ArrayList<ItemImplantaSaldo>();
    }

    public ImplantacaoSaldos(Long identificador, Date data) {
        this.identificador = identificador;
        this.dataEntradaSaida = data;
        this.itemImplantaSaldo = new ArrayList<ItemImplantaSaldo>();
    }

    @Id
    @Column(name="ID_IMPLANTA_SALDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_IMPLANTACAO_SALDOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_IMPLANTACAO_SALDO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="implantacaoSaldos", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemImplantaSaldo> getItemImplantaSaldo() {
        return this.itemImplantaSaldo;
    }

    public void setItemImplantaSaldo(List<ItemImplantaSaldo> itemImplantaSaldo) {
        this.itemImplantaSaldo = itemImplantaSaldo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA_SAIDA")
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="implantacaoSaldos")
    public WmsEntradaEstoque getWmsEntradaEstoque() {
        return this.wmsEntradaEstoque;
    }

    public void setWmsEntradaEstoque(WmsEntradaEstoque wmsEntradaEstoque) {
        this.wmsEntradaEstoque = wmsEntradaEstoque;
    }
}

