/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligenceTipo;
import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoPublicidade;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoModulo;
import com.touchcomp.basementor.model.vo.ImportacaoBiClientes;
import com.touchcomp.basementor.model.vo.RepositorioBi;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Table(name="IMPORTACAO_BI")
@Entity
public class ImportacaoBi
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    private Long identificador;
    private String descricao;
    private List<RepositorioBi> repositorios = new ArrayList<RepositorioBi>();
    private String serialLocalBI;
    private String numeroControle;
    private Long numeroBI = 0L;
    private Short inativo = 0;
    private Short tipoClassificacaoBI;
    private Short tipoPublicidadeBI;
    private Short tipoRepositorioBI;
    private List<ImportacaoBiClientes> clientesVinculados = new ArrayList<ImportacaoBiClientes>();
    private String observacoes;
    private String motivoInativacao;
    private ClassificacaoModulo classificacaoModulo;
    private String documentacao;
    private String wiki;
    private Short scoreDestaque = 0;

    public ImportacaoBi() {
        this.tipoPublicidadeBI = EnumConstBITipoPublicidade.BI_PUBLICO.getValue();
        this.tipoClassificacaoBI = EnumConstBusinessIntelligenceTipo.RELATORIO_LISTAGEM.getValue();
        this.tipoRepositorioBI = EnumConstTipoRepositorioBI.BI.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_IMPORTACAO_BI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_IMPORTACAO_BI")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=5000)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="importacaoBi")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OrderBy(value="numeroVersao")
    public List<RepositorioBi> getRepositorios() {
        return this.repositorios;
    }

    public void setRepositorios(List<RepositorioBi> repositorios) {
        this.repositorios = repositorios;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SERIAL_LOCAL_BI", length=34)
    public String getSerialLocalBI() {
        return this.serialLocalBI;
    }

    public void setSerialLocalBI(String serialLocalBI) {
        this.serialLocalBI = serialLocalBI;
    }

    @Column(name="NUMERO_CONTROLE", length=20)
    public String getNumeroControle() {
        return this.numeroControle;
    }

    public void setNumeroControle(String numeroControle) {
        this.numeroControle = numeroControle;
    }

    @Column(name="INATIVO")
    public Short getInativo() {
        return this.inativo;
    }

    public void setInativo(Short inativo) {
        this.inativo = inativo;
    }

    @Column(name="NUMERO_BI")
    public Long getNumeroBI() {
        return this.numeroBI;
    }

    public void setNumeroBI(Long numeroBI) {
        this.numeroBI = numeroBI;
    }

    @Column(name="TIPO_CLASSIFICACAO_BI")
    public Short getTipoClassificacaoBI() {
        return this.tipoClassificacaoBI;
    }

    public void setTipoClassificacaoBI(Short tipoClassificacaoBI) {
        this.tipoClassificacaoBI = tipoClassificacaoBI;
    }

    @Column(name="TIPO_PUBLICIDADE_BI")
    public Short getTipoPublicidadeBI() {
        return this.tipoPublicidadeBI;
    }

    public void setTipoPublicidadeBI(Short tipoPublicidadeBI) {
        this.tipoPublicidadeBI = tipoPublicidadeBI;
    }

    @OneToMany(mappedBy="importacaoBI", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ImportacaoBiClientes> getClientesVinculados() {
        return this.clientesVinculados;
    }

    public void setClientesVinculados(List<ImportacaoBiClientes> clientesVinculados) {
        this.clientesVinculados = clientesVinculados;
    }

    @Column(name="OBSERVACOES")
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="MOTIVO_INATIVACAO")
    public String getMotivoInativacao() {
        return this.motivoInativacao;
    }

    public void setMotivoInativacao(String motivoInativacao) {
        this.motivoInativacao = motivoInativacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_MODULO")
    public ClassificacaoModulo getClassificacaoModulo() {
        return this.classificacaoModulo;
    }

    public void setClassificacaoModulo(ClassificacaoModulo classificacaoModulo) {
        this.classificacaoModulo = classificacaoModulo;
    }

    @Column(name="TIPO_REPOSITORIO_BI")
    public Short getTipoRepositorioBI() {
        return this.tipoRepositorioBI;
    }

    public void setTipoRepositorioBI(Short tipoRepositorioBI) {
        this.tipoRepositorioBI = tipoRepositorioBI;
    }

    @Column(name="DOCUMENTACAO")
    public String getDocumentacao() {
        return this.documentacao;
    }

    public void setDocumentacao(String documentacao) {
        this.documentacao = documentacao;
    }

    @Column(name="WIKI")
    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    @Column(name="SCORE_DESTAQUE")
    public Short getScoreDestaque() {
        return this.scoreDestaque;
    }

    public void setScoreDestaque(Short scoreDestaque) {
        this.scoreDestaque = scoreDestaque;
    }
}

