/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.DiaSemana;
import com.touchcomp.basementor.model.vo.EsocCadastroHorario;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="INFO_HORARIO_TRABALHO")
public class InfoHorarioTrabalho
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date horarioInicial;
    private Date inicioIntervalo;
    private Date finalIntervalo;
    private Date horarioFinal;
    private Short folga;
    private Double totalHoras;
    private DiaSemana diaSemana;
    private String codigoEsocial;
    private EsocCadastroHorario esocCadastroHorario;
    private Double totalIntervalo;
    private Short enviarEsocial;
    private List<EsocPreEvento> preEventosEsocial;
    private Short informarCodigoEsocial;
    private Short diaCompensado;
    private Short indice;
    private EsocCadastroHorario esocAux;

    public InfoHorarioTrabalho() {
        this.folga = 0;
        this.totalHoras = 0.0;
        this.totalIntervalo = 0.0;
        this.preEventosEsocial = new ArrayList<EsocPreEvento>();
        this.enviarEsocial = 1;
        this.informarCodigoEsocial = 0;
        this.informarCodigoEsocial = 0;
        this.diaCompensado = 0;
        this.indice = 0;
    }

    public InfoHorarioTrabalho(DiaSemana diaSemana, Short folga) {
        this.folga = folga;
        this.diaSemana = diaSemana;
        this.horarioInicial = ToolDate.dataSemHora((Date)new Date());
        this.horarioFinal = ToolDate.dataSemHora((Date)new Date());
        this.inicioIntervalo = ToolDate.dataSemHora((Date)new Date());
        this.finalIntervalo = ToolDate.dataSemHora((Date)new Date());
        this.totalHoras = 0.0;
        this.totalIntervalo = 0.0;
        this.enviarEsocial = 0;
        this.informarCodigoEsocial = 0;
        this.diaCompensado = 0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_INFO_HORARIO_TRABALHO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INFO_HORARIO_TRABALHO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="HORARIO_INICIAL")
    public Date getHorarioInicial() {
        return this.horarioInicial;
    }

    public void setHorarioInicial(Date horarioInicial) {
        this.horarioInicial = horarioInicial;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="INICIO_INTERVALO")
    public Date getInicioIntervalo() {
        return this.inicioIntervalo;
    }

    public void setInicioIntervalo(Date inicioIntervalo) {
        this.inicioIntervalo = inicioIntervalo;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="FINAL_INTERVALO")
    public Date getFinalIntervalo() {
        return this.finalIntervalo;
    }

    public void setFinalIntervalo(Date finalIntervalo) {
        this.finalIntervalo = finalIntervalo;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="HORARIO_FINAL")
    public Date getHorarioFinal() {
        return this.horarioFinal;
    }

    public void setHorarioFinal(Date horarioFinal) {
        this.horarioFinal = horarioFinal;
    }

    @Column(name="FOLGA")
    public Short getFolga() {
        return this.folga;
    }

    public void setFolga(Short folga) {
        this.folga = folga;
    }

    @Column(name="TOTAL_HORAS", precision=15, scale=2)
    public Double getTotalHoras() {
        return this.totalHoras;
    }

    public void setTotalHoras(Double totalHoras) {
        this.totalHoras = totalHoras;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_DIA_SEMANA", foreignKey=@ForeignKey(name="FK_HORARIO_DIA_SEMANA"))
    public DiaSemana getDiaSemana() {
        return this.diaSemana;
    }

    public void setDiaSemana(DiaSemana diaSemana) {
        this.diaSemana = diaSemana;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIndice(), this.getDiaSemana() != null ? this.getDiaSemana().getDescricao() : this.getDiaSemana()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CODIGO_E_SOCIAL", length=50)
    public String getCodigoEsocial() {
        return this.codigoEsocial;
    }

    public void setCodigoEsocial(String codigoEsocial) {
        this.codigoEsocial = codigoEsocial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CAD_HORARIO", foreignKey=@ForeignKey(name="FK_ESOC_CADASTRO_HORARIO_HOR"))
    public EsocCadastroHorario getEsocCadastroHorario() {
        return this.esocCadastroHorario;
    }

    public void setEsocCadastroHorario(EsocCadastroHorario esocCadastroHorario) {
        this.esocCadastroHorario = esocCadastroHorario;
    }

    @Column(name="TOTAL_INTERVALO", precision=15, scale=2)
    public Double getTotalIntervalo() {
        return this.totalIntervalo;
    }

    public void setTotalIntervalo(Double totalIntervalo) {
        this.totalIntervalo = totalIntervalo;
    }

    @Column(name="ENVIAR_E_SOCIAL")
    public Short getEnviarEsocial() {
        return this.enviarEsocial;
    }

    public void setEnviarEsocial(Short enviarEsocial) {
        this.enviarEsocial = enviarEsocial;
    }

    public InfoHorarioTrabalho(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Override
    @OneToMany(mappedBy="infoHorario")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @OneToOne(mappedBy="infoHorario")
    public EsocCadastroHorario getEsocAux() {
        return this.esocAux;
    }

    public void setEsocAux(EsocCadastroHorario esocAux) {
        this.esocAux = esocAux;
    }

    @Column(name="INFORMAR_CODIGO_ESOCIAL")
    public Short getInformarCodigoEsocial() {
        return this.informarCodigoEsocial;
    }

    public void setInformarCodigoEsocial(Short informarCodigoEsocial) {
        this.informarCodigoEsocial = informarCodigoEsocial;
    }

    @Column(name="dia_compensado")
    public Short getDiaCompensado() {
        return this.diaCompensado;
    }

    public void setDiaCompensado(Short diaCompensado) {
        this.diaCompensado = diaCompensado;
    }

    @Column(name="indice")
    public Short getIndice() {
        return this.indice;
    }

    public void setIndice(Short indice) {
        this.indice = indice;
    }
}

