/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.IntegComProdItemComunicadoProd;
import com.touchcomp.basementor.model.vo.IntegComProdItemLancCentroCustro;
import com.touchcomp.basementor.model.vo.IntegComProdItemLancCtbGerencial;
import com.touchcomp.basementor.model.vo.IntegracaoComunicadoProducao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="INTEGRACAO_COM_PRODUCAO_ITEM")
public class IntegracaoComProducaoItem
implements InterfaceVO {
    private Long identificador;
    private Date dataLote;
    private LoteContabil loteContabil;
    private IntegracaoComunicadoProducao integracaoComunicadoProd;
    private List<IntegComProdItemLancCentroCustro> lancamentosCentroCusto = new LinkedList<IntegComProdItemLancCentroCustro>();
    private List<IntegComProdItemLancCtbGerencial> lancamentosCtbGerencial = new LinkedList<IntegComProdItemLancCtbGerencial>();
    private List<IntegComProdItemComunicadoProd> comunicadosProducao = new LinkedList<IntegComProdItemComunicadoProd>();

    @Id
    @Column(name="ID_INTEGRACAO_COM_PRODUCAO_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INTEGRACAO_COM_PRODUCAO_ITE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_LOTE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLote() {
        return this.dataLote;
    }

    public void setDataLote(Date dataLote) {
        this.dataLote = dataLote;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_INTEGRACAO_COM_PROD_IT_LT_CO"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INTEGRACAO_COM_PROD", foreignKey=@ForeignKey(name="FK_INTEGRACAO_COM_PROD_IT_INTEG"))
    public IntegracaoComunicadoProducao getIntegracaoComunicadoProd() {
        return this.integracaoComunicadoProd;
    }

    public void setIntegracaoComunicadoProd(IntegracaoComunicadoProducao integracaoComunicadoProd) {
        this.integracaoComunicadoProd = integracaoComunicadoProd;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}:{2}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.dataLote), this.getLoteContabil() != null ? this.getLoteContabil().getNumeroLote() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="integracaoComProducaoItem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<IntegComProdItemLancCentroCustro> getLancamentosCentroCusto() {
        return this.lancamentosCentroCusto;
    }

    public void setLancamentosCentroCusto(List<IntegComProdItemLancCentroCustro> lancamentosCentroCusto) {
        this.lancamentosCentroCusto = lancamentosCentroCusto;
    }

    @OneToMany(mappedBy="integracaoComProducaoItem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<IntegComProdItemLancCtbGerencial> getLancamentosCtbGerencial() {
        return this.lancamentosCtbGerencial;
    }

    public void setLancamentosCtbGerencial(List<IntegComProdItemLancCtbGerencial> lancamentosCtbGerencial) {
        this.lancamentosCtbGerencial = lancamentosCtbGerencial;
    }

    @OneToMany(mappedBy="integracaoComProducaoItem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<IntegComProdItemComunicadoProd> getComunicadosProducao() {
        return this.comunicadosProducao;
    }

    public void setComunicadosProducao(List<IntegComProdItemComunicadoProd> comunicadosProducao) {
        this.comunicadosProducao = comunicadosProducao;
    }
}

