/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ProvisaoFerias;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="INTEGRACAO_PROV_FERIAS")
public class IntegracaoProvisaoFerias
implements InterfaceVO {
    private Long identificador;
    private List<ProvisaoFerias> provisaoFerias = new ArrayList<ProvisaoFerias>();
    private Date periodoInicial;
    private Date periodoFinal;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;

    @Id
    @Column(name="ID_INTEGRACAO_PROV_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INTEGRACAO_PROV_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToMany(targetEntity=ProvisaoFerias.class)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    @JoinTable(name="INTEGRACAO_PROV_FERIAS_PROVISOE", joinColumns={@JoinColumn(name="ID_INTEGRACAO_PROV_FERIAS")}, inverseJoinColumns={@JoinColumn(name="ID_PROVISAO_FERIAS")})
    public List<ProvisaoFerias> getProvisaoFerias() {
        return this.provisaoFerias;
    }

    public void setProvisaoFerias(List<ProvisaoFerias> provisaoFerias) {
        this.provisaoFerias = provisaoFerias;
    }

    @Column(name="PERIODO_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Column(name="PERIODO_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_INTEGRACAO_PROV_FERIAS_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} a {1}", (Object[])new Object[]{ToolDate.dateToStr((Date)this.getPeriodoInicial()), ToolDate.dateToStr((Date)this.getPeriodoFinal())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

