/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.InfCompInventarioSped;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SpedFiscal;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="INVENTARIO_SPED")
public class InventarioSped
implements InterfaceVO {
    private Long identificador;
    private Double vlrUnitario = 0.0;
    private Double vlrItem = 0.0;
    private Short indicadorPropriedade = 0;
    private Double quantidade = 0.0;
    private Pessoa pessoa;
    private String descricaoComplementar;
    private Produto produto;
    private PlanoConta planoConta;
    private List<InfCompInventarioSped> infComplInventario = new ArrayList<InfCompInventarioSped>();
    private SpedFiscal spedFiscal;

    @Id
    @Column(name="ID_INVENTARIO_SPED")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_INVENTARIO_SPED")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="VLR_UNITARIO", precision=15, scale=6)
    public Double getVlrUnitario() {
        return this.vlrUnitario;
    }

    public void setVlrUnitario(Double vlrUnitario) {
        this.vlrUnitario = vlrUnitario;
    }

    @Column(name="VLR_ITEM", precision=15, scale=2)
    public Double getVlrItem() {
        return this.vlrItem;
    }

    public void setVlrItem(Double vlrItem) {
        this.vlrItem = vlrItem;
    }

    @Column(name="INDICADOR_PROPRIEDADE")
    public Short getIndicadorPropriedade() {
        return this.indicadorPropriedade;
    }

    public void setIndicadorPropriedade(Short indicadorPropriedade) {
        this.indicadorPropriedade = indicadorPropriedade;
    }

    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_INVENTARIO_SPED_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="DESCRICAO_COMPLEMENTAR")
    public String getDescricaoComplementar() {
        return this.descricaoComplementar;
    }

    public void setDescricaoComplementar(String descricaoComplementar) {
        this.descricaoComplementar = descricaoComplementar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_INVENTARIO_SPED_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_INVENTARIO_SPED_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @OneToMany(mappedBy="inventarioSped")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<InfCompInventarioSped> getInfComplInventario() {
        return this.infComplInventario;
    }

    public void setInfComplInventario(List<InfCompInventarioSped> infComplInventario) {
        this.infComplInventario = infComplInventario;
    }

    @Column(nullable=false, name="QUANTIDADE", precision=15, scale=3)
    public Double getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Double quantidade) {
        this.quantidade = quantidade;
    }

    @JoinColumn(name="ID_SPED_FISCAL", foreignKey=@ForeignKey(name="FK_INVENTARIO_SPED_SPED_FISCAL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SpedFiscal getSpedFiscal() {
        return this.spedFiscal;
    }

    public void setSpedFiscal(SpedFiscal spedFiscal) {
        this.spedFiscal = spedFiscal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

