/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_APURACIDADE_ESTOQUE")
public class ItemApuracidadeEstoque
implements InterfaceVO {
    private Long identificador;
    private ApuracidadeEstoque apuracidadeEstoque;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private Double quantidadeInicial = 0.0;
    private Double quantidadeFinal = 0.0;
    private Double precoMedioInicial = 0.0;
    private Double precoMedioFinal = 0.0;
    private Double apuracidadeItem = 100.0;
    private NaturezaRequisicao naturezaRequisicao;

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_APURACIDADE_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_APURACIDADE_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACIDADE_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_APUR_ESTOQUE_APUR_EST"))
    public ApuracidadeEstoque getApuracidadeEstoque() {
        return this.apuracidadeEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_ITEM_APUR_ESTOQUE_GRADE_COR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_ITEM_APUR_ESTOQUE_LOTE_FAB"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    @Column(name="QUANTIDADE_INICIAL", precision=15, scale=6)
    public Double getQuantidadeInicial() {
        return this.quantidadeInicial;
    }

    @Column(nullable=false, name="QUANTIDADE_FINAL", precision=15, scale=6)
    public Double getQuantidadeFinal() {
        return this.quantidadeFinal;
    }

    @Column(name="PRECO_MEDIO_INICIAL", precision=15, scale=6)
    public Double getPrecoMedioInicial() {
        return this.precoMedioInicial;
    }

    @Column(name="PRECO_MEDIO_FINAL", precision=15, scale=6)
    public Double getPrecoMedioFinal() {
        return this.precoMedioFinal;
    }

    @Column(nullable=false, name="APURACIDADE_ITEM", precision=15, scale=6)
    public Double getApuracidadeItem() {
        return this.apuracidadeItem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_APUR_ESTOQUE_NAT_REQ"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setApuracidadeEstoque(ApuracidadeEstoque apuracidadeEstoque) {
        this.apuracidadeEstoque = apuracidadeEstoque;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    public void setQuantidadeInicial(Double quantidadeInicial) {
        this.quantidadeInicial = quantidadeInicial;
    }

    public void setQuantidadeFinal(Double quantidadeFinal) {
        this.quantidadeFinal = quantidadeFinal;
    }

    public void setPrecoMedioInicial(Double precoMedioInicial) {
        this.precoMedioInicial = precoMedioInicial;
    }

    public void setPrecoMedioFinal(Double precoMedioFinal) {
        this.precoMedioFinal = precoMedioFinal;
    }

    public void setApuracidadeItem(Double apuracidadeItem) {
        this.apuracidadeItem = apuracidadeItem;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

