/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstTipoTabelaPreco;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AvaliadorExpFormulas;
import com.touchcomp.basementor.model.vo.CotacaoVendas;
import com.touchcomp.basementor.model.vo.GradeItemCotVendas;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendasFiscal;
import com.touchcomp.basementor.model.vo.ItemCotacaoVendasModFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_COTACAO_VENDAS")
public class ItemCotacaoVendas
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private List<GradeItemCotVendas> grade = new ArrayList<GradeItemCotVendas>();
    private UnidadeMedida unidadeMedida;
    private CotacaoVendas cotacaoVendas;
    private Double quantidadeTotal = 0.0;
    private Double valorUnitario = 0.0;
    private Double valorFrete = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotalBruto = 0.0;
    private Double valorTotal = 0.0;
    private Double percComissao = 0.0;
    private Double percDesconto = 0.0;
    private Double percFrete = 0.0;
    private Double percDespesaAcessoria = 0.0;
    private Double percSeguro = 0.0;
    private Double valorDespesaAcessoria = 0.0;
    private Double valorSeguro = 0.0;
    private Double valorCusto = 0.0;
    private Double valorMinimo = 0.0;
    private Double valorMaximo = 0.0;
    private Double valorSugerido = 0.0;
    private ModeloFiscal modeloFiscal;
    private String infAdicional;
    private ItemCotacaoVendasFiscal itemCotacaoVendasFiscal;
    private Integer numeroItem = 0;
    private Double valorTotalComImpostos = 0.0;
    private Short descontoItem = 0;
    private Short despAcessItem = 0;
    private Short seguroItem = 0;
    private Short freteItem = 0;
    private Short tipoDesconto = 1;
    private Short tipoFrete = 1;
    private Short tipoSeguro = 1;
    private Short tipoDespAcessoria = 1;
    private Short opcional = 0;
    private Long prazoEntrega = 0L;
    private List<ItemCotacaoVendasModFichaTecnica> itensModFichaTecnica = new ArrayList<ItemCotacaoVendasModFichaTecnica>();
    private ModeloFichaTecnica modeloFichaTecnica;
    private AvaliadorExpFormulas formTabDinCalcPreco;
    private AvaliadorExpFormulas formTabDinCalcComissao;
    private Short tipoTabPreco = EnumConstTipoTabelaPreco.TABELA_BASE.getValue();
    private TipoFrete tipoDeFrete;
    private AnalisePrVendaProd analisePrecoVenda;
    private ParamTribCbsIbsClass paramTribCbsIbsClass;

    @Id
    @Column(name="ID_ITEM_COTACAO_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_COTACAO_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_PROD"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="itemCotacaoVendas")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GradeItemCotVendas> getGrade() {
        return this.grade;
    }

    public void setGrade(List<GradeItemCotVendas> grade) {
        this.grade = grade;
        if (grade != null) {
            Double qtdTotal = 0.0;
            Iterator<GradeItemCotVendas> iterator = grade.iterator();
            while (iterator.hasNext()) {
                GradeItemCotVendas o;
                GradeItemCotVendas g = o = iterator.next();
                qtdTotal = qtdTotal + g.getQuantidade();
            }
            this.setQuantidadeTotal(qtdTotal);
        } else {
            this.setQuantidadeTotal(0.0);
        }
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_UN_MED"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    @Column(name="OPCIONAL")
    public Short getOpcional() {
        return this.opcional;
    }

    public void setOpcional(Short opcional) {
        this.opcional = opcional;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COTACAO_VENDAS", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_CO_VENDA"))
    public CotacaoVendas getCotacaoVendas() {
        return this.cotacaoVendas;
    }

    public void setCotacaoVendas(CotacaoVendas cotacaoVendas) {
        this.cotacaoVendas = cotacaoVendas;
    }

    @Column(name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    @Column(nullable=false, name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(nullable=false, name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(nullable=false, name="VALOR_TOTAL_BRUTO", precision=15, scale=2)
    public Double getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Column(nullable=false, name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorTotalBruto(Double valorTotalBruto) {
        this.valorTotalBruto = valorTotalBruto;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @Column(nullable=false, name="PERC_DESCONTO", precision=15, scale=4)
    public Double getPercDesconto() {
        return this.percDesconto;
    }

    public void setPercDesconto(Double percDesconto) {
        this.percDesconto = percDesconto;
    }

    @Column(nullable=false, name="PERC_FRETE", precision=15, scale=4)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(nullable=false, name="PERC_DESP_ACESSORIA", precision=15, scale=4)
    public Double getPercDespesaAcessoria() {
        return this.percDespesaAcessoria;
    }

    public void setPercDespesaAcessoria(Double percDespesaAcessoria) {
        this.percDespesaAcessoria = percDespesaAcessoria;
    }

    @Column(nullable=false, name="PERC_SEGURO", precision=15, scale=4)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Column(nullable=false, name="VALOR_DESP_ACESSORIA", precision=15, scale=2)
    public Double getValorDespesaAcessoria() {
        return this.valorDespesaAcessoria;
    }

    public void setValorDespesaAcessoria(Double valorDespesaAcessoria) {
        this.valorDespesaAcessoria = valorDespesaAcessoria;
    }

    @Column(nullable=false, name="VALOR_SEGURO", precision=15, scale=2)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    public void setValorSeguro(Double ValorSeguro) {
        this.valorSeguro = ValorSeguro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getCotacaoVendas() != null ? ToolBaseMethodsVO.toString((String)"Cotacao: {0}  Item: {1}", (Object[])new Object[]{this.getCotacaoVendas().getIdentificador(), this.getIdentificador()}) : ToolBaseMethodsVO.toString((String)"Item: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_MODELO_FISCAL", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_MOD_FISC"))
    public ModeloFiscal getModeloFiscal() {
        return this.modeloFiscal;
    }

    public void setModeloFiscal(ModeloFiscal modeloFiscal) {
        this.modeloFiscal = modeloFiscal;
    }

    @Column(nullable=false, name="VALOR_MINIMO", precision=15, scale=2)
    public Double getValorMinimo() {
        return this.valorMinimo;
    }

    public void setValorMinimo(Double valorMinimo) {
        this.valorMinimo = valorMinimo;
    }

    @Column(nullable=false, name="VALOR_MAXIMO", precision=15, scale=2)
    public Double getValorMaximo() {
        return this.valorMaximo;
    }

    public void setValorMaximo(Double valorMaximo) {
        this.valorMaximo = valorMaximo;
    }

    @Column(nullable=false, name="VALOR_SUGERIDO", precision=15, scale=2)
    public Double getValorSugerido() {
        return this.valorSugerido;
    }

    public void setValorSugerido(Double valorSugerido) {
        this.valorSugerido = valorSugerido;
    }

    @Column(name="INF_ADICIONAL", length=10000)
    public String getInfAdicional() {
        return this.infAdicional;
    }

    public void setInfAdicional(String infAdicional) {
        this.infAdicional = infAdicional;
    }

    @OneToOne(mappedBy="itemCotacaoVendas", targetEntity=ItemCotacaoVendasFiscal.class, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public ItemCotacaoVendasFiscal getItemCotacaoVendasFiscal() {
        return this.itemCotacaoVendasFiscal;
    }

    public void setItemCotacaoVendasFiscal(ItemCotacaoVendasFiscal itemCotacaoVendasFiscal) {
        this.itemCotacaoVendasFiscal = itemCotacaoVendasFiscal;
    }

    @Column(name="NUMERO_ITEM")
    public Integer getNumeroItem() {
        return this.numeroItem;
    }

    public void setNumeroItem(Integer numeroItem) {
        this.numeroItem = numeroItem;
    }

    @Column(name="DESCONTO_ITEM")
    public Short getDescontoItem() {
        return this.descontoItem;
    }

    public void setDescontoItem(Short descontoItem) {
        this.descontoItem = descontoItem;
    }

    @Column(name="DESP_ACESS_ITEM")
    public Short getDespAcessItem() {
        return this.despAcessItem;
    }

    public void setDespAcessItem(Short despAcessItem) {
        this.despAcessItem = despAcessItem;
    }

    @Column(name="SEGURO_ITEM")
    public Short getSeguroItem() {
        return this.seguroItem;
    }

    public void setSeguroItem(Short seguroItem) {
        this.seguroItem = seguroItem;
    }

    @Column(name="FRETE_ITEM")
    public Short getFreteItem() {
        return this.freteItem;
    }

    public void setFreteItem(Short freteItem) {
        this.freteItem = freteItem;
    }

    @Column(name="TIPO_DESCONTO")
    public Short getTipoDesconto() {
        return this.tipoDesconto;
    }

    public void setTipoDesconto(Short tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Column(name="TIPO_FRETE")
    public Short getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(Short tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="TIPO_SEGURO")
    public Short getTipoSeguro() {
        return this.tipoSeguro;
    }

    public void setTipoSeguro(Short tipoSeguro) {
        this.tipoSeguro = tipoSeguro;
    }

    @Column(name="TIPO_DESP_ACESSORIA")
    public Short getTipoDespAcessoria() {
        return this.tipoDespAcessoria;
    }

    public void setTipoDespAcessoria(Short tipoDespAcessoria) {
        this.tipoDespAcessoria = tipoDespAcessoria;
    }

    @Column(name="VALOR_TOTAL_COM_IMPOSTOS", precision=15, scale=2)
    public Double getValorTotalComImpostos() {
        return this.valorTotalComImpostos;
    }

    public void setValorTotalComImpostos(Double valorTotalComImpostos) {
        this.valorTotalComImpostos = valorTotalComImpostos;
    }

    @Column(name="PRAZO_ENTREGA")
    public Long getPrazoEntrega() {
        return this.prazoEntrega;
    }

    public void setPrazoEntrega(Long prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    @OneToMany(mappedBy="itemCotacaoVendas")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemCotacaoVendasModFichaTecnica> getItensModFichaTecnica() {
        return this.itensModFichaTecnica;
    }

    public void setItensModFichaTecnica(List<ItemCotacaoVendasModFichaTecnica> itensModFichaTecnica) {
        this.itensModFichaTecnica = itensModFichaTecnica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FICHA_TECNICA", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_FICHA_TE"))
    public ModeloFichaTecnica getModeloFichaTecnica() {
        return this.modeloFichaTecnica;
    }

    public void setModeloFichaTecnica(ModeloFichaTecnica modeloFichaTecnica) {
        this.modeloFichaTecnica = modeloFichaTecnica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORM_TAB_DIN_CALC_PRECO", foreignKey=@ForeignKey(name="FK_ITEM_COT_VEND_FORM_D_CALC_PR"))
    public AvaliadorExpFormulas getFormTabDinCalcPreco() {
        return this.formTabDinCalcPreco;
    }

    public void setFormTabDinCalcPreco(AvaliadorExpFormulas formTabDinCalcPreco) {
        this.formTabDinCalcPreco = formTabDinCalcPreco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORM_TAB_DIN_CALC_COMIS", foreignKey=@ForeignKey(name="FK_ITEM_COT_VEND_FORM_D_CALC_CO"))
    public AvaliadorExpFormulas getFormTabDinCalcComissao() {
        return this.formTabDinCalcComissao;
    }

    public void setFormTabDinCalcComissao(AvaliadorExpFormulas formTabDinCalcComissao) {
        this.formTabDinCalcComissao = formTabDinCalcComissao;
    }

    @Column(name="TIPO_TAB_PRECO")
    public Short getTipoTabPreco() {
        return this.tipoTabPreco;
    }

    public void setTipoTabPreco(Short tipoTabPreco) {
        this.tipoTabPreco = tipoTabPreco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_ITEM_COT_VENDAS_TIPO_FRETE"))
    public TipoFrete getTipoDeFrete() {
        return this.tipoDeFrete;
    }

    public void setTipoDeFrete(TipoFrete tipoDeFrete) {
        this.tipoDeFrete = tipoDeFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_ANALISE_PRECO_VENDA", foreignKey=@ForeignKey(name="FK_ITEM_COTACAO_VENDAS_ANA_PR_V"))
    public AnalisePrVendaProd getAnalisePrecoVenda() {
        return this.analisePrecoVenda;
    }

    public void setAnalisePrecoVenda(AnalisePrVendaProd analisePrecoVenda) {
        this.analisePrecoVenda = analisePrecoVenda;
    }

    @Column(name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_PARAM_TRIB_CBS_IBS_CLASS")
    public ParamTribCbsIbsClass getParamTribCbsIbsClass() {
        return this.paramTribCbsIbsClass;
    }

    public void setParamTribCbsIbsClass(ParamTribCbsIbsClass paramTribCbsIbsClass) {
        this.paramTribCbsIbsClass = paramTribCbsIbsClass;
    }
}

