/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.LancamentoRubricaEmFolha;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ITEM_LANCAMENTO_RUBRICA")
public class ItemLancamentoRubrica
implements InterfaceVO {
    private Long identificador;
    private LancamentoRubricaEmFolha lancamentoRubrica;
    private Double valorReferencia;
    private String historico;
    private Short reprocessarFolha;
    private Colaborador colaborador;

    public ItemLancamentoRubrica(Double valorReferencia, Colaborador colaborador, String historico) {
        this.valorReferencia = valorReferencia;
        this.colaborador = colaborador;
        this.reprocessarFolha = 0;
        this.historico = historico;
    }

    public ItemLancamentoRubrica() {
        this.valorReferencia = 0.0;
        this.reprocessarFolha = 0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_LANC_RUBRICA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_LANC_RUBRICA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANCAMENTO_RUBRICA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_RUBRICA_ITEM"))
    public LancamentoRubricaEmFolha getLancamentoRubrica() {
        return this.lancamentoRubrica;
    }

    public void setLancamentoRubrica(LancamentoRubricaEmFolha lancamentoRubrica) {
        this.lancamentoRubrica = lancamentoRubrica;
    }

    @Column(name="VALOR_REFERENCIA", precision=15, scale=2)
    public Double getValorReferencia() {
        return this.valorReferencia;
    }

    public void setValorReferencia(Double valorReferencia) {
        this.valorReferencia = valorReferencia;
    }

    @Column(name="HISTORICO", length=100)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="REPROCESSAR_FOLHA")
    public Short getReprocessarFolha() {
        return this.reprocessarFolha;
    }

    public void setReprocessarFolha(Short reprocessarFolha) {
        this.reprocessarFolha = reprocessarFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_COLABORADOR_ITEM_LANC_RUBRIC"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }
}

