/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.PontoColaborador;
import com.touchcomp.basementor.model.vo.TipoOcorrenciaPonto;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="ITEM_LEITURA_AQUIVO_PONTO")
public class ItemLeituraArquivoPonto
implements InterfaceVO {
    private Long identificador;
    private PontoColaborador pontoColaborador;
    private Date dataResumo;
    private Short diaUtil;
    private Short diaFolga;
    private Short informarManual;
    private TipoOcorrenciaPonto tipoOcorrenciaPonto;
    private Date entrada1;
    private Date saida1;
    private Date entrada2;
    private Date saida2;
    private Date entrada3;
    private Date saida3;
    private Date entrada4;
    private Date saida4;
    private Double totalHorasTrabalhadas;
    private Double totalHorasATrabalhar;
    private Double totalHorasNoturnas;
    private Double totalHorasExtras;
    private Double saldoHoras;
    private Short abonarDia;
    private String motivoAbono;
    private HorarioTrabalho horario;
    private InfoHorarioTrabalho infoHorario;
    private Date dataMarcacao;
    private String dadosItemAntesAlteracao;
    private Date dataAtualizacao;

    public ItemLeituraArquivoPonto() {
        this.diaFolga = 0;
        this.diaUtil = 0;
        this.totalHorasATrabalhar = 0.0;
        this.totalHorasExtras = 0.0;
        this.totalHorasNoturnas = 0.0;
        this.totalHorasTrabalhadas = 0.0;
        this.saldoHoras = 0.0;
        this.abonarDia = 0;
        this.informarManual = 0;
    }

    public ItemLeituraArquivoPonto(Date data) {
        this.dataResumo = ToolDate.dataSemHora((Date)data);
        this.entrada1 = ToolDate.dataSemHora((Date)data);
        this.entrada2 = ToolDate.dataSemHora((Date)data);
        this.entrada3 = ToolDate.dataSemHora((Date)data);
        this.entrada4 = ToolDate.dataSemHora((Date)data);
        this.saida1 = ToolDate.dataSemHora((Date)data);
        this.saida2 = ToolDate.dataSemHora((Date)data);
        this.saida3 = ToolDate.dataSemHora((Date)data);
        this.saida4 = ToolDate.dataSemHora((Date)data);
        this.diaFolga = 0;
        this.diaUtil = 0;
        this.informarManual = 0;
        this.totalHorasATrabalhar = 0.0;
        this.totalHorasExtras = 0.0;
        this.totalHorasNoturnas = 0.0;
        this.totalHorasTrabalhadas = 0.0;
        this.saldoHoras = 0.0;
        this.abonarDia = 0;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ITEM_LEITURA_PTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_LEITURA_PTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PONTO_COLABORADOR", foreignKey=@ForeignKey(name="FK_ITEM_PONTO_PONTO_COL"))
    public PontoColaborador getPontoColaborador() {
        return this.pontoColaborador;
    }

    public void setPontoColaborador(PontoColaborador pontoColaborador) {
        this.pontoColaborador = pontoColaborador;
    }

    @Column(name="DATA_RESUMO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataResumo() {
        return this.dataResumo;
    }

    public void setDataResumo(Date dataResumo) {
        this.dataResumo = dataResumo;
    }

    @Column(name="DIA_UTIL")
    public Short getDiaUtil() {
        return this.diaUtil;
    }

    public void setDiaUtil(Short diaUtil) {
        this.diaUtil = diaUtil;
    }

    @Column(name="DIA_FOLGA")
    public Short getDiaFolga() {
        return this.diaFolga;
    }

    public void setDiaFolga(Short diaFolga) {
        this.diaFolga = diaFolga;
    }

    @Column(name="TOTAL_HORAS_TRABALHADAS", precision=15, scale=2)
    public Double getTotalHorasTrabalhadas() {
        return this.totalHorasTrabalhadas;
    }

    public void setTotalHorasTrabalhadas(Double totalHorasTrabalhadas) {
        this.totalHorasTrabalhadas = totalHorasTrabalhadas;
    }

    @Column(name="TOTAL_HORAS_A_TRABALHAR", precision=15, scale=2)
    public Double getTotalHorasATrabalhar() {
        return this.totalHorasATrabalhar;
    }

    public void setTotalHorasATrabalhar(Double totalHorasATrabalhar) {
        this.totalHorasATrabalhar = totalHorasATrabalhar;
    }

    @Column(name="TOTAL_HORAS_NOTURNAS", precision=15, scale=2)
    public Double getTotalHorasNoturnas() {
        return this.totalHorasNoturnas;
    }

    public void setTotalHorasNoturnas(Double totalHorasNoturnas) {
        this.totalHorasNoturnas = totalHorasNoturnas;
    }

    @Column(name="TOTAL_HORAS_EXTRAS", precision=15, scale=2)
    public Double getTotalHorasExtras() {
        return this.totalHorasExtras;
    }

    public void setTotalHorasExtras(Double totalHorasExtras) {
        this.totalHorasExtras = totalHorasExtras;
    }

    @Column(name="SALDO_HORAS", precision=15, scale=2)
    public Double getSaldoHoras() {
        return this.saldoHoras;
    }

    public void setSaldoHoras(Double saldoHoras) {
        this.saldoHoras = saldoHoras;
    }

    @Column(name="ABONAR_DIA")
    public Short getAbonarDia() {
        return this.abonarDia;
    }

    public void setAbonarDia(Short abonarDia) {
        this.abonarDia = abonarDia;
    }

    @Column(name="MOTIVO_ABONO", length=100)
    public String getMotivoAbono() {
        return this.motivoAbono;
    }

    public void setMotivoAbono(String motivoAbono) {
        this.motivoAbono = motivoAbono;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OCORRENCIA_PONTO", foreignKey=@ForeignKey(name="FK_LEITURA_PONTO_OCORRENCIA"))
    public TipoOcorrenciaPonto getTipoOcorrenciaPonto() {
        return this.tipoOcorrenciaPonto;
    }

    public void setTipoOcorrenciaPonto(TipoOcorrenciaPonto tipoOcorrenciaPonto) {
        this.tipoOcorrenciaPonto = tipoOcorrenciaPonto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HORARIO_TRABALHO")
    public HorarioTrabalho getHorario() {
        return this.horario;
    }

    public void setHorario(HorarioTrabalho horario) {
        this.horario = horario;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="entrada_1")
    public Date getEntrada1() {
        return this.entrada1;
    }

    public void setEntrada1(Date entrada1) {
        this.entrada1 = entrada1;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="saida_1")
    public Date getSaida1() {
        return this.saida1;
    }

    public void setSaida1(Date saida1) {
        this.saida1 = saida1;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="entrada_2")
    public Date getEntrada2() {
        return this.entrada2;
    }

    public void setEntrada2(Date entrada2) {
        this.entrada2 = entrada2;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="saida_2")
    public Date getSaida2() {
        return this.saida2;
    }

    public void setSaida2(Date saida2) {
        this.saida2 = saida2;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="entrada_3")
    public Date getEntrada3() {
        return this.entrada3;
    }

    public void setEntrada3(Date entrada3) {
        this.entrada3 = entrada3;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="saida_3")
    public Date getSaida3() {
        return this.saida3;
    }

    public void setSaida3(Date saida3) {
        this.saida3 = saida3;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="entrada_4")
    public Date getEntrada4() {
        return this.entrada4;
    }

    public void setEntrada4(Date entrada4) {
        this.entrada4 = entrada4;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="saida_4")
    public Date getSaida4() {
        return this.saida4;
    }

    public void setSaida4(Date saida4) {
        this.saida4 = saida4;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_info_horario")
    public InfoHorarioTrabalho getInfoHorario() {
        return this.infoHorario;
    }

    public void setInfoHorario(InfoHorarioTrabalho infoHorario) {
        this.infoHorario = infoHorario;
    }

    @Column(name="data_marcacao")
    @Temporal(value=TemporalType.DATE)
    public Date getDataMarcacao() {
        return this.dataMarcacao;
    }

    public void setDataMarcacao(Date dataMarcacao) {
        this.dataMarcacao = dataMarcacao;
    }

    @Column(name="INFORMAR_MANUAL")
    public Short getInformarManual() {
        return this.informarManual;
    }

    public void setInformarManual(Short informarManual) {
        this.informarManual = informarManual;
    }

    @Column(name="DADOS_ITEM_ANTES_ALTERACAO")
    public String getDadosItemAntesAlteracao() {
        return this.dadosItemAntesAlteracao;
    }

    public void setDadosItemAntesAlteracao(String dadosItemAntesAlteracao) {
        this.dadosItemAntesAlteracao = dadosItemAntesAlteracao;
    }

    @Version
    @Column(name="data_atualizacao")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

