/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LANCAMENTO")
public class Lancamento
implements InterfaceVO {
    private Long identificador;
    private LoteContabil loteContabil;
    private PlanoConta planoContaDeb;
    private PlanoConta planoContaCred;
    private HistoricoPadrao historicoPadrao;
    private Double valor = 0.0;
    private String historico;
    private Date dataCadastro;
    private Short gerado = 0;
    private Date dataLancamento;
    private CentroResultadoContFin centroResultadoContFin;
    private GrupoEmpresa grupoEmpresa;
    private Empresa empresa;
    private List<LancamentoCTBCentroCustos> lancamentosCtbCentroCustos = new ArrayList<LancamentoCTBCentroCustos>();

    @Id
    @Column(name="ID_LANCAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_LANCAMENTO_LOTE_CONTABIL"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_LANCAMENTO_DEB"))
    public PlanoConta getPlanoContaDeb() {
        return this.planoContaDeb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_LANCAMENTO_CRED"))
    public PlanoConta getPlanoContaCred() {
        return this.planoContaCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_LANCAMENTO_HISTORICO_PADRAO"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    public void setIdentificador(Long idLancamento) {
        this.identificador = idLancamento;
    }

    public void setLoteContabil(LoteContabil numeroLote) {
        this.loteContabil = numeroLote;
    }

    public void setPlanoContaDeb(PlanoConta planoContaDeb) {
        this.planoContaDeb = planoContaDeb;
    }

    public void setPlanoContaCred(PlanoConta planoContaCred) {
        this.planoContaCred = planoContaCred;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="GERADO")
    public Short getGerado() {
        return this.gerado;
    }

    public void setGerado(Short gerado) {
        this.gerado = gerado;
    }

    @Column(name="DATA_LANCAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_RESULTADO_CONT_FIN", foreignKey=@ForeignKey(name="FK_LANCAMENTO_CEN_RES_CONT_F"))
    public CentroResultadoContFin getCentroResultadoContFin() {
        return this.centroResultadoContFin;
    }

    public void setCentroResultadoContFin(CentroResultadoContFin centroResultadoContFin) {
        this.centroResultadoContFin = centroResultadoContFin;
    }

    @OneToMany(mappedBy="lancamentoContabil", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LancamentoCTBCentroCustos> getLancamentosCtbCentroCustos() {
        return this.lancamentosCtbCentroCustos;
    }

    public void setLancamentosCtbCentroCustos(List<LancamentoCTBCentroCustos> lancamentosCtbCentroCustos) {
        this.lancamentosCtbCentroCustos = lancamentosCtbCentroCustos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_GR_EMPRESA"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

