/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ItemLinhaTransporteColaborador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LINHA_TRANSPORTE_COLABORADOR")
public class LinhaTransporteColaborador
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short descontar = 0;
    private Short creditarFolha = 0;
    private String registroAlternativo;
    private Integer quantidadeTotalDiaria = 0;
    private List<ItemLinhaTransporteColaborador> linhasTransporte = new ArrayList<ItemLinhaTransporteColaborador>();
    private Colaborador colaborador;
    private Double valorTotalVale = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_LINHA_TRANS_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LINHA_TRANS_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCONTAR")
    public Short getDescontar() {
        return this.descontar;
    }

    public void setDescontar(Short descontar) {
        this.descontar = descontar;
    }

    @Column(name="CREDITAR_FOLHA")
    public Short getCreditarFolha() {
        return this.creditarFolha;
    }

    public void setCreditarFolha(Short creditarFolha) {
        this.creditarFolha = creditarFolha;
    }

    @Column(name="REGISTRO_ALTERNATIVO", length=15)
    public String getRegistroAlternativo() {
        return this.registroAlternativo;
    }

    public void setRegistroAlternativo(String registroAlternativo) {
        this.registroAlternativo = registroAlternativo;
    }

    @Column(name="QUANTIDADE_TOTAL_DIARIA")
    public Integer getQuantidadeTotalDiaria() {
        return this.quantidadeTotalDiaria;
    }

    public void setQuantidadeTotalDiaria(Integer quantidadeTotalDiaria) {
        this.quantidadeTotalDiaria = quantidadeTotalDiaria;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="paramLinhaTrans", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemLinhaTransporteColaborador> getLinhasTransporte() {
        return this.linhasTransporte;
    }

    public void setLinhasTransporte(List<ItemLinhaTransporteColaborador> linhasTransporte) {
        this.linhasTransporte = linhasTransporte;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_LINHA_TRANSPORTE_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="VALOR_TOTAL_VALE", precision=15, scale=2)
    public Double getValorTotalVale() {
        return this.valorTotalVale;
    }

    public void setValorTotalVale(Double valorTotalVale) {
        this.valorTotalVale = valorTotalVale;
    }
}

