/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoNFe;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="LOTE_EVENTOS_NFE")
public class LoteEventosNFe
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Short status = 0;
    private String motivoRetorno;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private List<EventoNFe> eventosNFe = new ArrayList<EventoNFe>();
    private VersaoNFe versaoNFe;
    private TipoEmissaoNFe tipoEmissaoNFe;
    private Short tipoLote = 0;
    private Short tipoUrl = 0;

    @Id
    @Column(name="ID_LOTE_EVENTOS_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_EVENTOS_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="MOTIVO_RETORNO", length=1000)
    public String getMotivoRetorno() {
        return this.motivoRetorno;
    }

    public void setMotivoRetorno(String motivoRetorno) {
        this.motivoRetorno = motivoRetorno;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_NFE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="loteEventosNFe", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SELECT)
    public List<EventoNFe> getEventosNFe() {
        return this.eventosNFe;
    }

    public void setEventosNFe(List<EventoNFe> eventosNFe) {
        this.eventosNFe = eventosNFe;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_VERSAO_NFE", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_NFE_VERSAO_NFE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public VersaoNFe getVersaoNFe() {
        return this.versaoNFe;
    }

    public void setVersaoNFe(VersaoNFe versaoNFe) {
        this.versaoNFe = versaoNFe;
    }

    @JoinColumn(name="ID_TIPO_EMISSAO_NFE", foreignKey=@ForeignKey(name="FK_LOTE_EVENTOS_NFE_TP_EM_NFE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEmissaoNFe getTipoEmissaoNFe() {
        return this.tipoEmissaoNFe;
    }

    public void setTipoEmissaoNFe(TipoEmissaoNFe tipoEmissaoNFe) {
        this.tipoEmissaoNFe = tipoEmissaoNFe;
    }

    @Column(name="TIPO_LOTE")
    public Short getTipoLote() {
        return this.tipoLote;
    }

    public void setTipoLote(Short tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Column(name="TIPO_URL")
    public Short getTipoUrl() {
        return this.tipoUrl;
    }

    public void setTipoUrl(Short tipoUrl) {
        this.tipoUrl = tipoUrl;
    }
}

