/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ModeloRpsCategoriaPessoa;
import com.touchcomp.basementor.model.vo.ModeloRpsCidade;
import com.touchcomp.basementor.model.vo.ModeloRpsEmpresa;
import com.touchcomp.basementor.model.vo.ModeloRpsServico;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoRps;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.ReinfTipoServico;
import com.touchcomp.basementor.model.vo.TipoRps;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="MODELO_RPS")
public class ModeloRPS
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private TipoRps tipoRps;
    private NaturezaOperacaoRps naturezaOperacaoRps;
    private Short gerarFinanceiro;
    private Short tipoIss;
    private Short tipoIRRF;
    private Short tipoINSS;
    private Short tipoOutros;
    private Short tipoPis;
    private Short tipoCofins;
    private Short tipoContSoc;
    private IncidenciaPisCofins incidenciaPisCofins;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short contabilizar;
    private Short entradaSaida;
    private String serie;
    private List<ModeloRpsCidade> modeloRpsCidade;
    private List<ModeloRpsEmpresa> modeloRpsEmpresas;
    private Short tipoInscMunicipal;
    private Short ativo;
    private Short tipoAliquotaISS;
    private Double aliquotaISS = 0.0;
    private CNAE cnae;
    private String codigoTributacaoServ;
    private Double aliquotaPis = 0.0;
    private Double aliquotaCofins = 0.0;
    private Double aliquotaIRRF = 0.0;
    private Double aliquotaCSLL = 0.0;
    private Double aliquotaINSS = 0.0;
    private Double aliquotaOutros = 0.0;
    private Double percRedCSLL = 0.0;
    private Double valorMinimoCSLL = 0.0;
    private Double valorMinimoIR = 0.0;
    private Double valorMinimoPis = 0.0;
    private Double valorMinimoCofins = 0.0;
    private Double valorMinimoInss = 0.0;
    private Double valorMinimoOutros = 0.0;
    private Double valorMinimoISS = 0.0;
    private Short gerarLancAdicPisCofinsST = EnumConstantsMentorSimNao.NAO.getValue();
    private Short incidirDescInss;
    private Short incidirDescPis;
    private Short incidirDescCofins;
    private Short incidirDescIR;
    private Short incidirDescCSLL;
    private Short incidirDescISS;
    private Short incidirDescOutros;
    private ObjectObsDinamica observacaoDinamica;
    private ReinfTipoServico reinfTipoServico;
    private Short compoemFluxoVenda;
    private Double percRedInss = 0.0;
    private Double percRedIss = 0.0;
    private List<ModeloRpsCategoriaPessoa> modeloRpsCategoriaPessoa;
    private List<ModeloRpsServico> modeloRpsServico;
    private ModeloFiscalCbsIbs modeloFiscalCbsIbs;

    public ModeloRPS() {
        this.gerarFinanceiro = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoIss = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoIRRF = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoINSS = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoOutros = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoPis = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoCofins = EnumConstantsMentorSimNao.NAO.getValue();
        this.tipoContSoc = EnumConstantsMentorSimNao.NAO.getValue();
        this.contabilizar = EnumConstantsMentorSimNao.NAO.getValue();
        this.entradaSaida = EnumConstantsMentorSimNao.NAO.getValue();
        this.modeloRpsCidade = new ArrayList<ModeloRpsCidade>();
        this.modeloRpsEmpresas = new ArrayList<ModeloRpsEmpresa>();
        this.modeloRpsCategoriaPessoa = new ArrayList<ModeloRpsCategoriaPessoa>();
        this.modeloRpsServico = new ArrayList<ModeloRpsServico>();
        this.tipoInscMunicipal = EnumConstantsMentorSimNao.NAO.getValue();
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
        this.tipoAliquotaISS = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescInss = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescPis = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescCofins = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescIR = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescCSLL = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescISS = EnumConstantsMentorSimNao.NAO.getValue();
        this.incidirDescOutros = EnumConstantsMentorSimNao.NAO.getValue();
        this.compoemFluxoVenda = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_MODELO_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_RPS", foreignKey=@ForeignKey(name="FK_MODELO_RPS_TP_RPS"))
    public TipoRps getTipoRps() {
        return this.tipoRps;
    }

    public void setTipoRps(TipoRps tipoRps) {
        this.tipoRps = tipoRps;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO_RPS", foreignKey=@ForeignKey(name="FK_MODELO_RPS_NAT_RPS"))
    public NaturezaOperacaoRps getNaturezaOperacaoRps() {
        return this.naturezaOperacaoRps;
    }

    public void setNaturezaOperacaoRps(NaturezaOperacaoRps naturezaOperacaoRps) {
        this.naturezaOperacaoRps = naturezaOperacaoRps;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="TIPO_ISS")
    public Short getTipoIss() {
        return this.tipoIss;
    }

    public void setTipoIss(Short tipoIss) {
        this.tipoIss = tipoIss;
    }

    @Column(name="TIPO_IRRF")
    public Short getTipoIRRF() {
        return this.tipoIRRF;
    }

    public void setTipoIRRF(Short tipoIRRF) {
        this.tipoIRRF = tipoIRRF;
    }

    @Column(name="TIPO_INSS")
    public Short getTipoINSS() {
        return this.tipoINSS;
    }

    public void setTipoINSS(Short tipoINSS) {
        this.tipoINSS = tipoINSS;
    }

    @Column(name="TIPO_OUTROS")
    public Short getTipoOutros() {
        return this.tipoOutros;
    }

    public void setTipoOutros(Short tipoOutros) {
        this.tipoOutros = tipoOutros;
    }

    @Column(name="TIPO_PIS")
    public Short getTipoPis() {
        return this.tipoPis;
    }

    public void setTipoPis(Short tipoPis) {
        this.tipoPis = tipoPis;
    }

    @Column(name="TIPO_COFINS")
    public Short getTipoCofins() {
        return this.tipoCofins;
    }

    public void setTipoCofins(Short tipoCofins) {
        this.tipoCofins = tipoCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_MODELO_RPS_INC_PIS_COFINS"))
    public IncidenciaPisCofins getIncidenciaPisCofins() {
        return this.incidenciaPisCofins;
    }

    public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
        this.incidenciaPisCofins = incidenciaPisCofins;
    }

    @Column(name="TIPO_CONT_SOC")
    public Short getTipoContSoc() {
        return this.tipoContSoc;
    }

    public void setTipoContSoc(Short tipoContSoc) {
        this.tipoContSoc = tipoContSoc;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_RPS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CONTABILIZAR")
    public Short getContabilizar() {
        return this.contabilizar;
    }

    public void setContabilizar(Short contabilizar) {
        this.contabilizar = contabilizar;
    }

    @Column(name="ENTRADA_SAIDA")
    public Short getEntradaSaida() {
        return this.entradaSaida;
    }

    public void setEntradaSaida(Short entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @OneToMany(mappedBy="modeloRps", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ModeloRpsCidade> getModeloRpsCidade() {
        return this.modeloRpsCidade;
    }

    public void setModeloRpsCidade(List<ModeloRpsCidade> modeloRpsCidade) {
        this.modeloRpsCidade = modeloRpsCidade;
    }

    @OneToMany(mappedBy="modeloRps", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ModeloRpsEmpresa> getModeloRpsEmpresas() {
        return this.modeloRpsEmpresas;
    }

    public void setModeloRpsEmpresas(List<ModeloRpsEmpresa> modeloRpsEmpresas) {
        this.modeloRpsEmpresas = modeloRpsEmpresas;
    }

    @Column(name="TIPO_INSC_MUNICIPAL")
    public Short getTipoInscMunicipal() {
        return this.tipoInscMunicipal;
    }

    public void setTipoInscMunicipal(Short tipoInscMunicipal) {
        this.tipoInscMunicipal = tipoInscMunicipal;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="TIPO_ALIQUOTA_ISS")
    public Short getTipoAliquotaISS() {
        return this.tipoAliquotaISS;
    }

    public void setTipoAliquotaISS(Short tipoAliquotaISS) {
        this.tipoAliquotaISS = tipoAliquotaISS;
    }

    @Column(name="ALIQUOTA_ISS", precision=15, scale=6)
    public Double getAliquotaISS() {
        return this.aliquotaISS;
    }

    public void setAliquotaISS(Double aliquotaISS) {
        this.aliquotaISS = aliquotaISS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_MODELO_RPS_CNAE"))
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @Column(name="CODIGO_TRIBUTACAO_SERV", length=20)
    public String getCodigoTributacaoServ() {
        return this.codigoTributacaoServ;
    }

    public void setCodigoTributacaoServ(String codigoTributacaoServ) {
        this.codigoTributacaoServ = codigoTributacaoServ;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=2)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="ALIQUOTA_COFINS", precision=15, scale=2)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @Column(name="ALIQUOTA_IRRF", precision=15, scale=2)
    public Double getAliquotaIRRF() {
        return this.aliquotaIRRF;
    }

    public void setAliquotaIRRF(Double aliquotaIRRF) {
        this.aliquotaIRRF = aliquotaIRRF;
    }

    @Column(name="ALIQUOTA_CSLL", precision=15, scale=2)
    public Double getAliquotaCSLL() {
        return this.aliquotaCSLL;
    }

    public void setAliquotaCSLL(Double aliquotaCSLL) {
        this.aliquotaCSLL = aliquotaCSLL;
    }

    @Column(name="ALIQUOTA_INSS", precision=15, scale=2)
    public Double getAliquotaINSS() {
        return this.aliquotaINSS;
    }

    public void setAliquotaINSS(Double aliquotaINSS) {
        this.aliquotaINSS = aliquotaINSS;
    }

    @Column(name="ALIQUOTA_OUTROS", precision=15, scale=2)
    public Double getAliquotaOutros() {
        return this.aliquotaOutros;
    }

    public void setAliquotaOutros(Double aliquotaOutros) {
        this.aliquotaOutros = aliquotaOutros;
    }

    @Column(name="PERC_RED_CSLL", precision=15, scale=2)
    public Double getPercRedCSLL() {
        return this.percRedCSLL;
    }

    public void setPercRedCSLL(Double percRedCSLL) {
        this.percRedCSLL = percRedCSLL;
    }

    @Column(name="VALOR_MINIMO_CSLL", precision=15, scale=2)
    public Double getValorMinimoCSLL() {
        return this.valorMinimoCSLL;
    }

    public void setValorMinimoCSLL(Double valorMinimoCSLL) {
        this.valorMinimoCSLL = valorMinimoCSLL;
    }

    @Column(name="VALOR_MINIMO_IR", precision=15, scale=2)
    public Double getValorMinimoIR() {
        return this.valorMinimoIR;
    }

    public void setValorMinimoIR(Double valorMinimoIR) {
        this.valorMinimoIR = valorMinimoIR;
    }

    @Column(name="VALOR_MINIMO_PIS", precision=15, scale=2)
    public Double getValorMinimoPis() {
        return this.valorMinimoPis;
    }

    public void setValorMinimoPis(Double valorMinimoPis) {
        this.valorMinimoPis = valorMinimoPis;
    }

    @Column(nullable=false, name="VALOR_MINIMO_COFINS", precision=15, scale=2)
    public Double getValorMinimoCofins() {
        return this.valorMinimoCofins;
    }

    public void setValorMinimoCofins(Double valorMinimoCofins) {
        this.valorMinimoCofins = valorMinimoCofins;
    }

    @Column(name="VALOR_MINIMO_INSS", precision=15, scale=2)
    public Double getValorMinimoInss() {
        return this.valorMinimoInss;
    }

    public void setValorMinimoInss(Double valorMinimoInss) {
        this.valorMinimoInss = valorMinimoInss;
    }

    @Column(nullable=false, name="VALOR_MINIMO_OUTROS", precision=15, scale=2)
    public Double getValorMinimoOutros() {
        return this.valorMinimoOutros;
    }

    public void setValorMinimoOutros(Double valorMinimoOutros) {
        this.valorMinimoOutros = valorMinimoOutros;
    }

    @Column(nullable=false, name="VALOR_MINIMO_ISS", precision=15, scale=2)
    public Double getValorMinimoISS() {
        return this.valorMinimoISS;
    }

    public void setValorMinimoISS(Double valorMinimoISS) {
        this.valorMinimoISS = valorMinimoISS;
    }

    @Column(name="GERAR_LANC_ADIC_PIS_COFINS_ST")
    public Short getGerarLancAdicPisCofinsST() {
        return this.gerarLancAdicPisCofinsST;
    }

    public void setGerarLancAdicPisCofinsST(Short gerarLancAdicPisCofinsST) {
        this.gerarLancAdicPisCofinsST = gerarLancAdicPisCofinsST;
    }

    @Column(nullable=false, name="INCIDIR_DESC_INSS")
    public Short getIncidirDescInss() {
        return this.incidirDescInss;
    }

    public void setIncidirDescInss(Short incidirDescInss) {
        this.incidirDescInss = incidirDescInss;
    }

    @Column(nullable=false, name="INCIDIR_DESC_PIS")
    public Short getIncidirDescPis() {
        return this.incidirDescPis;
    }

    public void setIncidirDescPis(Short incidirDescPis) {
        this.incidirDescPis = incidirDescPis;
    }

    @Column(nullable=false, name="INCIDIR_DESC_COFINS")
    public Short getIncidirDescCofins() {
        return this.incidirDescCofins;
    }

    public void setIncidirDescCofins(Short incidirDescCofins) {
        this.incidirDescCofins = incidirDescCofins;
    }

    @Column(nullable=false, name="INCIDIR_DESC_IR")
    public Short getIncidirDescIR() {
        return this.incidirDescIR;
    }

    public void setIncidirDescIR(Short incidirDescIR) {
        this.incidirDescIR = incidirDescIR;
    }

    @Column(nullable=false, name="INCIDIR_DESC_CSLL")
    public Short getIncidirDescCSLL() {
        return this.incidirDescCSLL;
    }

    public void setIncidirDescCSLL(Short incidirDescCSLL) {
        this.incidirDescCSLL = incidirDescCSLL;
    }

    @Column(nullable=false, name="INCIDIR_DESC_ISS")
    public Short getIncidirDescISS() {
        return this.incidirDescISS;
    }

    public void setIncidirDescISS(Short incidirDescISS) {
        this.incidirDescISS = incidirDescISS;
    }

    @Column(nullable=false, name="INCIDIR_DESC_OUTROS")
    public Short getIncidirDescOutros() {
        return this.incidirDescOutros;
    }

    public void setIncidirDescOutros(Short incidirDescOutros) {
        this.incidirDescOutros = incidirDescOutros;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBSERVACAO_DINAMICA", foreignKey=@ForeignKey(name="FK_MODELO_RPS_OBS_DINAMICA"))
    public ObjectObsDinamica getObservacaoDinamica() {
        return this.observacaoDinamica;
    }

    public void setObservacaoDinamica(ObjectObsDinamica observacaoDinamica) {
        this.observacaoDinamica = observacaoDinamica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO_REINF", foreignKey=@ForeignKey(name="FK_MODELO_RPS_TP_SERVICO"))
    public ReinfTipoServico getReinfTipoServico() {
        return this.reinfTipoServico;
    }

    public void setReinfTipoServico(ReinfTipoServico reinfTipoServico) {
        this.reinfTipoServico = reinfTipoServico;
    }

    @Column(nullable=false, name="COMPOEM_FLUXO_VENDA")
    public Short getCompoemFluxoVenda() {
        return this.compoemFluxoVenda;
    }

    public void setCompoemFluxoVenda(Short compoemFluxoVenda) {
        this.compoemFluxoVenda = compoemFluxoVenda;
    }

    @Column(name="PERC_RED_INSS")
    public Double getPercRedInss() {
        return this.percRedInss;
    }

    public void setPercRedInss(Double percRedInss) {
        this.percRedInss = percRedInss;
    }

    @Column(name="PERC_RED_ISS")
    public Double getPercRedIss() {
        return this.percRedIss;
    }

    public void setPercRedIss(Double percRedIss) {
        this.percRedIss = percRedIss;
    }

    @OneToMany(mappedBy="modeloRps", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ModeloRpsCategoriaPessoa> getModeloRpsCategoriaPessoa() {
        return this.modeloRpsCategoriaPessoa;
    }

    public void setModeloRpsCategoriaPessoa(List<ModeloRpsCategoriaPessoa> modeloRpsCategoriaPessoa) {
        this.modeloRpsCategoriaPessoa = modeloRpsCategoriaPessoa;
    }

    @OneToMany(mappedBy="modeloRps", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ModeloRpsServico> getModeloRpsServico() {
        return this.modeloRpsServico;
    }

    public void setModeloRpsServico(List<ModeloRpsServico> modeloRpsServico) {
        this.modeloRpsServico = modeloRpsServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_fiscal_cbs_ibs")
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        return this.modeloFiscalCbsIbs;
    }

    public void setModeloFiscalCbsIbs(ModeloFiscalCbsIbs modeloFiscalCbsIbs) {
        this.modeloFiscalCbsIbs = modeloFiscalCbsIbs;
    }
}

