/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoOcorrenciaPonto;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MOV_PTO_COLABORADOR")
public class MovPtoColaborador
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataOcorrencia;
    private TipoOcorrenciaPonto tipoOcorrencia;
    private Double referencia = 0.0;
    private Date horaInicial;
    private Date horaFinal;
    private Short abonar = 0;
    private Short cancelarMovimentacao = 0;
    private String observacao;
    private String motivoCancelamento;
    private CentroCusto centroCusto;
    private Colaborador colaboradorSubstituido;
    private Short houveSubstuicao = 0;
    private Colaborador colaborador;
    private Short informarHoraManual = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_MOV_PTO_COLABORADOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOV_PTO_COLABORADOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_OCORRENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataOcorrencia() {
        return this.dataOcorrencia;
    }

    public void setDataOcorrencia(Date dataOcorrencia) {
        this.dataOcorrencia = dataOcorrencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OCORRENCIA", foreignKey=@ForeignKey(name="FK_MOV_PTO_TIPO_OCORRENCIA"))
    public TipoOcorrenciaPonto getTipoOcorrencia() {
        return this.tipoOcorrencia;
    }

    public void setTipoOcorrencia(TipoOcorrenciaPonto tipoOcorrencia) {
        this.tipoOcorrencia = tipoOcorrencia;
    }

    @Column(name="REFERENCIA", precision=15, scale=2)
    public Double getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Double referencia) {
        this.referencia = referencia;
    }

    @Column(name="HORA_INICIAL")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraInicial() {
        return this.horaInicial;
    }

    public void setHoraInicial(Date horaInicial) {
        this.horaInicial = horaInicial;
    }

    @Column(name="HORA_FINAL")
    @Temporal(value=TemporalType.TIME)
    public Date getHoraFinal() {
        return this.horaFinal;
    }

    public void setHoraFinal(Date horaFinal) {
        this.horaFinal = horaFinal;
    }

    @Column(name="ABONAR")
    public Short getAbonar() {
        return this.abonar;
    }

    public void setAbonar(Short abonar) {
        this.abonar = abonar;
    }

    @Column(name="CANCELAR_MOVIMENTACAO")
    public Short getCancelarMovimentacao() {
        return this.cancelarMovimentacao;
    }

    public void setCancelarMovimentacao(Short cancelarMovimentacao) {
        this.cancelarMovimentacao = cancelarMovimentacao;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=1000)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_MOV_PTO_COLABORADOR_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} {1}", (Object[])new Object[]{this.getColaborador(), ToolDate.dateToStr((Date)this.getDataOcorrencia())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR_SUBSTITUIDO", foreignKey=@ForeignKey(name="FK_MOV_PTO_COLABORADOR"))
    public Colaborador getColaboradorSubstituido() {
        return this.colaboradorSubstituido;
    }

    public void setColaboradorSubstituido(Colaborador colaboradorSubstituido) {
        this.colaboradorSubstituido = colaboradorSubstituido;
    }

    @Column(name="HOUVE_SUBSTITUICAO")
    public Short getHouveSubstuicao() {
        return this.houveSubstuicao;
    }

    public void setHouveSubstuicao(Short houveSubstuicao) {
        this.houveSubstuicao = houveSubstuicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_MOV_COLABORADOR_PTO_COLABORA"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOV_PTO_COLABORADOR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INFORMAR_HORA_MANUAL")
    public Short getInformarHoraManual() {
        return this.informarHoraManual;
    }

    public void setInformarHoraManual(Short informarHoraManual) {
        this.informarHoraManual = informarHoraManual;
    }
}

