/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalCatPessoa;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalEmpresa;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalNCM;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalObsContrib;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalObsFisco;
import com.touchcomp.basementor.model.vo.NFCeModeloFiscalProd;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="NFCE_MODELO_FISCAL")
public class NFCeModeloFiscal
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private String descricaoNatOperacao;
    private Cfop cfop;
    private ObjectObsDinamica observacaoGeralFisco;
    private ObjectObsDinamica observacaoGeralContribuinte;
    private List<NFCeModeloFiscalObsFisco> observacoesIntFisco;
    private List<NFCeModeloFiscalObsContrib> observacoesIntContrib = new LinkedList<NFCeModeloFiscalObsContrib>();
    private List<NFCeModeloFiscalEmpresa> empresas;
    private Short ativo = 1;
    private Short opcaoContabilizacao = 0;
    private Short movimentacaoFisica = 0;
    private Short imprimirPrevImpInfProd = 0;
    private Short filtrarNCM = 0;
    private List<NFCeModeloFiscalNCM> ncms;
    private Short filtrarProduto = 0;
    private NFCeModeloFiscalProd nfceModeloFiscalProd;
    private Short filtrarCategoriaPessoa = 0;
    private List<NFCeModeloFiscalCatPessoa> categoriaPessoa;
    private ModeloFiscalIcms modeloFiscalIcms;
    private ModeloFiscalPisCofins modeloFiscalPisCofins;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Short tipoIss = 0;
    private Double valorMinimoISS = 0.0;

    public NFCeModeloFiscal() {
        this.observacoesIntFisco = new LinkedList<NFCeModeloFiscalObsFisco>();
        this.categoriaPessoa = new LinkedList<NFCeModeloFiscalCatPessoa>();
        this.ncms = new LinkedList<NFCeModeloFiscalNCM>();
        this.empresas = new LinkedList<NFCeModeloFiscalEmpresa>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Id
    @Column(nullable=false, name="ID_NFCE_MODELO_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NFCE_MODELO_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="DESCRICAO_NAT_OPERACAO", length=40)
    public String getDescricaoNatOperacao() {
        return this.descricaoNatOperacao;
    }

    public void setDescricaoNatOperacao(String descricaoNatOperacao) {
        this.descricaoNatOperacao = descricaoNatOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CFOP", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_CFOP"))
    public Cfop getCfop() {
        return this.cfop;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBS_GERAL_FISCO", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_OBS_G_FISCO"))
    public ObjectObsDinamica getObservacaoGeralFisco() {
        return this.observacaoGeralFisco;
    }

    public void setObservacaoGeralFisco(ObjectObsDinamica observacaoGeralFisco) {
        this.observacaoGeralFisco = observacaoGeralFisco;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OBS_GERAL_CONT", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_OBS_G_CONT"))
    public ObjectObsDinamica getObservacaoGeralContribuinte() {
        return this.observacaoGeralContribuinte;
    }

    public void setObservacaoGeralContribuinte(ObjectObsDinamica observacaoGeralContribuinte) {
        this.observacaoGeralContribuinte = observacaoGeralContribuinte;
    }

    @OneToMany(mappedBy="modeloFiscalNFCe", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public List<NFCeModeloFiscalObsFisco> getObservacoesIntFisco() {
        return this.observacoesIntFisco;
    }

    public void setObservacoesIntFisco(List<NFCeModeloFiscalObsFisco> observacoesIntFisco) {
        this.observacoesIntFisco = observacoesIntFisco;
    }

    @OneToMany(mappedBy="modeloFiscalNFCe", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public List<NFCeModeloFiscalObsContrib> getObservacoesIntContrib() {
        return this.observacoesIntContrib;
    }

    public void setObservacoesIntContrib(List<NFCeModeloFiscalObsContrib> observacoesIntContrib) {
        this.observacoesIntContrib = observacoesIntContrib;
    }

    @OneToMany(mappedBy="modeloFiscalNFCe", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public List<NFCeModeloFiscalEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<NFCeModeloFiscalEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="OPCAO_CONTABILIZACAO")
    public Short getOpcaoContabilizacao() {
        return this.opcaoContabilizacao;
    }

    public void setOpcaoContabilizacao(Short opcaoContabilizacao) {
        this.opcaoContabilizacao = opcaoContabilizacao;
    }

    @Column(nullable=false, name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    @Column(nullable=false, name="IMPRIMIR_PREV_IMP_INF_PROD")
    public Short getImprimirPrevImpInfProd() {
        return this.imprimirPrevImpInfProd;
    }

    public void setImprimirPrevImpInfProd(Short imprimirPrevImpInfProd) {
        this.imprimirPrevImpInfProd = imprimirPrevImpInfProd;
    }

    @Column(nullable=false, name="FILTRAR_NCM")
    public Short getFiltrarNCM() {
        return this.filtrarNCM;
    }

    public void setFiltrarNCM(Short filtrarNCM) {
        this.filtrarNCM = filtrarNCM;
    }

    @OneToMany(mappedBy="modeloFiscalNFCe", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public List<NFCeModeloFiscalNCM> getNcms() {
        return this.ncms;
    }

    public void setNcms(List<NFCeModeloFiscalNCM> ncms) {
        this.ncms = ncms;
    }

    @Column(nullable=false, name="FILTRAR_PRODUTO")
    public Short getFiltrarProduto() {
        return this.filtrarProduto;
    }

    public void setFiltrarProduto(Short filtrarProduto) {
        this.filtrarProduto = filtrarProduto;
    }

    @OneToOne(mappedBy="nfceModeloFiscal", cascade={CascadeType.ALL, CascadeType.MERGE})
    public NFCeModeloFiscalProd getNfceModeloFiscalProd() {
        return this.nfceModeloFiscalProd;
    }

    public void setNfceModeloFiscalProd(NFCeModeloFiscalProd nfceModeloFiscalProd) {
        this.nfceModeloFiscalProd = nfceModeloFiscalProd;
    }

    @Column(nullable=false, name="FILTRAR_CAT_PESSOA")
    public Short getFiltrarCategoriaPessoa() {
        return this.filtrarCategoriaPessoa;
    }

    public void setFiltrarCategoriaPessoa(Short filtrarCategoriaPessoa) {
        this.filtrarCategoriaPessoa = filtrarCategoriaPessoa;
    }

    @OneToMany(mappedBy="modeloFiscalNFCe", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public List<NFCeModeloFiscalCatPessoa> getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(List<NFCeModeloFiscalCatPessoa> categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL_ICMS", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_MOD_FISC_ICM"))
    public ModeloFiscalIcms getModeloFiscalIcms() {
        return this.modeloFiscalIcms;
    }

    public void setModeloFiscalIcms(ModeloFiscalIcms modeloFiscalIcms) {
        this.modeloFiscalIcms = modeloFiscalIcms;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_FISCAL_PIS_COFINS", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_MOD_PIS_COFI"))
    public ModeloFiscalPisCofins getModeloFiscalPisCofins() {
        return this.modeloFiscalPisCofins;
    }

    public void setModeloFiscalPisCofins(ModeloFiscalPisCofins modeloFiscalPisCofins) {
        this.modeloFiscalPisCofins = modeloFiscalPisCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MOD_FISCAL_NFCE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="TIPO_ISS")
    public Short getTipoIss() {
        return this.tipoIss;
    }

    public void setTipoIss(Short tipoIss) {
        this.tipoIss = tipoIss;
    }

    @Column(name="VALOR_MINIMO_ISS", precision=15, scale=2)
    public Double getValorMinimoISS() {
        return this.valorMinimoISS;
    }

    public void setValorMinimoISS(Double valorMinimoISS) {
        this.valorMinimoISS = valorMinimoISS;
    }
}

